/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nls;

public class IgnoredSettingsPanel
implements SearchableConfigurable {
    private JList myList;
    private JButton myAddButton;
    private JButton myEditButton;
    private JButton myRemoveButton;
    private JPanel myPanel;
    private final Project myProject;
    private DefaultListModel myModel;
    private final ChangeListManager myChangeListManager;

    public IgnoredSettingsPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myList.setCellRenderer(new MyCellRenderer());
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgnoredSettingsPanel.this.addItem();
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgnoredSettingsPanel.this.editItem();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgnoredSettingsPanel.this.deleteItems();
            }
        });
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    private void setItems(IgnoredFileBean[] filesToIgnore) {
        this.myModel = new DefaultListModel();
        for (IgnoredFileBean bean : filesToIgnore) {
            this.myModel.addElement(bean);
        }
        this.myList.setModel(this.myModel);
    }

    public IgnoredFileBean[] getItems() {
        int count = this.myList.getModel().getSize();
        IgnoredFileBean[] result = new IgnoredFileBean[count];
        for (int i = 0; i < count; ++i) {
            result[i] = (IgnoredFileBean)this.myList.getModel().getElementAt(i);
        }
        return result;
    }

    private void addItem() {
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        dlg.show();
        if (dlg.isOK()) {
            IgnoredFileBean[] ignoredFiles;
            for (IgnoredFileBean bean : ignoredFiles = dlg.getSelectedIgnoredFiles()) {
                this.myModel.addElement(bean);
            }
        }
    }

    private void editItem() {
        IgnoredFileBean bean = (IgnoredFileBean)this.myList.getSelectedValue();
        if (bean == null) {
            return;
        }
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        dlg.setIgnoredFile(bean);
        dlg.show();
        if (dlg.isOK()) {
            IgnoredFileBean[] beans = dlg.getSelectedIgnoredFiles();
            assert (beans.length == 1);
            int selectedIndex = this.myList.getSelectedIndex();
            this.myModel.setElementAt(beans[0], selectedIndex);
        }
    }

    private void deleteItems() {
        boolean contigiousSelection = true;
        int minSelectionIndex = this.myList.getSelectionModel().getMinSelectionIndex();
        int maxSelectionIndex = this.myList.getSelectionModel().getMaxSelectionIndex();
        for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
            if (this.myList.getSelectionModel().isSelectedIndex(i)) continue;
            contigiousSelection = false;
            break;
        }
        if (contigiousSelection) {
            this.myModel.removeRange(minSelectionIndex, maxSelectionIndex);
        } else {
            Object[] selection;
            for (Object item : selection = this.myList.getSelectedValues()) {
                this.myModel.removeElement(item);
            }
        }
    }

    public void reset() {
        this.setItems(this.myChangeListManager.getFilesToIgnore());
    }

    public void apply() {
        this.myChangeListManager.setFilesToIgnore(this.getItems());
    }

    public boolean isModified() {
        return !Comparing.equal((Object[])this.myChangeListManager.getFilesToIgnore(), (Object[])this.getItems());
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Ignored Files";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Ignored.Files";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JList jList;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddButton = jButton3 = new JButton();
        jButton3.setText("Add...");
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEditButton = jButton2 = new JButton();
        jButton2.setText("Edit...");
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        jButton.setText("Remove");
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myList = jList = new JList();
        jScrollPane.setViewportView(jList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer {
        private MyCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            IgnoredFileBean bean = (IgnoredFileBean)value;
            String path = bean.getPath();
            if (path != null) {
                if (path.endsWith("/")) {
                    this.append(VcsBundle.message((String)"ignored.configure.item.directory", (Object[])new Object[]{path}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(VcsBundle.message((String)"ignored.configure.item.file", (Object[])new Object[]{path}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (bean.getMask() != null) {
                this.append(VcsBundle.message((String)"ignored.configure.item.mask", (Object[])new Object[]{bean.getMask()}), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }
}

