/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class TreeLinkMouseListener
extends LinkMouseListenerBase {
    private final ColoredTreeCellRenderer myRenderer;
    protected TreeNode myLastHitNode;

    public TreeLinkMouseListener(ColoredTreeCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    protected void showTooltip(JTree tree, MouseEvent e, HaveTooltip launcher) {
        String newText;
        String text = tree.getToolTipText(e);
        String string = newText = launcher == null ? null : launcher.getTooltip();
        if (!Comparing.equal((String)text, (String)newText)) {
            tree.setToolTipText(newText);
        }
    }

    @Override
    @Nullable
    protected Object getTagAt(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        Object tag = null;
        HaveTooltip haveTooltip = null;
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            int i;
            Rectangle rectangle = tree.getPathBounds(path);
            int dx = e.getX() - rectangle.x;
            TreeNode treeNode = (TreeNode)path.getLastPathComponent();
            if (this.myLastHitNode != treeNode) {
                this.myLastHitNode = treeNode;
                this.myRenderer.getTreeCellRendererComponent(tree, (Object)treeNode, false, false, treeNode.isLeaf(), -1, false);
            }
            if ((i = this.myRenderer.findFragmentAt(dx)) >= 0) {
                tag = this.myRenderer.getFragmentTag(i);
                if (treeNode instanceof HaveTooltip) {
                    haveTooltip = (HaveTooltip)((Object)treeNode);
                }
            }
        }
        this.showTooltip(tree, e, haveTooltip);
        return tag;
    }

    public static interface HaveTooltip {
        public String getTooltip();
    }

    public static class BrowserLauncher
    implements Runnable {
        private final String myUrl;

        public BrowserLauncher(String url) {
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.launchBrowser((String)this.myUrl);
        }
    }
}

