/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import org.jetbrains.annotations.NotNull;

public class RunBackgroundable {
    private RunBackgroundable() {
    }

    public static void run(final @NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/committed/RunBackgroundable.run must not be null");
        }
        ProgressManager pm = ProgressManager.getInstance();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            pm.run(task);
        } else {
            try {
                task.run(pm.getProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        task.onCancel();
                    }
                });
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    task.onSuccess();
                }
            });
        }
    }
}

