/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.vcs.changes.CallbackData");
    private final Runnable myCallback;
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback, @Nullable Runnable wrapperStarter) {
        if (callback == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/CallbackData.<init> must not be null");
        }
        this.myCallback = callback;
        this.myWrapperStarter = wrapperStarter;
    }

    public Runnable getCallback() {
        return this.myCallback;
    }

    public Runnable getWrapperStarter() {
        return this.myWrapperStarter;
    }

    public static CallbackData create(final Runnable afterUpdate, String title, ModalityState state, final InvokeAfterUpdateMode mode, final Project project) {
        if (mode.isSilently()) {
            return new CallbackData(new Runnable(){

                @Override
                public void run() {
                    if (mode.isCallbackOnAwt()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LOG.debug("invokeAfterUpdate: silent wrapper called for project: " + project.getName());
                                if (project.isDisposed()) {
                                    return;
                                }
                                afterUpdate.run();
                                ChangesViewManager.getInstance(project).refreshView();
                            }
                        });
                    } else {
                        ApplicationManager.getApplication().executeOnPooledThread(afterUpdate);
                    }
                }
            }, null);
        }
        if (mode.isSynchronous()) {
            final Waiter waiter = new Waiter(project, afterUpdate, state, VcsBundle.message((String)"change.list.manager.wait.lists.synchronization", (Object[])new Object[]{title}), mode.isCancellable());
            return new CallbackData(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("invokeAfterUpdate: NOT silent SYNCHRONOUS wrapper called for project: " + project.getName());
                    waiter.done();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((Task)waiter);
                }
            });
        }
        final FictiveBackgroundable fictiveBackgroundable = new FictiveBackgroundable(project, afterUpdate, mode.isCancellable(), title, state);
        return new CallbackData(new Runnable(){

            @Override
            public void run() {
                LOG.debug("invokeAfterUpdate: NOT silent wrapper called for project: " + project.getName());
                fictiveBackgroundable.done();
            }
        }, new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)fictiveBackgroundable);
            }
        });
    }
}

