/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import java.awt.AWTKeyStroke;
import java.awt.Robot;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ActionCommand
extends TypeCommand {
    public static String PREFIX = CMD_PREFIX + "action";

    public ActionCommand(String text, int line) {
        super(text, line);
    }

    @Override
    protected ActionCallback _execute(PlaybackRunner.StatusCallback cb, Robot robot, boolean directActionCall) {
        String actionName = this.getText().substring(PREFIX.length()).trim();
        final AnAction action = ActionManager.getInstance().getAction(actionName);
        if (action == null) {
            this.dumpError(cb, "Unknown action: " + actionName);
            return new ActionCallback.Rejected();
        }
        if (!directActionCall) {
            Shortcut[] sc = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionName);
            AWTKeyStroke stroke = null;
            for (Shortcut each : sc) {
                if (!(each instanceof KeyboardShortcut)) continue;
                KeyboardShortcut ks = (KeyboardShortcut)each;
                KeyStroke first = ks.getFirstKeyStroke();
                KeyStroke second = ks.getSecondKeyStroke();
                if (first == null || second != null) continue;
                stroke = KeyStroke.getKeyStroke(first.getKeyCode(), first.getModifiers(), false);
                break;
            }
            if (stroke != null) {
                cb.message("Invoking action via shortcut: " + stroke.toString(), this.getLine());
                this.type(robot, (KeyStroke)stroke);
                return new ActionCallback.Done();
            }
        }
        final InputEvent input = this.getInputEvent(actionName);
        final ActionCallback result = new ActionCallback();
        robot.delay(Registry.intValue((String)"actionSystem.playback.autodelay"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionManager.getInstance().tryToExecute(action, input, null, null, false).notifyWhenDone(result);
            }
        });
        return result;
    }

    private InputEvent getInputEvent(String actionName) {
        Shortcut each;
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionName);
        AWTKeyStroke keyStroke = null;
        Shortcut[] arr$ = shortcuts;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (each = arr$[i$]) instanceof KeyboardShortcut && (keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke()) != null); ++i$) {
        }
        if (keyStroke != null) {
            return new KeyEvent(JOptionPane.getRootFrame(), 401, System.currentTimeMillis(), keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar(), 1);
        }
        return new MouseEvent(JOptionPane.getRootFrame(), 501, 0L, 0, 0, 0, 1, false, 1);
    }
}

