/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.openapi.util.IconLoader;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ShadowBorderPainter {
    private static final Icon TOP = IconLoader.getIcon((String)"/ide/shadow/top.png");
    private static final Icon TOP_RIGHT = IconLoader.getIcon((String)"/ide/shadow/top-right.png");
    private static final Icon RIGHT = IconLoader.getIcon((String)"/ide/shadow/right.png");
    private static final Icon BOTTOM_RIGHT = IconLoader.getIcon((String)"/ide/shadow/bottom-right.png");
    private static final Icon BOTTOM = IconLoader.getIcon((String)"/ide/shadow/bottom.png");
    private static final Icon BOTTOM_LEFT = IconLoader.getIcon((String)"/ide/shadow/bottom-left.png");
    private static final Icon LEFT = IconLoader.getIcon((String)"/ide/shadow/left.png");
    private static final Icon TOP_LEFT = IconLoader.getIcon((String)"/ide/shadow/top-left.png");
    public static final int SIDE_SIZE = 35;
    public static final int TOP_SIZE = 20;
    public static final int BOTTOM_SIZE = 49;
    private static final Icon POPUP_TOP = IconLoader.getIcon((String)"/ide/shadow/popup/top.png");
    private static final Icon POPUP_TOP_RIGHT = IconLoader.getIcon((String)"/ide/shadow/popup/top-right.png");
    private static final Icon POPUP_RIGHT = IconLoader.getIcon((String)"/ide/shadow/popup/right.png");
    private static final Icon POPUP_BOTTOM_RIGHT = IconLoader.getIcon((String)"/ide/shadow/popup/bottom-right.png");
    private static final Icon POPUP_BOTTOM = IconLoader.getIcon((String)"/ide/shadow/popup/bottom.png");
    private static final Icon POPUP_BOTTOM_LEFT = IconLoader.getIcon((String)"/ide/shadow/popup/bottom-left.png");
    private static final Icon POPUP_LEFT = IconLoader.getIcon((String)"/ide/shadow/popup/left.png");
    private static final Icon POPUP_TOP_LEFT = IconLoader.getIcon((String)"/ide/shadow/popup/top-left.png");
    public static final int POPUP_SIDE_SIZE = 7;
    public static final int POPUP_TOP_SIZE = 4;
    public static final int POPUP_BOTTOM_SIZE = 10;

    private ShadowBorderPainter() {
    }

    public static BufferedImage createShadow(JComponent c, int width, int height, boolean isPopup) {
        int _x;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = graphicsConfiguration.createCompatibleImage(width, height, 3);
        Graphics2D g = image.createGraphics();
        Icon topLeft = isPopup ? POPUP_TOP_LEFT : TOP_LEFT;
        Icon topRight = isPopup ? POPUP_TOP_RIGHT : TOP_RIGHT;
        Icon bottom = isPopup ? POPUP_BOTTOM : BOTTOM;
        Icon top = isPopup ? POPUP_TOP : TOP;
        Icon bottomRight = isPopup ? POPUP_BOTTOM_RIGHT : BOTTOM_RIGHT;
        Icon bottomLeft = isPopup ? POPUP_BOTTOM_LEFT : BOTTOM_LEFT;
        Icon left = isPopup ? POPUP_LEFT : LEFT;
        Icon right = isPopup ? POPUP_RIGHT : RIGHT;
        int sideSize = isPopup ? 7 : 35;
        int bottomSize = isPopup ? 10 : 49;
        topLeft.paintIcon(c, g, 0, 0);
        topRight.paintIcon(c, g, width - sideSize * 2, 0);
        for (_x = sideSize * 2; _x < width - sideSize * 2; ++_x) {
            top.paintIcon(c, g, _x, 0);
        }
        for (_x = bottomSize * 2; _x < width - bottomSize * 2; ++_x) {
            bottom.paintIcon(c, g, _x, height - bottomSize);
        }
        for (int _y = sideSize * 2; _y < height - bottomSize * 2; ++_y) {
            left.paintIcon(c, g, 0, _y);
            right.paintIcon(c, g, width - sideSize, _y);
        }
        bottomRight.paintIcon(c, g, width - bottomSize * 2, height - bottomSize * 2);
        bottomLeft.paintIcon(c, g, 0, height - bottomSize * 2);
        g.dispose();
        return image;
    }

    public static BufferedImage createShadow(JComponent c, int width, int height) {
        return ShadowBorderPainter.createShadow(c, width, height, false);
    }

    public static BufferedImage createPopupShadow(JComponent c, int width, int height) {
        return ShadowBorderPainter.createShadow(c, width, height, true);
    }
}

