/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="IdeDocumentHistory", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class IdeDocumentHistoryImpl
extends IdeDocumentHistory
implements ProjectComponent,
PersistentStateComponent<RecentlyChangedFilesState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl");
    private static final int BACK_QUEUE_LIMIT = 25;
    private static final int CHANGE_QUEUE_LIMIT = 25;
    private final Project myProject;
    private final EditorFactory myEditorFactory;
    private FileDocumentManager myFileDocumentManager;
    private final FileEditorManagerEx myEditorManager;
    private VirtualFileManager myVfManager;
    private CommandProcessor myCmdProcessor;
    private VirtualFileListener myFileListener;
    private ToolWindowManager myToolWindowManager;
    private final LinkedList<PlaceInfo> myBackPlaces = new LinkedList();
    private final LinkedList<PlaceInfo> myForwardPlaces = new LinkedList();
    private boolean myBackInProgress = false;
    private boolean myForwardInProgress = false;
    private Object myLastGroupId = null;
    private final LinkedList<PlaceInfo> myChangePlaces = new LinkedList();
    private int myStartIndex = 0;
    private int myCurrentIndex = 0;
    private PlaceInfo myCurrentChangePlace = null;
    private PlaceInfo myCommandStartPlace = null;
    private boolean myCurrentCommandIsNavigation = false;
    private boolean myCurrentCommandHasChanges = false;
    private final Set<VirtualFile> myChangedFilesInCurrentCommand = new THashSet();
    private boolean myCurrentCommandHasMoves = false;
    private DocumentListener myDocumentListener;
    private CaretListener myCaretListener;
    private final CommandListener myCommandListener = new CommandAdapter(){

        public void commandStarted(CommandEvent event) {
            IdeDocumentHistoryImpl.this.onCommandStarted();
        }

        public void commandFinished(CommandEvent event) {
            IdeDocumentHistoryImpl.this.onCommandFinished(event.getCommandGroupId());
        }
    };
    private RecentlyChangedFilesState myRecentlyChangedFiles = new RecentlyChangedFilesState();

    public IdeDocumentHistoryImpl(Project project, EditorFactory editorFactory, FileEditorManager editorManager, VirtualFileManager vfManager, CommandProcessor cmdProcessor, ToolWindowManager toolWindowManager) {
        this.myProject = project;
        this.myEditorFactory = editorFactory;
        this.myEditorManager = (FileEditorManagerEx)editorManager;
        this.myVfManager = vfManager;
        this.myCmdProcessor = cmdProcessor;
        this.myToolWindowManager = toolWindowManager;
    }

    public IdeDocumentHistoryImpl(Project project, EditorFactory editorFactory, FileEditorManager editorManager, VirtualFileManager vfManager, CommandProcessor cmdProcessor) {
        this(project, editorFactory, editorManager, vfManager, cmdProcessor, null);
    }

    public final void projectOpened() {
        EditorEventMulticaster eventMulticaster = this.myEditorFactory.getEventMulticaster();
        this.myDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                IdeDocumentHistoryImpl.this.onDocumentChanged(e);
            }
        };
        eventMulticaster.addDocumentListener(this.myDocumentListener);
        this.myCaretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                IdeDocumentHistoryImpl.this.onCaretPositionChanged(e);
            }
        };
        eventMulticaster.addCaretListener(this.myCaretListener);
        this.myEditorManager.addFileEditorManagerListener((FileEditorManagerListener)new FileEditorManagerAdapter(){

            public void selectionChanged(FileEditorManagerEvent e) {
                IdeDocumentHistoryImpl.this.onSelectionChanged();
            }
        });
        this.myFileListener = new VirtualFileAdapter(){

            public void fileDeleted(VirtualFileEvent event) {
                IdeDocumentHistoryImpl.this.onFileDeleted();
            }
        };
        this.myVfManager.addVirtualFileListener(this.myFileListener);
        this.myCmdProcessor.addCommandListener(this.myCommandListener);
    }

    public RecentlyChangedFilesState getState() {
        return this.myRecentlyChangedFiles;
    }

    public void loadState(RecentlyChangedFilesState state) {
        this.myRecentlyChangedFiles = state;
    }

    public final void onFileDeleted() {
        this.removeInvalidFilesFromStacks();
    }

    public final void onSelectionChanged() {
        this.myCurrentCommandIsNavigation = true;
        this.myCurrentCommandHasMoves = true;
    }

    private void onCaretPositionChanged(CaretEvent e) {
        if (e.getOldPosition().line == e.getNewPosition().line) {
            return;
        }
        Document document = e.getEditor().getDocument();
        if (this.getFileDocumentManager().getFile(document) != null) {
            this.myCurrentCommandHasMoves = true;
        }
    }

    private void onDocumentChanged(DocumentEvent e) {
        Document document = e.getDocument();
        VirtualFile file = this.getFileDocumentManager().getFile(document);
        if (file != null) {
            this.myCurrentCommandHasChanges = true;
            this.myChangedFilesInCurrentCommand.add(file);
        }
    }

    public final void onCommandStarted() {
        this.myCommandStartPlace = this.getCurrentPlaceInfo();
        this.myCurrentCommandIsNavigation = false;
        this.myCurrentCommandHasChanges = false;
        this.myCurrentCommandHasMoves = false;
        this.myChangedFilesInCurrentCommand.clear();
    }

    private PlaceInfo getCurrentPlaceInfo() {
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider = this.getSelectedEditor();
        if (selectedEditorWithProvider != null) {
            return this.createPlaceInfo((FileEditor)selectedEditorWithProvider.getFirst(), (FileEditorProvider)selectedEditorWithProvider.getSecond());
        }
        return null;
    }

    public final void onCommandFinished(Object commandGroupId) {
        if (this.myCommandStartPlace != null && this.myCurrentCommandIsNavigation && this.myCurrentCommandHasMoves) {
            if (!this.myBackInProgress) {
                if (!CommandMerger.canMergeGroup(commandGroupId, this.myLastGroupId)) {
                    IdeDocumentHistoryImpl.putLastOrMerge(this.myBackPlaces, this.myCommandStartPlace, 25);
                }
                if (!this.myForwardInProgress) {
                    this.myForwardPlaces.clear();
                }
            }
            this.removeInvalidFilesFromStacks();
        }
        this.myLastGroupId = commandGroupId;
        if (this.myCurrentCommandHasChanges) {
            this.setCurrentChangePlace();
        } else if (this.myCurrentCommandHasMoves) {
            this.pushCurrentChangePlace();
        }
    }

    public final void projectClosed() {
        EditorEventMulticaster eventMulticaster = this.myEditorFactory.getEventMulticaster();
        eventMulticaster.removeDocumentListener(this.myDocumentListener);
        eventMulticaster.removeCaretListener(this.myCaretListener);
        this.myVfManager.removeVirtualFileListener(this.myFileListener);
        this.myCmdProcessor.removeCommandListener(this.myCommandListener);
    }

    @Override
    public final void includeCurrentCommandAsNavigation() {
        this.myCurrentCommandIsNavigation = true;
    }

    @Override
    public final void includeCurrentPlaceAsChangePlace() {
        this.setCurrentChangePlace();
        this.pushCurrentChangePlace();
    }

    private void setCurrentChangePlace() {
        PlaceInfo lastInfo;
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider = this.getSelectedEditor();
        if (selectedEditorWithProvider == null) {
            return;
        }
        PlaceInfo placeInfo = this.createPlaceInfo((FileEditor)selectedEditorWithProvider.getFirst(), (FileEditorProvider)selectedEditorWithProvider.getSecond());
        VirtualFile file = placeInfo.getFile();
        if (this.myChangedFilesInCurrentCommand.contains(file)) {
            this.myRecentlyChangedFiles.register(file);
        }
        this.myCurrentChangePlace = placeInfo;
        if (!this.myChangePlaces.isEmpty() && IdeDocumentHistoryImpl.isSame(placeInfo, lastInfo = this.myChangePlaces.get(this.myChangePlaces.size() - 1))) {
            this.myChangePlaces.removeLast();
        }
        this.myCurrentIndex = this.myStartIndex + this.myChangePlaces.size();
    }

    private void pushCurrentChangePlace() {
        if (this.myCurrentChangePlace != null) {
            this.myChangePlaces.add(this.myCurrentChangePlace);
            if (this.myChangePlaces.size() > 25) {
                this.myChangePlaces.removeFirst();
                ++this.myStartIndex;
            }
            this.myCurrentChangePlace = null;
        }
        this.myCurrentIndex = this.myStartIndex + this.myChangePlaces.size();
    }

    @Override
    public VirtualFile[] getChangedFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        List<String> paths = this.myRecentlyChangedFiles.getChangedFiles();
        for (String path : paths) {
            VirtualFile file = lfs.findFileByPath(path);
            if (file == null) continue;
            files.add(file);
        }
        return VfsUtil.toVirtualFileArray(files);
    }

    @Override
    public final void clearHistory() {
        IdeDocumentHistoryImpl.clearPlaceList(this.myBackPlaces);
        IdeDocumentHistoryImpl.clearPlaceList(this.myForwardPlaces);
        IdeDocumentHistoryImpl.clearPlaceList(this.myChangePlaces);
        this.myLastGroupId = null;
        this.myStartIndex = 0;
        this.myCurrentIndex = 0;
        if (this.myCurrentChangePlace != null) {
            this.myCurrentChangePlace = null;
        }
        if (this.myCommandStartPlace != null) {
            this.myCommandStartPlace = null;
        }
    }

    @Override
    public final void back() {
        this.removeInvalidFilesFromStacks();
        if (this.myBackPlaces.isEmpty()) {
            return;
        }
        final PlaceInfo info = this.myBackPlaces.removeLast();
        PlaceInfo current = this.getCurrentPlaceInfo();
        if (current != null && !IdeDocumentHistoryImpl.isSame(current, info)) {
            IdeDocumentHistoryImpl.putLastOrMerge(this.myForwardPlaces, current, Integer.MAX_VALUE);
        }
        IdeDocumentHistoryImpl.putLastOrMerge(this.myForwardPlaces, info, Integer.MAX_VALUE);
        this.myBackInProgress = true;
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                IdeDocumentHistoryImpl.this.gotoPlaceInfo(info);
            }
        }, "", null);
        this.myBackInProgress = false;
    }

    @Override
    public final void forward() {
        this.removeInvalidFilesFromStacks();
        final PlaceInfo target = this.getTargetForwardInfo();
        if (target == null) {
            return;
        }
        this.myForwardInProgress = true;
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                IdeDocumentHistoryImpl.this.gotoPlaceInfo(target);
            }
        }, "", null);
        this.myForwardInProgress = false;
    }

    private PlaceInfo getTargetForwardInfo() {
        if (this.myForwardPlaces.isEmpty()) {
            return null;
        }
        PlaceInfo target = this.myForwardPlaces.removeLast();
        PlaceInfo current = this.getCurrentPlaceInfo();
        while (!this.myForwardPlaces.isEmpty() && IdeDocumentHistoryImpl.isSame(current, target)) {
            target = this.myForwardPlaces.removeLast();
        }
        return target;
    }

    @Override
    public final boolean isBackAvailable() {
        return !this.myBackPlaces.isEmpty();
    }

    @Override
    public final boolean isForwardAvailable() {
        return !this.myForwardPlaces.isEmpty();
    }

    @Override
    public final void navigatePreviousChange() {
        this.removeInvalidFilesFromStacks();
        if (this.myCurrentIndex == this.myStartIndex) {
            return;
        }
        int index = this.myCurrentIndex - 1;
        final PlaceInfo info = this.myChangePlaces.get(index - this.myStartIndex);
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                IdeDocumentHistoryImpl.this.gotoPlaceInfo(info);
            }
        }, "", null);
        this.myCurrentIndex = index;
    }

    @Override
    public final boolean isNavigatePreviousChangeAvailable() {
        return this.myCurrentIndex > this.myStartIndex;
    }

    private void removeInvalidFilesFromStacks() {
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myBackPlaces);
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myForwardPlaces);
        if (IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myChangePlaces)) {
            this.myCurrentIndex = this.myStartIndex + this.myChangePlaces.size();
        }
    }

    private static boolean removeInvalidFilesFrom(LinkedList<PlaceInfo> backPlaces) {
        boolean removed = false;
        Iterator iterator = backPlaces.iterator();
        while (iterator.hasNext()) {
            PlaceInfo info = (PlaceInfo)iterator.next();
            VirtualFile file = info.myFile;
            if (file.isValid()) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    private void gotoPlaceInfo(@NotNull PlaceInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl.gotoPlaceInfo must not be null");
        }
        boolean wasActive = this.myToolWindowManager.isEditorComponentActive();
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = this.myEditorManager.openFileWithProviders(info.getFile(), wasActive);
        FileEditor[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        for (int i = 0; i < editors.length; ++i) {
            String typeId = providers[i].getEditorTypeId();
            if (!typeId.equals(info.getEditorTypeId())) continue;
            editors[i].setState(info.getNavigationState());
        }
    }

    protected Pair<FileEditor, FileEditorProvider> getSelectedEditor() {
        VirtualFile[] selectedFiles = this.myEditorManager.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return null;
        }
        return this.myEditorManager.getSelectedEditorWithProvider(selectedFiles[0]);
    }

    private PlaceInfo createPlaceInfo(@NotNull FileEditor fileEditor, FileEditorProvider fileProvider) {
        if (fileEditor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl.createPlaceInfo must not be null");
        }
        VirtualFile file = this.myEditorManager.getFile(fileEditor);
        LOG.assertTrue(file != null);
        FileEditorState state = fileEditor.getState(FileEditorStateLevel.NAVIGATION);
        return new PlaceInfo(file, state, fileProvider.getEditorTypeId());
    }

    private static void clearPlaceList(LinkedList<PlaceInfo> list) {
        list.clear();
    }

    @NotNull
    public final String getComponentName() {
        if ("IdeDocumentHistory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl.getComponentName must not return null");
        }
        return "IdeDocumentHistory";
    }

    private static void putLastOrMerge(LinkedList<PlaceInfo> list, PlaceInfo next, int limitSizeLimit) {
        PlaceInfo prev;
        if (!list.isEmpty() && IdeDocumentHistoryImpl.isSame(prev = list.get(list.size() - 1), next)) {
            list.removeLast();
        }
        list.add(next);
        if (list.size() > limitSizeLimit) {
            list.removeFirst();
        }
    }

    private FileDocumentManager getFileDocumentManager() {
        if (this.myFileDocumentManager == null) {
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }
        return this.myFileDocumentManager;
    }

    public LinkedList<PlaceInfo> getBackPlaces() {
        return this.myBackPlaces;
    }

    public LinkedList<PlaceInfo> getForwardPlaces() {
        return this.myForwardPlaces;
    }

    public final void initComponent() {
    }

    public final void disposeComponent() {
        this.myLastGroupId = null;
    }

    protected void executeCommand(Runnable runnable, String name, Object groupId) {
        this.myCmdProcessor.executeCommand(this.myProject, runnable, name, groupId);
    }

    private static boolean isSame(PlaceInfo first, PlaceInfo second) {
        if (first.getFile().equals(second.getFile())) {
            FileEditorState secondState;
            FileEditorState firstState = first.getNavigationState();
            return firstState.equals(secondState = second.getNavigationState()) || firstState.canBeMergedWith(secondState, FileEditorStateLevel.NAVIGATION);
        }
        return false;
    }

    private static final class PlaceInfo {
        private final VirtualFile myFile;
        private final FileEditorState myNavigationState;
        private final String myEditorTypeId;

        public PlaceInfo(@NotNull VirtualFile file, FileEditorState navigationState, String editorTypeId) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo.<init> must not be null");
            }
            this.myNavigationState = navigationState;
            this.myFile = file;
            this.myEditorTypeId = editorTypeId;
        }

        public FileEditorState getNavigationState() {
            return this.myNavigationState;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo.getFile must not return null");
            }
            return virtualFile;
        }

        public String getEditorTypeId() {
            return this.myEditorTypeId;
        }

        public String toString() {
            return this.getFile().getName() + " " + this.getNavigationState();
        }
    }

    public static class RecentlyChangedFilesState {
        @Transient
        private List<String> CHANGED_PATHS = new ArrayList<String>();

        public List<String> getChangedFiles() {
            return this.CHANGED_PATHS;
        }

        public void setChangedFiles(List<String> changed) {
            this.CHANGED_PATHS = changed;
        }

        public void register(VirtualFile file) {
            String path = file.getPath();
            this.CHANGED_PATHS.remove(path);
            this.CHANGED_PATHS.add(path);
            this.trimToSize();
        }

        private void trimToSize() {
            int limit = UISettings.getInstance().RECENT_FILES_LIMIT + 1;
            while (this.CHANGED_PATHS.size() > limit) {
                this.CHANGED_PATHS.remove(0);
            }
        }
    }
}

