/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileEditorProviderManagerImpl
extends FileEditorProviderManager {
    private static final FileEditorProvider[] EMPTY_ARRAY = new FileEditorProvider[0];
    private final ArrayList<FileEditorProvider> myProviders = new ArrayList();
    private final ArrayList<FileEditorProvider> mySharedProviderList = new ArrayList();

    public FileEditorProviderManagerImpl(FileEditorProvider[] providers) {
        Extensions.getRootArea().getExtensionPoint(FileEditorProvider.EP_FILE_EDITOR_PROVIDER).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionAdded(FileEditorProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                FileEditorProviderManagerImpl.this.registerProvider(extension);
            }

            public void extensionRemoved(FileEditorProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                FileEditorProviderManagerImpl.this.unregisterProvider(extension);
            }
        });
        for (FileEditorProvider provider : providers) {
            this.registerProvider(provider);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public synchronized FileEditorProvider[] getProviders(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorProvider[] fileEditorProviderArray;
        int i;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl.getProviders must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl.getProviders must not be null");
        }
        this.mySharedProviderList.clear();
        boolean doNotShowTextEditor = false;
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        for (i = this.myProviders.size() - 1; i >= 0; --i) {
            FileEditorProvider provider = this.myProviders.get(i);
            if (dumb && !(provider instanceof DumbAware) || !provider.accept(project, file)) continue;
            this.mySharedProviderList.add(provider);
            doNotShowTextEditor |= provider.getPolicy() == FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        }
        if (doNotShowTextEditor) {
            for (i = this.mySharedProviderList.size() - 1; i >= 0; --i) {
                if (!(this.mySharedProviderList.get(i) instanceof TextEditorProvider)) continue;
                this.mySharedProviderList.remove(i);
            }
        }
        Collections.sort(this.mySharedProviderList, MyComparator.ourInstance);
        if (!this.mySharedProviderList.isEmpty()) {
            fileEditorProviderArray = this.mySharedProviderList.toArray(new FileEditorProvider[this.mySharedProviderList.size()]);
            if (fileEditorProviderArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl.getProviders must not return null");
            return fileEditorProviderArray;
        }
        fileEditorProviderArray = EMPTY_ARRAY;
        if (EMPTY_ARRAY != null) return fileEditorProviderArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl.getProviders must not return null");
    }

    @Override
    @Nullable
    public synchronized FileEditorProvider getProvider(@NotNull String editorTypeId) {
        if (editorTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl.getProvider must not be null");
        }
        for (int i = this.myProviders.size() - 1; i >= 0; --i) {
            FileEditorProvider provider = this.myProviders.get(i);
            if (!provider.getEditorTypeId().equals(editorTypeId)) continue;
            return provider;
        }
        return null;
    }

    private void registerProvider(FileEditorProvider provider) {
        String editorTypeId = provider.getEditorTypeId();
        for (int i = this.myProviders.size() - 1; i >= 0; --i) {
            FileEditorProvider _provider = this.myProviders.get(i);
            if (!editorTypeId.equals(_provider.getEditorTypeId())) continue;
            throw new IllegalArgumentException("attempt to register provider with non unique editorTypeId: " + _provider.getEditorTypeId());
        }
        this.myProviders.add(provider);
    }

    private void unregisterProvider(FileEditorProvider provider) {
        boolean b = this.myProviders.remove(provider);
        assert (b);
    }

    private static final class MyComparator
    implements Comparator<FileEditorProvider> {
        public static final MyComparator ourInstance = new MyComparator();

        private MyComparator() {
        }

        private static double getWeight(FileEditorProvider provider) {
            return provider instanceof WeighedFileEditorProvider ? ((WeighedFileEditorProvider)provider).getWeight() : Double.MAX_VALUE;
        }

        @Override
        public int compare(FileEditorProvider provider1, FileEditorProvider provider2) {
            int i2;
            int i1 = provider1.getPolicy().ordinal();
            if (i1 != (i2 = provider2.getPolicy().ordinal())) {
                return i1 - i2;
            }
            double value = MyComparator.getWeight(provider1) - MyComparator.getWeight(provider2);
            return value > 0.0 ? 1 : (value < 0.0 ? -1 : 0);
        }
    }
}

