/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.keymap.impl.ui.KeymapConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class TraverseUIStarter
implements ApplicationStarter {
    private String OUTPUT_PATH;
    @NonNls
    private static final String OPTIONS = "options";
    @NonNls
    private static final String CONFIGURABLE = "configurable";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String CONFIGURABLE_NAME = "configurable_name";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String HIT = "hit";

    @NonNls
    public String getCommandName() {
        return "traverseUI";
    }

    public void premain(String[] args) {
        this.OUTPUT_PATH = args[1];
    }

    public void main(String[] args) {
        System.out.println("Starting searchable options index builder");
        try {
            this.startup();
        }
        catch (Throwable e) {
            System.out.println("Searchable options index builder failed");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void startup() throws IOException {
        HashMap<SearchableConfigurable, TreeSet<OptionDescription>> options = new HashMap<SearchableConfigurable, TreeSet<OptionDescription>>();
        SearchUtil.processProjectConfigurables(ProjectManager.getInstance().getDefaultProject(), options);
        Element root = new Element(OPTIONS);
        for (SearchableConfigurable configurable : options.keySet()) {
            Element configurableElement = new Element(CONFIGURABLE);
            String id = configurable.getId();
            if (id == null) continue;
            configurableElement.setAttribute(ID, id);
            configurableElement.setAttribute(CONFIGURABLE_NAME, configurable.getDisplayName());
            TreeSet<OptionDescription> sortedOptions = options.get(configurable);
            for (OptionDescription option : sortedOptions) {
                TraverseUIStarter.append(option.getPath(), option.getHit(), option.getOption(), configurableElement);
            }
            if (configurable instanceof KeymapConfigurable) {
                TraverseUIStarter.processKeymap(configurableElement);
            } else if (configurable instanceof OptionsContainingConfigurable) {
                TraverseUIStarter.processColorAndFontsSettings((OptionsContainingConfigurable)configurable, configurableElement);
            } else if (configurable instanceof CodeStyleSchemesConfigurable) {
                TraverseUIStarter.processCodeStyleConfigurable((CodeStyleSchemesConfigurable)configurable, configurableElement);
            }
            root.addContent(configurableElement);
        }
        JDOMUtil.writeDocument((Document)new Document(root), (String)this.OUTPUT_PATH, (String)"\n");
        System.out.println("Searchable options index builder completed");
        ((ApplicationEx)ApplicationManager.getApplication()).exit(true);
    }

    private static void processCodeStyleConfigurable(CodeStyleSchemesConfigurable configurable, Element configurableElement) {
        TreeSet<OptionDescription> options = new TreeSet<OptionDescription>();
        options.addAll(configurable.processOptions());
        for (OptionDescription description : options) {
            TraverseUIStarter.append(description.getPath(), description.getHit(), description.getOption(), configurableElement);
        }
    }

    private static void processColorAndFontsSettings(OptionsContainingConfigurable configurable, Element configurableElement) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set<String> optionsPath = configurable.processListOptions();
        TreeSet<OptionDescription> result = new TreeSet<OptionDescription>();
        for (String opt : optionsPath) {
            Set words = searchableOptionsRegistrar.getProcessedWordsWithoutStemming(opt);
            for (String word : words) {
                if (word == null) continue;
                result.add(new OptionDescription(word, opt, null));
            }
        }
        for (OptionDescription option : result) {
            TraverseUIStarter.append(option.getPath(), option.getHit(), option.getOption(), configurableElement);
        }
    }

    private static void processKeymap(Element configurableElement) {
        ActionManager actionManager = ActionManager.getInstance();
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set<String> ids = ((ActionManagerImpl)actionManager).getActionIds();
        TreeSet<OptionDescription> options = new TreeSet<OptionDescription>();
        for (String id : ids) {
            String description;
            AnAction anAction = actionManager.getAction(id);
            String text = anAction.getTemplatePresentation().getText();
            if (text != null) {
                Set strings = searchableOptionsRegistrar.getProcessedWordsWithoutStemming(text);
                for (String word : strings) {
                    options.add(new OptionDescription(word, text, null));
                }
            }
            if ((description = anAction.getTemplatePresentation().getDescription()) == null) continue;
            Set strings = searchableOptionsRegistrar.getProcessedWordsWithoutStemming(description);
            for (String word : strings) {
                options.add(new OptionDescription(word, description, null));
            }
        }
        for (OptionDescription opt : options) {
            TraverseUIStarter.append(opt.getPath(), opt.getHit(), opt.getOption(), configurableElement);
        }
    }

    private static void append(String path, String hit, String word, Element configurableElement) {
        Element optionElement = new Element(OPTION);
        optionElement.setAttribute(NAME, word);
        if (path != null) {
            optionElement.setAttribute(PATH, path);
        }
        optionElement.setAttribute(HIT, hit);
        configurableElement.addContent(optionElement);
    }
}

