/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.ArrayUtil;

public class ScopePaneSelectInTarget
extends ProjectViewSelectInTarget {
    public ScopePaneSelectInTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.SCOPE;
    }

    @Override
    public boolean canSelect(PsiFileSystemItem fileSystemItem) {
        if (!super.canSelect(fileSystemItem)) {
            return false;
        }
        if (!(fileSystemItem instanceof PsiFile)) {
            return false;
        }
        PsiFile file = (PsiFile)fileSystemItem;
        DependencyValidationManager scopesHolder = DependencyValidationManager.getInstance((Project)this.myProject);
        Object[] allScopes = scopesHolder.getScopes();
        for (Object scope : allScopes = (NamedScope[])ArrayUtil.mergeArrays((Object[])allScopes, (Object[])NamedScopeManager.getInstance((Project)this.myProject).getScopes(), NamedScope.class)) {
            PackageSet packageSet = scope.getValue();
            if (packageSet == null || !packageSet.contains(file, (NamedScopesHolder)scopesHolder)) continue;
            return true;
        }
        return false;
    }

    public String getMinorViewId() {
        return "Scope";
    }

    public float getWeight() {
        return 6.5f;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    @Override
    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        if (context == null) {
            return false;
        }
        NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)subId);
        if (scope == null) {
            return false;
        }
        PackageSet packageSet = scope.getValue();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(context.getVirtualFile());
        return psiFile != null && packageSet != null && packageSet.contains(psiFile, NamedScopesHolder.getHolder((Project)this.myProject, (String)subId, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)this.myProject)));
    }
}

