/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlUtil;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlLikeFileType
extends LanguageFileType {
    public XmlLikeFileType(Language language) {
        super(language);
    }

    public String getCharset(@NotNull VirtualFile file, byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/highlighter/XmlLikeFileType.getCharset must not be null");
        }
        String charset = XmlUtil.extractXmlEncodingFromProlog(content);
        return charset == null ? "UTF-8" : charset;
    }

    public Charset extractCharsetFromFileContent(Project project, @Nullable VirtualFile file, @NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/highlighter/XmlLikeFileType.extractCharsetFromFileContent must not be null");
        }
        String name = XmlUtil.extractXmlEncodingFromProlog(content);
        Charset charset = CharsetToolkit.forName((String)name);
        return charset == null ? CharsetToolkit.UTF8_CHARSET : charset;
    }
}

