/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ControlPanelSettingsEditor;
import com.intellij.openapi.options.ex.ExplorerSettingsEditor;
import com.intellij.openapi.options.ex.IdeConfigurablesGroup;
import com.intellij.openapi.options.ex.ProjectConfigurablesGroup;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.awt.Component;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    @NonNls
    private static final String PREFER_CLASSIC_OPTIONS_EDITOR = "PREFER_CLASSIC_OPTIONS_EDITOR";

    public void showSettingsDialog(Project project, ConfigurableGroup[] group) {
        this._showSettingsDialog(project, group, null);
    }

    private void _showSettingsDialog(Project project, ConfigurableGroup[] group, Configurable toSelect) {
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        if ("false".equalsIgnoreCase(System.getProperty("new.options.editor"))) {
            if (Boolean.toString(true).equals(PropertiesComponent.getInstance().getValue(PREFER_CLASSIC_OPTIONS_EDITOR))) {
                ShowSettingsUtilImpl.showExplorerOptions(project, group);
            } else {
                ShowSettingsUtilImpl.showControlPanelOptions(project, group, toSelect);
            }
        } else {
            new OptionsEditorDialog(project, group, toSelect).show();
        }
    }

    public void showSettingsDialog(@Nullable Project project, Class configurableClass) {
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        Project actualProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        Configurable config = (Configurable)actualProject.getComponent(configurableClass);
        if (config == null) {
            config = (Configurable)ApplicationManager.getApplication().getComponent(configurableClass);
        }
        assert (config != null) : "Cannot find configurable: " + configurableClass.getName();
        this.showSettingsDialog(actualProject, config);
    }

    public void showSettingsDialog(@Nullable Project project, @NotNull String nameToSelect) {
        if (nameToSelect == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/ShowSettingsUtilImpl.showSettingsDialog must not be null");
        }
        ConfigurableGroup[] group = project == null ? new ConfigurableGroup[]{new IdeConfigurablesGroup()} : new ConfigurableGroup[]{new ProjectConfigurablesGroup(project, false), new IdeConfigurablesGroup()};
        Project actualProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        OptionsEditorDialog dialog = new OptionsEditorDialog(actualProject, group, nameToSelect);
        dialog.show();
    }

    public void showSettingsDialog(@NotNull Project project, Configurable toSelect) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/ShowSettingsUtilImpl.showSettingsDialog must not be null");
        }
        this._showSettingsDialog(project, new ConfigurableGroup[]{new ProjectConfigurablesGroup(project, false), new IdeConfigurablesGroup()}, toSelect);
    }

    private static ConfigurableGroup[] filterEmptyGroups(ConfigurableGroup[] group) {
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g : group) {
            if (g.getConfigurables().length <= 0) continue;
            groups.add(g);
        }
        return groups.toArray(new ConfigurableGroup[groups.size()]);
    }

    public static void showControlPanelOptions(Project project, ConfigurableGroup[] groups, Configurable preselectedConfigurable) {
        PropertiesComponent.getInstance().setValue(PREFER_CLASSIC_OPTIONS_EDITOR, Boolean.toString(false));
        ControlPanelSettingsEditor editor = new ControlPanelSettingsEditor(project, groups, preselectedConfigurable);
        editor.show();
    }

    public static void showExplorerOptions(Project project, ConfigurableGroup[] group) {
        PropertiesComponent.getInstance().setValue(PREFER_CLASSIC_OPTIONS_EDITOR, Boolean.toString(true));
        ExplorerSettingsEditor editor = new ExplorerSettingsEditor(project, group);
        editor.show();
    }

    public boolean editConfigurable(Project project, Configurable configurable) {
        SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
        configurableEditor.show();
        return configurableEditor.isOK();
    }

    public <T extends Configurable> T findApplicationConfigurable(Class<T> confClass) {
        return ShowSettingsUtilImpl.selectConfigurable(confClass, (Configurable[])ApplicationManager.getApplication().getExtensions(Configurable.APPLICATION_CONFIGURABLES));
    }

    public <T extends Configurable> T findProjectConfigurable(Project project, Class<T> confClass) {
        return ShowSettingsUtilImpl.selectConfigurable(confClass, (Configurable[])project.getExtensions(Configurable.PROJECT_CONFIGURABLES));
    }

    private static <T extends Configurable> T selectConfigurable(Class<T> confClass, Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            if (!confClass.isAssignableFrom(configurable.getClass())) continue;
            return (T)configurable;
        }
        throw new IllegalStateException("Can't find configurable of class " + confClass.getName());
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, Configurable configurable) {
        SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(project, configurable, dimensionServiceKey);
        configurableEditor.show();
        return configurableEditor.isOK();
    }

    public boolean editConfigurable(Component parent, Configurable configurable) {
        SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(parent, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
        configurableEditor.show();
        return configurableEditor.isOK();
    }

    public boolean editConfigurable(Component parent, Configurable configurable, Runnable advancedInitialization) {
        SingleConfigurableEditor editor = new SingleConfigurableEditor(parent, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
        advancedInitialization.run();
        editor.show();
        return editor.isOK();
    }

    private static String createDimensionKey(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(parent, configurable, dimensionServiceKey);
        configurableEditor.show();
        return configurableEditor.isOK();
    }

    public boolean editConfigurable(Project project, Configurable configurable, Runnable advancedInitialization) {
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
        advancedInitialization.run();
        editor.show();
        return editor.isOK();
    }
}

