/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.tree.Entry;
import java.util.List;

public abstract class ChangeSetsProcessor {
    protected LocalVcs myVcs;
    protected String myPath;
    protected Entry myEntry;

    public ChangeSetsProcessor(LocalVcs vcs, String path) {
        this.myVcs = vcs;
        this.myPath = path;
        this.myEntry = this.myVcs.getEntry(path);
    }

    protected void process() {
        List<Change> changes = this.collectChanges();
        if (changes.isEmpty()) {
            this.nothingToVisit();
            return;
        }
        for (Change c : changes) {
            if (c.isLabel()) {
                this.visitLabel(c);
                continue;
            }
            this.visitRegular(c);
        }
        Change lastChange = changes.get(changes.size() - 1);
        if (!lastChange.isLabel() && !lastChange.isCreationalFor(this.myEntry)) {
            this.visitFirstAvailableNonCreational(lastChange);
        }
    }

    protected abstract List<Change> collectChanges();

    protected abstract void nothingToVisit();

    protected abstract void visitLabel(Change var1);

    protected abstract void visitRegular(Change var1);

    protected abstract void visitFirstAvailableNonCreational(Change var1);
}

