/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindPackageUsagesDialog;
import com.intellij.find.findUsages.FindThrowUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindVariableUsagesDialog;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHandler
extends FindUsagesHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findUsages.DefaultFindUsagesHandler");
    public static final String ACTION_STRING = FindBundle.message("find.super.method.warning.action.verb", new Object[0]);
    private final PsiElement[] myElementsToSearch;
    private final FindUsagesOptions myFindPackageOptions;
    private final FindUsagesOptions myFindClassOptions;
    private final FindUsagesOptions myFindMethodOptions;
    private final FindUsagesOptions myFindVariableOptions;
    private final FindUsagesOptions myFindThrowOptions;

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions findClassOptions, @NotNull FindUsagesOptions findMethodOptions, @NotNull FindUsagesOptions findPackageOptions, @NotNull FindUsagesOptions findThrowOptions, @NotNull FindUsagesOptions findVariableOptions) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findClassOptions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findMethodOptions == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findPackageOptions == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findThrowOptions == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findVariableOptions == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        this(psiElement, PsiElement.EMPTY_ARRAY, findClassOptions, findMethodOptions, findPackageOptions, findThrowOptions, findVariableOptions);
    }

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull PsiElement[] elementsToSearch, @NotNull FindUsagesOptions findClassOptions, @NotNull FindUsagesOptions findMethodOptions, @NotNull FindUsagesOptions findPackageOptions, @NotNull FindUsagesOptions findThrowOptions, @NotNull FindUsagesOptions findVariableOptions) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (elementsToSearch == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findClassOptions == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findMethodOptions == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findPackageOptions == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findThrowOptions == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        if (findVariableOptions == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.<init> must not be null");
        }
        super(psiElement);
        this.myElementsToSearch = elementsToSearch;
        this.myFindClassOptions = findClassOptions;
        this.myFindMethodOptions = findMethodOptions;
        this.myFindPackageOptions = findPackageOptions;
        this.myFindThrowOptions = findThrowOptions;
        this.myFindVariableOptions = findVariableOptions;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        AbstractFindUsagesDialog abstractFindUsagesDialog;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            abstractFindUsagesDialog = new FindPackageUsagesDialog(element, this.getProject(), this.myFindPackageOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (abstractFindUsagesDialog == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesDialog must not return null");
            return abstractFindUsagesDialog;
        }
        if (element instanceof PsiClass) {
            abstractFindUsagesDialog = new FindClassUsagesDialog(element, this.getProject(), this.myFindClassOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (abstractFindUsagesDialog == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesDialog must not return null");
            return abstractFindUsagesDialog;
        }
        if (element instanceof PsiMethod) {
            abstractFindUsagesDialog = new FindMethodUsagesDialog(element, this.getProject(), this.myFindMethodOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (abstractFindUsagesDialog == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesDialog must not return null");
            return abstractFindUsagesDialog;
        }
        if (element instanceof PsiVariable) {
            abstractFindUsagesDialog = new FindVariableUsagesDialog(element, this.getProject(), this.myFindVariableOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (abstractFindUsagesDialog == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesDialog must not return null");
            return abstractFindUsagesDialog;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            abstractFindUsagesDialog = new FindThrowUsagesDialog(element, this.getProject(), this.myFindThrowOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (abstractFindUsagesDialog == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesDialog must not return null");
            return abstractFindUsagesDialog;
        }
        abstractFindUsagesDialog = super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
        if (abstractFindUsagesDialog != null) return abstractFindUsagesDialog;
        throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesDialog must not return null");
    }

    private static boolean askWhetherShouldSearchForParameterInOverridingMethods(PsiElement psiElement, PsiParameter parameter) {
        return Messages.showDialog((Project)psiElement.getProject(), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.prompt", parameter.getName()), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.title", new Object[0]), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)0, (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static PsiElement[] getParameterElementsToSearch(PsiParameter parameter) {
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        PsiMethod[] overrides = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        for (int i = 0; i < overrides.length; ++i) {
            overrides[i] = (PsiMethod)overrides[i].getNavigationElement();
        }
        PsiElement[] elementsToSearch = new PsiElement[overrides.length + 1];
        elementsToSearch[0] = parameter;
        int idx = method.getParameterList().getParameterIndex(parameter);
        for (int i = 0; i < overrides.length; ++i) {
            elementsToSearch[i + 1] = overrides[i].getParameterList().getParameters()[idx];
        }
        return elementsToSearch;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray;
        PsiElement[] psiElementArray2;
        PsiMethod method;
        PsiParameter parameter;
        PsiElement scope;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiParameter && (scope = (parameter = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PsiUtil.canBeOverriden((PsiMethod)(method = (PsiMethod)scope))) {
            boolean hasOverridden;
            PsiClass aClass = method.getContainingClass();
            LOG.assertTrue(aClass != null);
            boolean bl = hasOverridden = OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
            if (hasOverridden && JavaFindUsagesHandler.askWhetherShouldSearchForParameterInOverridingMethods(element, parameter)) {
                psiElementArray2 = JavaFindUsagesHandler.getParameterElementsToSearch(parameter);
                if (psiElementArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getPrimaryElements must not return null");
                return psiElementArray2;
            }
        }
        if (this.myElementsToSearch.length == 0) {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = element;
        } else {
            psiElementArray = psiElementArray2 = this.myElementsToSearch;
        }
        if (psiElementArray != null) return psiElementArray2;
        throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getPrimaryElements must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement[] getSecondaryElements() {
        PsiField field;
        PsiClass containingClass;
        PsiElement[] psiElementArray;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getSecondaryElements must not return null");
            return psiElementArray;
        }
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null) {
            String propertyName = JavaCodeStyleManager.getInstance((Project)this.getProject()).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            PsiMethod getter = PropertyUtil.findPropertyGetterWithType((String)propertyName, (boolean)field.hasModifierProperty("static"), (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()));
            PsiMethod setter = PropertyUtil.findPropertySetterWithType((String)propertyName, (boolean)field.hasModifierProperty("static"), (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()));
            if (getter != null || setter != null) {
                boolean doSearch;
                if (!(getter != null && getter.isPhysical() || setter != null && setter.isPhysical())) {
                    doSearch = true;
                } else {
                    boolean bl = doSearch = Messages.showDialog((String)FindBundle.message("find.field.accessors.prompt", field.getName()), (String)FindBundle.message("find.field.accessors.title", new Object[0]), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)0, (Icon)Messages.getQuestionIcon()) == 0;
                }
                if (doSearch) {
                    ArrayList<PsiMethod> elements = new ArrayList<PsiMethod>();
                    if (getter != null) {
                        elements.addAll(Arrays.asList(SuperMethodWarningUtil.checkSuperMethods(getter, ACTION_STRING)));
                    }
                    if (setter != null) {
                        elements.addAll(Arrays.asList(SuperMethodWarningUtil.checkSuperMethods(setter, ACTION_STRING)));
                    }
                    if ((psiElementArray = elements.toArray(new PsiElement[elements.size()])) == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getSecondaryElements must not return null");
                    return psiElementArray;
                }
            }
        }
        if ((psiElementArray = super.getSecondaryElements()) != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getSecondaryElements must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        FindUsagesOptions findUsagesOptions;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            findUsagesOptions = this.myFindPackageOptions;
            if (findUsagesOptions == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesOptions must not return null");
            return findUsagesOptions;
        }
        if (element instanceof PsiClass) {
            findUsagesOptions = this.myFindClassOptions;
            if (findUsagesOptions == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesOptions must not return null");
            return findUsagesOptions;
        }
        if (element instanceof PsiMethod) {
            findUsagesOptions = this.myFindMethodOptions;
            if (findUsagesOptions == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesOptions must not return null");
            return findUsagesOptions;
        }
        if (element instanceof PsiVariable) {
            findUsagesOptions = this.myFindVariableOptions;
            if (findUsagesOptions == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesOptions must not return null");
            return findUsagesOptions;
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            findUsagesOptions = this.myFindThrowOptions;
            if (findUsagesOptions == null) throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesOptions must not return null");
            return findUsagesOptions;
        }
        findUsagesOptions = super.getFindUsagesOptions();
        if (findUsagesOptions != null) return findUsagesOptions;
        throw new IllegalStateException("@NotNull method com/intellij/find/findUsages/JavaFindUsagesHandler.getFindUsagesOptions must not return null");
    }

    @Override
    protected String getStringToSearch(final PsiElement element) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiMetaData metaData;
                PsiElement norm = element;
                if (element instanceof PsiDirectory) {
                    norm = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
                }
                if (norm instanceof PsiPackage) {
                    return ((PsiPackage)norm).getQualifiedName();
                }
                if (norm instanceof PsiClass) {
                    return ((PsiClass)norm).getQualifiedName();
                }
                if (norm instanceof PsiMethod) {
                    return ((PsiMethod)norm).getName();
                }
                if (norm instanceof PsiVariable) {
                    return ((PsiVariable)norm).getName();
                }
                if (norm instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)norm).getMetaData()) != null) {
                    return metaData.getName();
                }
                if (norm instanceof PsiNamedElement) {
                    return ((PsiNamedElement)norm).getName();
                }
                if (norm instanceof XmlAttributeValue) {
                    return ((XmlAttributeValue)norm).getValue();
                }
                LOG.error("Unknown element type: " + element);
                return null;
            }
        });
    }

    @Override
    public void processElementUsages(final @NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor, final @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.processElementUsages must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.processElementUsages must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/findUsages/JavaFindUsagesHandler.processElementUsages must not be null");
        }
        if (element instanceof PsiVariable) {
            if (options.isReadAccess || options.isWriteAccess) {
                if (options.isReadAccess && options.isWriteAccess) {
                    JavaFindUsagesHandler.addElementUsages(element, processor, options);
                } else {
                    JavaFindUsagesHandler.addElementUsages(element, new Processor<UsageInfo>(){

                        public boolean process(UsageInfo info) {
                            boolean isWrite;
                            PsiElement element = info.getElement();
                            boolean bl = isWrite = element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element));
                            return isWrite != options.isWriteAccess || processor.process((Object)info);
                        }
                    }, options);
                }
            }
        } else if (options.isUsages) {
            JavaFindUsagesHandler.addElementUsages(element, processor, options);
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (ThrowSearchUtil.isSearchable(element) && options.isThrowUsages) {
                    ThrowSearchUtil.Root[] roots;
                    ThrowSearchUtil.Root root = (ThrowSearchUtil.Root)options.getUserData(ThrowSearchUtil.THROW_SEARCH_ROOT_KEY);
                    if (root == null && (roots = ThrowSearchUtil.getSearchRoots(element)) != null && roots.length > 0) {
                        root = roots[0];
                    }
                    if (root != null) {
                        ThrowSearchUtil.addThrowUsages((Processor<UsageInfo>)processor, root, options);
                    }
                }
            }
        });
        if (element instanceof PsiPackage && options.isClassesUsages) {
            JavaFindUsagesHandler.addClassesUsages((PsiPackage)element, processor, options);
        }
        if (element instanceof PsiClass && options.isMethodsUsages) {
            JavaFindUsagesHandler.addMethodsUsages((PsiClass)element, processor, options);
        }
        if (element instanceof PsiClass && options.isFieldsUsages) {
            JavaFindUsagesHandler.addFieldsUsages((PsiClass)element, processor, options);
        }
        if (element instanceof PsiClass) {
            if (((PsiClass)element).isInterface()) {
                if (options.isDerivedInterfaces) {
                    if (options.isImplementingClasses) {
                        JavaFindUsagesHandler.addInheritors((PsiClass)element, processor, options);
                    } else {
                        JavaFindUsagesHandler.addDerivedInterfaces((PsiClass)element, processor, options);
                    }
                } else if (options.isImplementingClasses) {
                    JavaFindUsagesHandler.addImplementingClasses((PsiClass)element, processor, options);
                }
            } else if (options.isDerivedClasses) {
                JavaFindUsagesHandler.addInheritors((PsiClass)element, processor, options);
            }
        }
        if (element instanceof PsiMethod) {
            final PsiMethod psiMethod = (PsiMethod)element;
            boolean isAbstract = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return psiMethod.hasModifierProperty("abstract");
                }
            });
            if (isAbstract && options.isImplementingMethods || options.isOverridingMethods) {
                JavaFindUsagesHandler.processOverridingMethods(psiMethod, processor, options);
            }
        }
        if (!ThrowSearchUtil.isSearchable(element) && options.isSearchForTextOccurences && options.searchScope instanceof GlobalSearchScope) {
            this.processUsagesInText(element, processor, (GlobalSearchScope)options.searchScope);
        }
    }

    private static void processOverridingMethods(PsiMethod psiMethod, final Processor<UsageInfo> processor, final FindUsagesOptions options) {
        OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiMethod>(){

            public boolean execute(PsiMethod element) {
                JavaFindUsagesHandler.addResult((Processor<UsageInfo>)processor, element.getNavigationElement(), options, null);
                return true;
            }
        }));
    }

    private static void addClassesUsages(PsiPackage aPackage, final Processor<UsageInfo> results, final FindUsagesOptions options) {
        final HashSet filesSet = new HashSet();
        final ArrayList files = new ArrayList();
        ReferencesSearch.search((PsiElement)aPackage, (SearchScope)options.searchScope, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference psiReference) {
                PsiElement ref = psiReference.getElement();
                PsiFile file = ref.getContainingFile();
                if (filesSet.add(file)) {
                    files.add(file);
                }
                return true;
            }
        });
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.pushState();
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        JavaFindUsagesHandler.addClassesInPackage(aPackage, options.isIncludeSubpackages, classes);
        for (final PsiClass aClass : classes) {
            if (progress != null) {
                progress.setText(FindBundle.message("find.searching.for.references.to.class.progress", aClass.getName()));
            }
            for (PsiFile file : files) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                ReferencesSearch.search((PsiElement)aClass, (SearchScope)new LocalSearchScope((PsiElement)file), (boolean)false).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference psiReference) {
                        return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)results, psiReference, options, (PsiElement)aClass);
                    }
                });
            }
        }
        if (progress != null) {
            progress.popState();
        }
    }

    private static void addClassesInPackage(PsiPackage aPackage, boolean includeSubpackages, ArrayList<PsiClass> array) {
        PsiDirectory[] dirs;
        for (PsiDirectory dir : dirs = aPackage.getDirectories()) {
            JavaFindUsagesHandler.addClassesInDirectory(dir, includeSubpackages, array);
        }
    }

    private static void addClassesInDirectory(final PsiDirectory dir, final boolean includeSubdirs, final ArrayList<PsiClass> array) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir);
                array.addAll(Arrays.asList(classes));
                if (includeSubdirs) {
                    PsiDirectory[] dirs;
                    for (PsiDirectory directory : dirs = dir.getSubdirectories()) {
                        JavaFindUsagesHandler.addClassesInDirectory(directory, includeSubdirs, array);
                    }
                }
            }
        });
    }

    private static void addMethodsUsages(final PsiClass aClass, final Processor<UsageInfo> results, final FindUsagesOptions options) {
        if (options.isIncludeInherited) {
            final PsiManager manager = aClass.getManager();
            PsiMethod[] methods = aClass.getAllMethods();
            block0: for (int i = 0; i < methods.length; ++i) {
                final PsiMethod method = methods[i];
                MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
                for (int j = 0; j < i; ++j) {
                    if (methodSignature.equals(methods[j].getSignature(PsiSubstitutor.EMPTY))) continue block0;
                }
                final PsiClass methodClass = method.getContainingClass();
                if (methodClass != null && manager.areElementsEquivalent((PsiElement)methodClass, (PsiElement)aClass)) {
                    JavaFindUsagesHandler.addMethodUsages(methods[i], results, options, options.searchScope);
                    continue;
                }
                boolean strictSignatureSearch = !options.isIncludeOverloadUsages;
                MethodReferencesSearch.search((PsiMethod)method, (SearchScope)options.searchScope, (boolean)strictSignatureSearch).forEach((Processor)new PsiReferenceProcessorAdapter(new PsiReferenceProcessor(){

                    public boolean execute(PsiReference reference) {
                        JavaFindUsagesHandler.addResultFromReference(reference, methodClass, manager, aClass, (Processor<UsageInfo>)results, options, (PsiElement)method);
                        return true;
                    }
                }));
            }
        } else {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                JavaFindUsagesHandler.addMethodUsages(method, results, options, options.searchScope);
            }
        }
    }

    private static void addFieldsUsages(final PsiClass aClass, final Processor<UsageInfo> results, final FindUsagesOptions options) {
        if (options.isIncludeInherited) {
            final PsiManager manager = aClass.getManager();
            PsiField[] fields = aClass.getAllFields();
            block0: for (int i = 0; i < fields.length; ++i) {
                final PsiField field = fields[i];
                for (int j = 0; j < i; ++j) {
                    if (Comparing.strEqual((String)field.getName(), (String)fields[j].getName())) continue block0;
                }
                final PsiClass fieldClass = field.getContainingClass();
                if (manager.areElementsEquivalent((PsiElement)fieldClass, (PsiElement)aClass)) {
                    JavaFindUsagesHandler.addElementUsages((PsiElement)fields[i], results, options);
                    continue;
                }
                ReferencesSearch.search((PsiElement)field, (SearchScope)options.searchScope, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference reference) {
                        JavaFindUsagesHandler.addResultFromReference(reference, fieldClass, manager, aClass, (Processor<UsageInfo>)results, options, (PsiElement)field);
                        return true;
                    }
                });
            }
        } else {
            PsiField[] fields;
            for (PsiField field : fields = (PsiField[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField[]>(){

                public PsiField[] compute() {
                    return aClass.getFields();
                }
            })) {
                JavaFindUsagesHandler.addElementUsages((PsiElement)field, results, options);
            }
        }
    }

    @Nullable
    private static PsiClass getFieldOrMethodAccessedClass(PsiReferenceExpression ref, PsiClass fieldOrMethodClass) {
        PsiElement[] children = ref.getChildren();
        if (children.length > 1 && children[0] instanceof PsiExpression) {
            PsiElement refElement;
            PsiExpression expr = (PsiExpression)children[0];
            PsiType type = expr.getType();
            if (type != null) {
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return PsiUtil.resolveClassInType((PsiType)type);
            }
            if (expr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)expr).resolve()) instanceof PsiClass) {
                return (PsiClass)refElement;
            }
            return null;
        }
        PsiManager manager = ref.getManager();
        for (PsiReferenceExpression parent = ref; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass) || !manager.areElementsEquivalent((PsiElement)parent, (PsiElement)fieldOrMethodClass) && !((PsiClass)parent).isInheritor(fieldOrMethodClass, true)) continue;
            return (PsiClass)parent;
        }
        return null;
    }

    private static void addInheritors(PsiClass aClass, final Processor<UsageInfo> results, final FindUsagesOptions options) {
        ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(PsiClass element) {
                JavaFindUsagesHandler.addResult((Processor<UsageInfo>)results, (PsiElement)element, options, null);
                return true;
            }
        }));
    }

    private static void addDerivedInterfaces(PsiClass anInterface, final Processor<UsageInfo> results, final FindUsagesOptions options) {
        ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(PsiClass inheritor) {
                if (inheritor.isInterface()) {
                    JavaFindUsagesHandler.addResult((Processor<UsageInfo>)results, (PsiElement)inheritor, options, null);
                }
                return true;
            }
        }));
    }

    private static void addImplementingClasses(PsiClass anInterface, final Processor<UsageInfo> results, final FindUsagesOptions options) {
        ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(PsiClass inheritor) {
                if (!inheritor.isInterface()) {
                    JavaFindUsagesHandler.addResult((Processor<UsageInfo>)results, (PsiElement)inheritor, options, null);
                }
                return true;
            }
        }));
    }

    private static void addResultFromReference(PsiReference reference, PsiClass methodClass, PsiManager manager, PsiClass aClass, Processor<UsageInfo> results, FindUsagesOptions options, PsiElement element) {
        PsiClass usedClass;
        PsiElement refElement = reference.getElement();
        if (refElement instanceof PsiReferenceExpression && (usedClass = JavaFindUsagesHandler.getFieldOrMethodAccessedClass((PsiReferenceExpression)refElement, methodClass)) != null && (manager.areElementsEquivalent((PsiElement)usedClass, (PsiElement)aClass) || usedClass.isInheritor(aClass, true))) {
            JavaFindUsagesHandler.addResult(results, refElement, options, element);
        }
    }

    public static void addElementUsages(final PsiElement element, final Processor<UsageInfo> results, final FindUsagesOptions options) {
        if (element instanceof PsiMethod) {
            JavaFindUsagesHandler.addMethodUsages((PsiMethod)element, results, options, options.searchScope);
        } else {
            ReferencesSearch.search((PsiElement)element, (SearchScope)options.searchScope, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference ref) {
                    return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)results, ref, options, element);
                }
            });
        }
    }

    private static void addMethodUsages(final PsiMethod method, final Processor<UsageInfo> result, final FindUsagesOptions options, SearchScope searchScope) {
        if (method.isConstructor()) {
            if (options.isIncludeOverloadUsages) {
                for (PsiMethod constructor : method.getContainingClass().getConstructors()) {
                    JavaFindUsagesHandler.addConstructorUsages(constructor, searchScope, result, options);
                }
            } else {
                JavaFindUsagesHandler.addConstructorUsages(method, searchScope, result, options);
            }
        } else {
            boolean strictSignatureSearch = !options.isIncludeOverloadUsages;
            MethodReferencesSearch.search((PsiMethod)method, (SearchScope)searchScope, (boolean)strictSignatureSearch).forEach((Processor)new PsiReferenceProcessorAdapter(new PsiReferenceProcessor(){

                public boolean execute(PsiReference ref) {
                    return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)result, ref, options, (PsiElement)method);
                }
            }));
        }
    }

    private static void addConstructorUsages(PsiMethod method, SearchScope searchScope, final Processor<UsageInfo> result, final FindUsagesOptions options) {
        final PsiClass parentClass = method.getContainingClass();
        if (parentClass == null) {
            return;
        }
        ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                return JavaFindUsagesHandler.addResult((Processor<UsageInfo>)result, ref, options, (PsiElement)parentClass);
            }
        });
    }

    public static void addResult(Processor<UsageInfo> total, PsiElement element, FindUsagesOptions options, PsiElement refElement) {
        if (JavaFindUsagesHandler.filterUsage(element, options, refElement)) {
            total.process((Object)new UsageInfo(element));
        }
    }

    public static boolean addResult(Processor<UsageInfo> results, PsiReference ref, FindUsagesOptions options, PsiElement refElement) {
        if (JavaFindUsagesHandler.filterUsage(ref.getElement(), options, refElement)) {
            TextRange rangeInElement = ref.getRangeInElement();
            return results.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
        }
        return true;
    }

    private static boolean filterUsage(PsiElement usage, FindUsagesOptions options, PsiElement refElement) {
        PsiElement parent;
        if (!(usage instanceof PsiJavaCodeReferenceElement)) {
            return true;
        }
        if (refElement instanceof PsiPackage && !options.isIncludeSubpackages && ((PsiReference)usage).resolve() instanceof PsiPackage && (parent = usage.getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)parent).resolve() instanceof PsiPackage) {
            return false;
        }
        if (!(usage instanceof PsiReferenceExpression)) {
            if (options.isSkipImportStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiImportStatement) {
                    return false;
                }
            }
            if (options.isSkipPackageStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiPackageStatement) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean isSearchForTextOccurencesAvailable(PsiElement psiElement, boolean isSingleFile) {
        if (isSingleFile) {
            return false;
        }
        if (psiElement instanceof PsiClass) {
            return ((PsiClass)psiElement).getQualifiedName() != null;
        }
        return psiElement instanceof PsiPackage;
    }

    @Override
    public Collection<PsiReference> findReferencesToHighlight(PsiElement target, SearchScope searchScope) {
        if (target instanceof PsiMethod) {
            return MethodReferencesSearch.search((PsiMethod)((PsiMethod)target), (SearchScope)searchScope, (boolean)true).findAll();
        }
        return super.findReferencesToHighlight(target, searchScope);
    }
}

