/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.ui.LightColors;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class EditorSearchComponent
extends JPanel
implements DataProvider {
    private final JLabel myMatchInfoLabel;
    private final Project myProject;
    private final Editor myEditor;
    private final JTextField mySearchField;
    private final Color myDefaultBackground;
    private final Color GRADIENT_C1;
    private final Color GRADIENT_C2;
    private static final Color BORDER_COLOR = new Color(135, 135, 135);
    private static final Color COMPLETION_BACKGROUND_COLOR = new Color(235, 244, 254);
    private static final Color FOCUS_CATCHER_COLOR = new Color(0x9999FF);
    private final JComponent myToolbarComponent;
    private DocumentAdapter myDocumentListener;
    private ArrayList<RangeHighlighter> myHighlighters = new ArrayList();
    private boolean myOkToSearch = false;
    private boolean myHasMatches = false;
    private final JCheckBox myCbRegexp;
    private final JCheckBox myCbWholeWords;
    private final JCheckBox myCbInComments;
    private final JCheckBox myCbInLiterals;

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    public EditorSearchComponent(Editor editor, Project project) {
        super(new BorderLayout(0, 0));
        this.GRADIENT_C1 = this.getBackground();
        this.GRADIENT_C2 = new Color(Math.max(0, this.GRADIENT_C1.getRed() - 24), Math.max(0, this.GRADIENT_C1.getGreen() - 24), Math.max(0, this.GRADIENT_C1.getBlue() - 24));
        this.myProject = project;
        this.myEditor = editor;
        NonOpaquePanel leadPanel = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 5, 0));
        this.add((Component)leadPanel, "West");
        this.mySearchField = new JTextField(){

            @Override
            protected void paintBorder(Graphics g) {
                super.paintBorder(g);
                LafManager lafManager = LafManager.getInstance();
                if (!lafManager.isUnderAquaLookAndFeel() && !lafManager.isUnderQuaquaLookAndFeel() && this.isFocusOwner()) {
                    Rectangle bounds = this.getBounds();
                    g.setColor(FOCUS_CATCHER_COLOR);
                    g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
                }
            }
        };
        this.mySearchField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorSearchComponent.this.mySearchField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditorSearchComponent.this.mySearchField.repaint();
            }
        });
        this.mySearchField.putClientProperty("AuxEditorComponent", Boolean.TRUE);
        leadPanel.add(this.mySearchField);
        this.myDefaultBackground = this.mySearchField.getBackground();
        this.mySearchField.setColumns(25);
        EditorSearchComponent.setSmallerFont(this.mySearchField);
        DefaultActionGroup group = new DefaultActionGroup("search bar", false);
        group.add((AnAction)new ShowHistoryAction());
        group.add((AnAction)new PrevOccurenceAction());
        group.add((AnAction)new NextOccurenceAction());
        group.add((AnAction)new FindAllAction());
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("SearchBar", (ActionGroup)group, true);
        tb.setLayoutPolicy(0);
        this.myToolbarComponent = tb.getComponent();
        this.myToolbarComponent.setBorder(null);
        this.myToolbarComponent.setOpaque(false);
        leadPanel.add(this.myToolbarComponent);
        NonFocusableCheckBox cbMatchCase = new NonFocusableCheckBox("Case sensitive");
        this.myCbWholeWords = new NonFocusableCheckBox("Match whole words only");
        this.myCbRegexp = new NonFocusableCheckBox("Regex");
        this.myCbInComments = new NonFocusableCheckBox("In comments");
        this.myCbInLiterals = new NonFocusableCheckBox("In literals");
        leadPanel.add((Component)cbMatchCase);
        leadPanel.add(this.myCbWholeWords);
        leadPanel.add(this.myCbRegexp);
        if (FindManagerImpl.ourHasSearchInCommentsAndLiterals) {
            leadPanel.add(this.myCbInComments);
            leadPanel.add(this.myCbInLiterals);
        }
        cbMatchCase.setSelected(this.isCaseSensitive());
        this.myCbWholeWords.setSelected(this.isWholeWords());
        this.myCbRegexp.setSelected(this.isRegexp());
        this.myCbInComments.setSelected(this.isInComments());
        this.myCbInLiterals.setSelected(this.isInLiterals());
        cbMatchCase.setMnemonic('C');
        this.myCbWholeWords.setMnemonic('M');
        this.myCbRegexp.setMnemonic('R');
        this.myCbInComments.setMnemonic('o');
        this.myCbInLiterals.setMnemonic('l');
        EditorSearchComponent.setSmallerFontAndOpaque(this.myCbWholeWords);
        EditorSearchComponent.setSmallerFontAndOpaque((JComponent)cbMatchCase);
        EditorSearchComponent.setSmallerFontAndOpaque(this.myCbRegexp);
        EditorSearchComponent.setSmallerFontAndOpaque(this.myCbInComments);
        EditorSearchComponent.setSmallerFontAndOpaque(this.myCbInLiterals);
        cbMatchCase.addActionListener(new ActionListener((JCheckBox)cbMatchCase){
            final /* synthetic */ JCheckBox val$cbMatchCase;
            {
                this.val$cbMatchCase = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = this.val$cbMatchCase.isSelected();
                FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel().setCaseSensitive(b);
                FindSettings.getInstance().setLocalCaseSensitive(b);
                EditorSearchComponent.this.updateResults(true);
            }
        });
        this.myCbWholeWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = EditorSearchComponent.this.myCbWholeWords.isSelected();
                FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel().setWholeWordsOnly(b);
                FindSettings.getInstance().setLocalWholeWordsOnly(b);
                EditorSearchComponent.this.updateResults(true);
            }
        });
        this.myCbRegexp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = EditorSearchComponent.this.myCbRegexp.isSelected();
                FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel().setRegularExpressions(b);
                EditorSearchComponent.this.myCbWholeWords.setEnabled(!b);
                EditorSearchComponent.this.updateResults(true);
            }
        });
        this.myCbInComments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = EditorSearchComponent.this.myCbInComments.isSelected();
                FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel().setInCommentsOnly(b);
                EditorSearchComponent.this.updateResults(true);
            }
        });
        this.myCbInLiterals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = EditorSearchComponent.this.myCbInLiterals.isSelected();
                FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel().setInStringLiteralsOnly(b);
                EditorSearchComponent.this.updateResults(true);
            }
        });
        NonOpaquePanel tailPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(5, 0));
        NonOpaquePanel tailContainer = new NonOpaquePanel((LayoutManager)new BorderLayout(5, 0));
        tailContainer.add((Component)tailPanel, "East");
        this.add((Component)tailContainer, "Center");
        this.myMatchInfoLabel = new JLabel();
        EditorSearchComponent.setSmallerFontAndOpaque(this.myMatchInfoLabel);
        JLabel closeLabel = new JLabel(" ", IconLoader.getIcon((String)"/actions/cross.png"), 4);
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorSearchComponent.this.close();
            }
        });
        closeLabel.setToolTipText("Close search bar (Escape)");
        tailPanel.add((Component)this.myMatchInfoLabel, "Center");
        tailPanel.add((Component)closeLabel, "East");
        this.mySearchField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                EditorSearchComponent.this.updateResults(true);
            }
        });
        this.mySearchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorSearchComponent.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.mySearchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorSearchComponent.this.getTextInField().length() == 0) {
                    EditorSearchComponent.this.showHistory(false);
                }
            }
        }, KeyStroke.getKeyStroke(40, 0), 0);
        this.mySearchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("".equals(EditorSearchComponent.this.mySearchField.getText())) {
                    EditorSearchComponent.this.close();
                } else {
                    EditorSearchComponent.this.requestFocus(EditorSearchComponent.this.myEditor.getContentComponent());
                    EditorSearchComponent.this.addCurrentTextToRecents();
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        final String initialText = this.myEditor.getSelectionModel().getSelectedText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorSearchComponent.this.setInitialText(initialText);
            }
        });
        new VariantsCompletionAction();
    }

    public void setInitialText(String initialText) {
        String text;
        String string = text = initialText != null ? initialText : "";
        if (text.contains("\n")) {
            this.setRegexp(true);
            this.setTextInField(StringUtil.escapeToRegexp((String)text));
        } else {
            this.setTextInField(text);
        }
        this.mySearchField.selectAll();
    }

    private void requestFocus(Component c) {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, true);
    }

    private void searchBackward() {
        if (this.hasMatches()) {
            SelectionModel model = this.myEditor.getSelectionModel();
            if (model.hasSelection() && Comparing.equal((String)this.mySearchField.getText(), (String)model.getSelectedText(), (boolean)this.isCaseSensitive()) && this.myEditor.getCaretModel().getOffset() == model.getSelectionEnd()) {
                this.myEditor.getCaretModel().moveToOffset(model.getSelectionStart());
            }
            FindUtil.searchBack(this.myProject, this.myEditor);
            this.addCurrentTextToRecents();
        }
    }

    private void searchForward() {
        if (this.hasMatches()) {
            SelectionModel model = this.myEditor.getSelectionModel();
            if (model.hasSelection() && Comparing.equal((String)this.mySearchField.getText(), (String)model.getSelectedText(), (boolean)this.isCaseSensitive()) && this.myEditor.getCaretModel().getOffset() == model.getSelectionStart()) {
                this.myEditor.getCaretModel().moveToOffset(model.getSelectionEnd());
            }
            FindUtil.searchAgain(this.myProject, this.myEditor);
            this.addCurrentTextToRecents();
        }
    }

    private void addCurrentTextToRecents() {
        String text = this.mySearchField.getText();
        if (text.length() > 0) {
            FindSettings.getInstance().addStringToFind(text);
        }
    }

    private static void setSmallerFontAndOpaque(JComponent component) {
        EditorSearchComponent.setSmallerFont(component);
        component.setOpaque(false);
    }

    private static void setSmallerFont(JComponent component) {
        if (SystemInfo.isMac) {
            Font f = component.getFont();
            component.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        }
    }

    @Override
    public void requestFocus() {
        this.requestFocus(this.mySearchField);
    }

    private void close() {
        this.removeCurrentHighlights();
        if (this.myEditor.getSelectionModel().hasSelection()) {
            this.myEditor.getCaretModel().moveToOffset(this.myEditor.getSelectionModel().getSelectionStart());
            this.myEditor.getSelectionModel().removeSelection();
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), false);
        this.myEditor.setHeaderComponent(null);
        this.addCurrentTextToRecents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myDocumentListener = new DocumentAdapter(){

            public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                EditorSearchComponent.this.updateResults(false);
            }
        };
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this.myDocumentListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.myDocumentListener != null) {
            this.myEditor.getDocument().removeDocumentListener((DocumentListener)this.myDocumentListener);
            this.myDocumentListener = null;
        }
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        this.removeCurrentHighlights();
        this.myMatchInfoLabel.setFont(this.myMatchInfoLabel.getFont().deriveFont(0));
        String text = this.mySearchField.getText();
        if (text.length() == 0) {
            this.setRegularBackground();
            this.myMatchInfoLabel.setText("");
            this.myOkToSearch = false;
        } else {
            int count;
            FindResult result;
            this.myOkToSearch = true;
            FindManager findManager = FindManager.getInstance((Project)this.myProject);
            FindModel model = new FindModel();
            model.setCaseSensitive(this.isCaseSensitive());
            model.setInCommentsOnly(this.isInComments());
            model.setInStringLiteralsOnly(this.isInLiterals());
            if (this.isRegexp()) {
                model.setWholeWordsOnly(false);
                model.setRegularExpressions(true);
                try {
                    Pattern.compile(text);
                }
                catch (Exception e) {
                    this.myOkToSearch = false;
                    this.setNotFoundBackground();
                    this.myMatchInfoLabel.setText("Incorrect regular expression");
                    this.boldMatchInfo();
                    return;
                }
            } else {
                model.setWholeWordsOnly(this.isWholeWords());
                model.setRegularExpressions(false);
            }
            model.setFromCursor(false);
            model.setStringToFind(text);
            model.setSearchHighlighters(true);
            int offset = 0;
            VirtualFile virtualFile = FindUtil.getVirtualFile(this.myEditor);
            ArrayList<FindResult> results = new ArrayList<FindResult>();
            while ((result = findManager.findString(this.myEditor.getDocument().getCharsSequence(), offset, model, virtualFile)).isStringFound()) {
                offset = result.getEndOffset();
                results.add(result);
                if (results.size() <= 100) continue;
                break;
            }
            if (allowedToChangedEditorSelection) {
                int currentOffset = this.myEditor.getCaretModel().getOffset();
                if (this.myEditor.getSelectionModel().hasSelection()) {
                    currentOffset = Math.min(currentOffset, this.myEditor.getSelectionModel().getSelectionStart());
                }
                if (!this.findAndSelectFirstUsage(findManager, model, currentOffset, virtualFile)) {
                    this.findAndSelectFirstUsage(findManager, model, 0, virtualFile);
                }
            }
            if ((count = results.size()) <= 100) {
                this.highlightResults(text, results);
                if (count > 0) {
                    this.setRegularBackground();
                    if (count > 1) {
                        this.myMatchInfoLabel.setText(count + " matches");
                    } else {
                        this.myMatchInfoLabel.setText("1 match");
                    }
                } else {
                    this.setNotFoundBackground();
                    this.myMatchInfoLabel.setText("No matches");
                }
            } else {
                this.setRegularBackground();
                this.myMatchInfoLabel.setText("More than 100 matches");
                this.boldMatchInfo();
            }
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                findManager.setFindNextModel(model);
            }
        }
    }

    private void boldMatchInfo() {
        this.myMatchInfoLabel.setFont(this.myMatchInfoLabel.getFont().deriveFont(1));
    }

    private void setRegularBackground() {
        this.myHasMatches = true;
        this.mySearchField.setBackground(this.myDefaultBackground);
    }

    private void setNotFoundBackground() {
        this.myHasMatches = false;
        this.mySearchField.setBackground(LightColors.RED);
    }

    public String getTextInField() {
        return this.mySearchField.getText();
    }

    private boolean isWholeWords() {
        return FindManager.getInstance((Project)this.myProject).getFindInFileModel().isWholeWordsOnly();
    }

    private boolean isInComments() {
        return FindManager.getInstance((Project)this.myProject).getFindInFileModel().isInCommentsOnly();
    }

    private boolean isInLiterals() {
        return FindManager.getInstance((Project)this.myProject).getFindInFileModel().isInStringLiteralsOnly();
    }

    private boolean isCaseSensitive() {
        return FindManager.getInstance((Project)this.myProject).getFindInFileModel().isCaseSensitive();
    }

    public boolean isRegexp() {
        return this.myCbRegexp.isSelected() || FindManager.getInstance((Project)this.myProject).getFindInFileModel().isRegularExpressions();
    }

    public void setRegexp(boolean r) {
        this.myCbRegexp.setSelected(r);
        this.myCbWholeWords.setEnabled(!r);
        this.updateResults(false);
    }

    private void removeCurrentHighlights() {
        HighlightManagerImpl highlightManager = (HighlightManagerImpl)HighlightManager.getInstance((Project)this.myProject);
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
        }
    }

    private boolean findAndSelectFirstUsage(FindManager findManager, FindModel model, int offset, VirtualFile file) {
        FindResult firstResult = findManager.findString(this.myEditor.getDocument().getCharsSequence(), offset, model, file);
        if (firstResult.isStringFound()) {
            this.myEditor.getSelectionModel().setSelection(firstResult.getStartOffset(), firstResult.getEndOffset());
            this.myEditor.getCaretModel().moveToOffset(firstResult.getEndOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getCaretModel().moveToOffset(firstResult.getStartOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return true;
        }
        return false;
    }

    private void highlightResults(String text, ArrayList<FindResult> results) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        EditorColorsManager colorManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        this.myHighlighters = new ArrayList();
        for (FindResult result : results) {
            highlightManager.addRangeHighlight(this.myEditor, result.getStartOffset(), result.getEndOffset(), attributes, false, this.myHighlighters);
        }
        String escapedText = StringUtil.escapeXml((String)text);
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.setErrorStripeTooltip((Object)escapedText);
        }
    }

    public void setTextInField(String text) {
        this.mySearchField.setText(text);
        this.updateResults(true);
    }

    public boolean hasMatches() {
        return this.myOkToSearch && this.myHasMatches;
    }

    private void showHistory(boolean byClickingToolbarButton) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("find.recent.search");
        this.showCompletionPopup(new JList<Object>(ArrayUtil.reverseArray((Object[])FindSettings.getInstance().getRecentFindStrings())), "Recent Searches", byClickingToolbarButton);
    }

    private void showCompletionPopup(final JList list, String title, boolean byClickingToolbarButton) {
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                String selectedValue = (String)list.getSelectedValue();
                if (selectedValue != null) {
                    EditorSearchComponent.this.mySearchField.setText(selectedValue);
                }
            }
        };
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(list);
        if (title != null) {
            builder.setTitle(title);
        }
        JBPopup popup = builder.setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback).createPopup();
        if (byClickingToolbarButton) {
            popup.showUnderneathOf((Component)this.myToolbarComponent);
        } else {
            popup.showUnderneathOf((Component)this.mySearchField);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.GRADIENT_C1, 0.0f, this.getHeight(), this.GRADIENT_C2));
        g2d.fillRect(1, 1, this.getWidth(), this.getHeight() - 1);
        g.setColor(BORDER_COLOR);
        g2d.setPaint(null);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private class VariantsCompletionAction
    extends AnAction {
        private VariantsCompletionAction() {
            AnAction action = ActionManager.getInstance().getAction("CodeCompletion");
            if (action != null) {
                this.registerCustomShortcutSet(action.getShortcutSet(), EditorSearchComponent.this.mySearchField);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            String prefix = this.getPrefix();
            if (prefix.length() == 0) {
                return;
            }
            Object[] array = this.calcWords(prefix);
            if (array.length == 0) {
                return;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("find.completion");
            JList list = new JList(array){

                @Override
                protected void paintComponent(Graphics g) {
                    UISettings.setupAntialiasing((Graphics)g);
                    super.paintComponent(g);
                }
            };
            list.setBackground(COMPLETION_BACKGROUND_COLOR);
            list.setFont(EditorSearchComponent.this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            EditorSearchComponent.this.showCompletionPopup(list, null, e.getInputEvent() instanceof MouseEvent);
        }

        private String getPrefix() {
            return EditorSearchComponent.this.mySearchField.getText().substring(0, EditorSearchComponent.this.mySearchField.getCaret().getDot());
        }

        private String[] calcWords(String prefix) {
            final NameUtil.Matcher matcher = NameUtil.buildMatcher((String)prefix, (int)0, (boolean)true, (boolean)true);
            final HashSet words = new HashSet();
            CharSequence chars = EditorSearchComponent.this.myEditor.getDocument().getCharsSequence();
            IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

                @Override
                public void run(CharSequence chars, int start, int end) {
                    String word = ((Object)chars.subSequence(start, end)).toString();
                    if (matcher.matches(word)) {
                        words.add(word);
                    }
                }
            }, chars, 0, chars.length());
            ArrayList sortedWords = new ArrayList(words);
            Collections.sort(sortedWords);
            return ArrayUtil.toStringArray(sortedWords);
        }
    }

    private class FindAllAction
    extends AnAction
    implements DumbAware {
        private FindAllAction() {
            this.getTemplatePresentation().setIcon(IconLoader.getIcon((String)"/actions/export.png"));
            this.getTemplatePresentation().setDescription("Export matches to Find tool window");
            this.getTemplatePresentation().setText("Find All");
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("FindUsages").getShortcutSet(), EditorSearchComponent.this.mySearchField);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(EditorSearchComponent.this.hasMatches() && PsiDocumentManager.getInstance((Project)EditorSearchComponent.this.myProject).getPsiFile(EditorSearchComponent.this.myEditor.getDocument()) != null);
        }

        public void actionPerformed(AnActionEvent e) {
            FindModel model = FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel();
            FindModel realModel = (FindModel)model.clone();
            realModel.setStringToFind(EditorSearchComponent.this.getTextInField());
            FindUtil.findAll(EditorSearchComponent.this.myProject, EditorSearchComponent.this.myEditor, realModel);
        }
    }

    private class ShowHistoryAction
    extends AnAction
    implements DumbAware {
        private ShowHistoryAction() {
            this.getTemplatePresentation().setIcon(IconLoader.getIcon((String)"/actions/search.png"));
            this.getTemplatePresentation().setDescription("Search history");
            this.getTemplatePresentation().setText("Search History");
            ArrayList<Object> shortcuts = new ArrayList<Object>();
            shortcuts.addAll(Arrays.asList(ActionManager.getInstance().getAction("Find").getShortcutSet().getShortcuts()));
            shortcuts.add(new KeyboardShortcut(KeyStroke.getKeyStroke(72, 128), null));
            shortcuts.addAll(Arrays.asList(ActionManager.getInstance().getAction("IncrementalSearch").getShortcutSet().getShortcuts()));
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()])), EditorSearchComponent.this.mySearchField);
        }

        public void actionPerformed(AnActionEvent e) {
            EditorSearchComponent.this.showHistory(e.getInputEvent() instanceof MouseEvent);
        }
    }

    private class NextOccurenceAction
    extends AnAction
    implements DumbAware {
        public NextOccurenceAction() {
            this.copyFrom(ActionManager.getInstance().getAction("NextOccurence"));
            ArrayList<Object> shortcuts = new ArrayList<Object>();
            shortcuts.addAll(Arrays.asList(ActionManager.getInstance().getAction("FindNext").getShortcutSet().getShortcuts()));
            shortcuts.addAll(Arrays.asList(ActionManager.getInstance().getAction("EditorDown").getShortcutSet().getShortcuts()));
            shortcuts.add(new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null));
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()])), EditorSearchComponent.this.mySearchField);
        }

        public void actionPerformed(AnActionEvent e) {
            EditorSearchComponent.this.searchForward();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(EditorSearchComponent.this.hasMatches());
        }
    }

    private class PrevOccurenceAction
    extends AnAction
    implements DumbAware {
        public PrevOccurenceAction() {
            this.copyFrom(ActionManager.getInstance().getAction("PreviousOccurence"));
            ArrayList<Object> shortcuts = new ArrayList<Object>();
            shortcuts.addAll(Arrays.asList(ActionManager.getInstance().getAction("FindPrevious").getShortcutSet().getShortcuts()));
            shortcuts.addAll(Arrays.asList(ActionManager.getInstance().getAction("EditorUp").getShortcutSet().getShortcuts()));
            shortcuts.add(new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null));
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()])), EditorSearchComponent.this.mySearchField);
        }

        public void actionPerformed(AnActionEvent e) {
            EditorSearchComponent.this.searchBackward();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(EditorSearchComponent.this.hasMatches());
        }
    }
}

