/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.codeInsight.navigation.IncrementalSearchHandler;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleInputListener;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.DisposedPsiManagerCheck;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Alarm;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleViewImpl
extends JPanel
implements ConsoleView,
ObservableConsoleView,
DataProvider,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.ConsoleViewImpl");
    private static final int FLUSH_DELAY = 200;
    private static final Key<ConsoleViewImpl> CONSOLE_VIEW_IN_EDITOR_VIEW = Key.create((String)"CONSOLE_VIEW_IN_EDITOR_VIEW");
    private final DisposedPsiManagerCheck myPsiDisposedCheck;
    private ConsoleState myState = ConsoleState.NOT_STARTED;
    private final int CYCLIC_BUFFER_SIZE = ConsoleViewImpl.getCycleBufferSize();
    private final boolean isViewer;
    private Computable<ModalityState> myStateForUpdate;
    private final boolean USE_CYCLIC_BUFFER = ConsoleViewImpl.useCycleBuffer();
    private static final int HYPERLINK_LAYER = 5877;
    private final Alarm mySpareTimeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
    private final CopyOnWriteArraySet<ObservableConsoleView.ChangeListener> myListeners = new CopyOnWriteArraySet();
    private final Set<ConsoleViewContentType> myDeferredTypes = new HashSet<ConsoleViewContentType>();
    private final ArrayList<AnAction> customActions = new ArrayList();
    private final Project myProject;
    private boolean myOutputPaused;
    private Editor myEditor;
    private final Object LOCK = new Object();
    private int myContentSize;
    private StringBuffer myDeferredOutput = new StringBuffer();
    private StringBuffer myDeferredUserInput = new StringBuffer();
    private ArrayList<TokenInfo> myTokens = new ArrayList();
    private final Hyperlinks myHyperlinks = new Hyperlinks();
    private final TIntObjectHashMap<ConsoleFolding> myFolding = new TIntObjectHashMap();
    private String myHelpId;
    private final Alarm myFlushUserInputAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)this);
    private final Alarm myFlushAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
    private final Runnable myFlushDeferredRunnable = new Runnable(){

        @Override
        public void run() {
            ConsoleViewImpl.this.flushDeferredText();
        }
    };
    protected final CompositeFilter myPredefinedMessageFilter;
    protected final CompositeFilter myCustomFilter;
    private ArrayList<String> myHistory = new ArrayList();
    private int myHistorySize = 20;
    private ArrayList<ConsoleInputListener> myConsoleInputListeners = new ArrayList();
    private final Alarm myFoldingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
    private final List<FoldRegion> myPendingFoldRegions = new ArrayList<FoldRegion>();
    private FileType myFileType;
    public static final Key<TextAttributes> OLD_HYPERLINK_TEXT_ATTRIBUTES;

    private static int getCycleBufferSize() {
        String cycleBufferSizeProperty = System.getProperty("idea.cycle.buffer.size");
        if (cycleBufferSizeProperty == null) {
            return 0x100000;
        }
        try {
            return Integer.parseInt(cycleBufferSizeProperty) * 1024;
        }
        catch (NumberFormatException e) {
            return 0x100000;
        }
    }

    private static boolean useCycleBuffer() {
        String useCycleBufferProperty = System.getProperty("idea.cycle.buffer.size");
        return useCycleBufferProperty == null || !"disabled".equalsIgnoreCase(useCycleBufferProperty);
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public void scrollToEnd() {
        this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getTextLength());
    }

    public void addConsoleUserInputListener(ConsoleInputListener consoleInputListener) {
        this.myConsoleInputListeners.add(consoleInputListener);
    }

    public void importHistory(Collection<String> history) {
        this.myHistory.clear();
        this.myHistory.addAll(history);
        while (this.myHistory.size() > this.myHistorySize) {
            this.myHistory.remove(0);
        }
    }

    public List<String> getHistory() {
        return Collections.unmodifiableList(this.myHistory);
    }

    public void setHistorySize(int historySize) {
        this.myHistorySize = historySize;
    }

    public int getHistorySize() {
        return this.myHistorySize;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public ConsoleViewImpl(Project project, boolean viewer) {
        this(project, viewer, null);
    }

    public ConsoleViewImpl(Project project, boolean viewer, FileType fileType) {
        this(project, GlobalSearchScope.allScope((Project)project), viewer, fileType);
    }

    public ConsoleViewImpl(Project project, GlobalSearchScope searchScope, boolean viewer, FileType fileType) {
        super(new BorderLayout());
        this.isViewer = viewer;
        this.myPsiDisposedCheck = new DisposedPsiManagerCheck(project);
        this.myProject = project;
        this.myFileType = fileType;
        this.myCustomFilter = new CompositeFilter(project);
        this.myPredefinedMessageFilter = new CompositeFilter(project);
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])Extensions.getExtensions((ExtensionPointName)ConsoleFilterProvider.FILTER_PROVIDERS)) {
            Filter[] filters;
            for (Filter filter : filters = eachProvider instanceof ConsoleFilterProviderEx ? ((ConsoleFilterProviderEx)eachProvider).getDefaultFilters(project, searchScope) : eachProvider.getDefaultFilters(project)) {
                this.myPredefinedMessageFilter.addFilter(filter);
            }
        }
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myState = this.myState.attachTo(this, processHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Document document;
        ConsoleViewImpl.assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            this.myContentSize = 0;
            this.myDeferredOutput = this.USE_CYCLIC_BUFFER ? new StringBuffer(Math.min(this.myDeferredOutput.length(), this.CYCLIC_BUFFER_SIZE)) : new StringBuffer();
            this.myDeferredTypes.clear();
            this.myDeferredUserInput = new StringBuffer();
            this.myHyperlinks.clear();
            this.myTokens.clear();
            if (this.myEditor == null) {
                return;
            }
            this.myEditor.getMarkupModel().removeAllHighlighters();
            document = this.myEditor.getDocument();
            this.myFoldingAlarm.cancelAllRequests();
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                document.deleteString(0, document.getTextLength());
            }
        }, null, (Object)DocCommandGroupId.noneGroupId((Document)document));
    }

    public void scrollTo(int offset) {
        ConsoleViewImpl.assertIsDispatchThread();
        this.flushDeferredText();
        if (this.myEditor == null) {
            return;
        }
        int moveOffset = offset;
        if (this.USE_CYCLIC_BUFFER && moveOffset >= this.myEditor.getDocument().getTextLength()) {
            moveOffset = 0;
        }
        this.myEditor.getCaretModel().moveToOffset(moveOffset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    private static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    public void setOutputPaused(boolean value) {
        this.myOutputPaused = value;
        if (!value) {
            this.requestFlushImmediately();
        }
    }

    public boolean isOutputPaused() {
        return this.myOutputPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDeferredOutput() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myDeferredOutput.length() > 0;
        }
    }

    public void performWhenNoDeferredOutput(final Runnable runnable) {
        if (!this.hasDeferredOutput()) {
            runnable.run();
        } else {
            this.mySpareTimeAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ConsoleViewImpl.this.performWhenNoDeferredOutput(runnable);
                }
            }, 100);
        }
    }

    public JComponent getComponent() {
        if (this.myEditor == null) {
            this.myEditor = this.createEditor();
            this.requestFlushImmediately();
            this.add((Component)this.createCenterComponent(), "Center");
            this.myEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void documentChanged(DocumentEvent e) {
                    if (e.getNewLength() == 0 && e.getOffset() == 0) {
                        Object object = ConsoleViewImpl.this.LOCK;
                        synchronized (object) {
                            int toRemoveLen = e.getOldLength();
                            int tIndex = ConsoleViewImpl.this.findTokenInfoIndexByOffset(toRemoveLen);
                            ArrayList newTokens = new ArrayList(ConsoleViewImpl.this.myTokens.subList(tIndex, ConsoleViewImpl.this.myTokens.size()));
                            for (TokenInfo token : newTokens) {
                                token.startOffset -= toRemoveLen;
                                token.endOffset -= toRemoveLen;
                            }
                            if (!newTokens.isEmpty()) {
                                ((TokenInfo)newTokens.get(0)).startOffset = 0;
                            }
                            ConsoleViewImpl.this.myContentSize -= Math.min(ConsoleViewImpl.this.myContentSize, toRemoveLen);
                            ConsoleViewImpl.this.myTokens = newTokens;
                        }
                    }
                }
            });
        }
        return this;
    }

    protected JComponent createCenterComponent() {
        return this.myEditor.getComponent();
    }

    public void setModalityStateForUpdate(Computable<ModalityState> stateComputable) {
        this.myStateForUpdate = stateComputable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myState = this.myState.dispose();
        if (this.myEditor != null) {
            this.myFlushAlarm.cancelAllRequests();
            this.mySpareTimeAlarm.cancelAllRequests();
            this.disposeEditor();
            Object object = this.LOCK;
            synchronized (object) {
                this.myDeferredOutput = new StringBuffer();
            }
            this.myEditor = null;
        }
    }

    protected void disposeEditor() {
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String s, ConsoleViewContentType contentType) {
        Object object = this.LOCK;
        synchronized (object) {
            TokenInfo lastToken;
            this.myDeferredTypes.add(contentType);
            s = StringUtil.convertLineSeparators((String)s);
            this.myContentSize += s.length();
            this.myDeferredOutput.append(s);
            if (contentType == ConsoleViewContentType.USER_INPUT) {
                this.myDeferredUserInput.append(s);
            }
            boolean needNew = true;
            if (!this.myTokens.isEmpty() && (lastToken = this.myTokens.get(this.myTokens.size() - 1)).contentType == contentType) {
                lastToken.endOffset = this.myContentSize;
                needNew = false;
            }
            if (needNew) {
                this.myTokens.add(new TokenInfo(contentType, this.myContentSize - s.length(), this.myContentSize));
            }
            if ((s.indexOf(10) >= 0 || s.indexOf(13) >= 0) && contentType == ConsoleViewContentType.USER_INPUT) {
                this.flushDeferredUserInput();
            }
            if (this.myFlushAlarm.getActiveRequestCount() == 0 && this.myEditor != null) {
                boolean shouldFlushNow = this.USE_CYCLIC_BUFFER && this.myDeferredOutput.length() > this.CYCLIC_BUFFER_SIZE;
                this.myFlushAlarm.addRequest(this.myFlushDeferredRunnable, shouldFlushNow ? 0 : 200, this.getStateForUpdate());
            }
        }
    }

    private ModalityState getStateForUpdate() {
        return this.myStateForUpdate != null ? (ModalityState)this.myStateForUpdate.compute() : ModalityState.stateForComponent((Component)this);
    }

    private void requestFlushImmediately() {
        if (this.myEditor != null) {
            this.myFlushAlarm.addRequest(this.myFlushDeferredRunnable, 0, this.getStateForUpdate());
        }
    }

    public int getContentSize() {
        return this.myContentSize;
    }

    public boolean canPause() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDeferredText() {
        String text;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myOutputPaused) {
                return;
            }
            if (this.myDeferredOutput.length() == 0) {
                return;
            }
            if (this.myEditor == null) {
                return;
            }
            text = this.myDeferredOutput.substring(0, this.myDeferredOutput.length());
            if (this.USE_CYCLIC_BUFFER) {
                this.myDeferredOutput = new StringBuffer(Math.min(this.myDeferredOutput.length(), this.CYCLIC_BUFFER_SIZE));
            } else {
                this.myDeferredOutput.setLength(0);
            }
        }
        final Document document = this.myEditor.getDocument();
        int oldLineCount = document.getLineCount();
        boolean isAtEndOfDocument = this.myEditor.getCaretModel().getOffset() == document.getTextLength();
        boolean cycleUsed = this.USE_CYCLIC_BUFFER && document.getTextLength() + text.length() > this.CYCLIC_BUFFER_SIZE;
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                document.insertString(document.getTextLength(), (CharSequence)text);
                Object object = ConsoleViewImpl.this.LOCK;
                synchronized (object) {
                    ConsoleViewImpl.this.fireChange();
                }
            }
        }, null, (Object)DocCommandGroupId.noneGroupId((Document)document));
        this.myPsiDisposedCheck.performCheck();
        int newLineCount = document.getLineCount();
        if (cycleUsed) {
            int lineCount = LineTokenizer.calcLineCount((CharSequence)text, (boolean)true);
            Iterator<RangeHighlighter> it = this.myHyperlinks.getRanges().keySet().iterator();
            while (it.hasNext()) {
                if (it.next().isValid()) continue;
                it.remove();
            }
            this.highlightHyperlinksAndFoldings(newLineCount >= lineCount + 1 ? newLineCount - lineCount - 1 : 0, newLineCount - 1);
        } else if (oldLineCount < newLineCount) {
            this.highlightHyperlinksAndFoldings(oldLineCount - 1, newLineCount - 2);
        }
        if (isAtEndOfDocument) {
            this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getTextLength());
            this.myEditor.getSelectionModel().removeSelection();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private void flushDeferredUserInput() {
        String text = this.myDeferredUserInput.substring(0, this.myDeferredUserInput.length());
        int index = Math.max(text.lastIndexOf(10), text.lastIndexOf(13));
        if (index < 0) {
            return;
        }
        final String textToSend = text.substring(0, index + 1);
        this.myDeferredUserInput.setLength(0);
        this.myDeferredUserInput.append(text.substring(index + 1));
        this.myFlushUserInputAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (ConsoleViewImpl.this.myState.isRunning()) {
                    try {
                        ConsoleViewImpl.this.myState.sendUserInput(textToSend);
                    }
                    catch (IOException e) {
                        return;
                    }
                }
            }
        }, 0);
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            OpenFileDescriptor openFileDescriptor;
            if (this.myEditor == null) {
                return null;
            }
            LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
            HyperlinkInfo info = this.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = info instanceof FileHyperlinkInfo ? ((FileHyperlinkInfo)info).getDescriptor() : null;
            if (openFileDescriptor == null || !openFileDescriptor.getFile().isValid()) {
                return null;
            }
            return openFileDescriptor;
        }
        if (PlatformDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    public void addMessageFilter(Filter filter) {
        this.myCustomFilter.addFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        if (this.myEditor == null) {
            return;
        }
        this.print(hyperlinkText, ConsoleViewContentType.NORMAL_OUTPUT);
        this.flushDeferredText();
        int textLength = this.myEditor.getDocument().getTextLength();
        this.addHyperlink(textLength - hyperlinkText.length(), textLength, null, info, ConsoleViewImpl.getHyperlinkAttributes());
    }

    public static TextAttributes getHyperlinkAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    }

    public static TextAttributes getFollowedHyperlinkAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
    }

    private Editor createEditor() {
        return (Editor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Editor>(){

            public Editor compute() {
                return ConsoleViewImpl.this.doCreateEditor();
            }
        });
    }

    private Editor doCreateEditor() {
        final EditorEx editor = this.createRealEditor();
        editor.addEditorMouseListener((EditorMouseListener)new EditorMouseAdapter(){

            public void mouseReleased(EditorMouseEvent e) {
                MouseEvent mouseEvent = e.getMouseEvent();
                if (!mouseEvent.isPopupTrigger()) {
                    ConsoleViewImpl.this.navigate(e);
                }
            }
        });
        editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                MouseEvent mouseEvent = event.getMouseEvent();
                ConsoleViewImpl.this.popupInvoked(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        int bufferSize = this.USE_CYCLIC_BUFFER ? this.CYCLIC_BUFFER_SIZE : 0;
        editor.getDocument().setCyclicBufferSize(bufferSize);
        editor.putUserData(CONSOLE_VIEW_IN_EDITOR_VIEW, this);
        editor.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HyperlinkInfo info = ConsoleViewImpl.this.getHyperlinkInfoByPoint(e.getPoint());
                if (info != null) {
                    editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        });
        return editor;
    }

    protected EditorEx createRealEditor() {
        EditorFactoryImpl document = (EditorFactoryImpl)EditorFactory.getInstance();
        Document editorDocument = document.createDocument(true);
        editorDocument.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (ConsoleViewImpl.this.myFileType != null) {
                    ConsoleViewImpl.this.highlightUserTokens();
                }
            }
        });
        EditorEx editor = (EditorEx)document.createViewer(editorDocument, this.myProject);
        MyHighlighter highlighter = new MyHighlighter();
        editor.setHighlighter(highlighter);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(true);
        editorSettings.setAdditionalPageAtBottom(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(0);
        EditorColorsScheme scheme = editor.getColorsScheme();
        editor.setBackgroundColor(scheme.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY));
        scheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        scheme.setColor(EditorColors.RIGHT_MARGIN_COLOR, null);
        final ConsoleViewImpl consoleView = this;
        editor.getContentComponent().addKeyListener(new KeyListener(){
            private int historyPosition;
            {
                this.historyPosition = ConsoleViewImpl.this.myHistory.size();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isAltDown() && !e.isControlDown() && !e.isMetaDown() && !e.isShiftDown()) {
                    if (e.getKeyCode() == 38) {
                        --this.historyPosition;
                        if (this.historyPosition < 0) {
                            this.historyPosition = 0;
                        }
                        this.replaceString();
                        e.consume();
                    } else if (e.getKeyCode() == 40) {
                        ++this.historyPosition;
                        if (this.historyPosition > ConsoleViewImpl.this.myHistory.size()) {
                            this.historyPosition = ConsoleViewImpl.this.myHistory.size();
                        }
                        this.replaceString();
                        e.consume();
                    }
                } else {
                    this.historyPosition = ConsoleViewImpl.this.myHistory.size();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void replaceString() {
                String str = ConsoleViewImpl.this.myHistory.size() == this.historyPosition ? "" : (String)ConsoleViewImpl.this.myHistory.get(this.historyPosition);
                Object object = ConsoleViewImpl.this.LOCK;
                synchronized (object) {
                    if (ConsoleViewImpl.this.myTokens.isEmpty()) {
                        return;
                    }
                    TokenInfo info = (TokenInfo)ConsoleViewImpl.this.myTokens.get(ConsoleViewImpl.this.myTokens.size() - 1);
                    if (info.contentType != ConsoleViewContentType.USER_INPUT) {
                        consoleView.insertUserText(str, 0);
                    } else {
                        consoleView.replaceUserText(str, info.startOffset, info.endOffset);
                    }
                }
            }
        });
        ConsoleViewImpl.setEditorUpActions(editor);
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightUserTokens() {
        if (this.myTokens.isEmpty()) {
            return;
        }
        TokenInfo token = this.myTokens.get(this.myTokens.size() - 1);
        if (token.contentType == ConsoleViewContentType.USER_INPUT) {
            String text = this.myEditor.getDocument().getText().substring(token.startOffset, token.endOffset);
            PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("dummy", this.myFileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
            assert (document != null);
            Editor editor = EditorFactory.getInstance().createEditor(document, this.myProject, this.myFileType, false);
            try {
                RangeHighlighter[] allHighlighters;
                for (RangeHighlighter highlighter : allHighlighters = this.myEditor.getMarkupModel().getAllHighlighters()) {
                    if (highlighter.getStartOffset() < token.startOffset) continue;
                    this.myEditor.getMarkupModel().removeHighlighter(highlighter);
                }
                HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(0);
                while (!iterator.atEnd()) {
                    this.myEditor.getMarkupModel().addRangeHighlighter(iterator.getStart() + token.startOffset, iterator.getEnd() + token.startOffset, 2000, iterator.getTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
                    iterator.advance();
                }
            }
            finally {
                EditorFactory.getInstance().releaseEditor(editor);
            }
        }
    }

    private static void setEditorUpActions(Editor editor) {
        new EnterHandler().registerCustomShortcutSet(CommonShortcuts.ENTER, editor.getContentComponent());
        ConsoleViewImpl.registerActionHandler(editor, "EditorPaste", new PasteHandler());
        ConsoleViewImpl.registerActionHandler(editor, "EditorBackSpace", new BackSpaceHandler());
        ConsoleViewImpl.registerActionHandler(editor, "EditorDelete", new DeleteHandler());
    }

    private static void registerActionHandler(Editor editor, String actionId, AnAction action) {
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(actionId);
        action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), editor.getContentComponent());
    }

    private void popupInvoked(Component component, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ClearAllAction());
        group.add((AnAction)new CopyAction());
        group.addSeparator();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("CompareClipboardWithSelection"));
        ActionPopupMenu menu = actionManager.createActionPopupMenu("unknown", (ActionGroup)group);
        menu.getComponent().show(component, x, y);
    }

    private void navigate(EditorMouseEvent event) {
        if (event.getMouseEvent().isPopupTrigger()) {
            return;
        }
        Point p = event.getMouseEvent().getPoint();
        HyperlinkInfo info = this.getHyperlinkInfoByPoint(p);
        if (info != null) {
            info.navigate(this.myProject);
            this.linkFollowed(info);
        }
    }

    private void linkFollowed(HyperlinkInfo info) {
        ConsoleViewImpl.linkFollowed(this.myEditor, this.myHyperlinks, info);
    }

    public static void linkFollowed(Editor editor, Hyperlinks hyperlinks, HyperlinkInfo info) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        for (Map.Entry<RangeHighlighter, HyperlinkInfo> entry : hyperlinks.getRanges().entrySet()) {
            RangeHighlighter range = entry.getKey();
            TextAttributes oldAttr = (TextAttributes)range.getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES);
            if (oldAttr != null) {
                markupModel.setRangeHighlighterAttributes(range, oldAttr);
                range.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, null);
            }
            if (entry.getValue() != info) continue;
            TextAttributes oldAttributes = range.getTextAttributes();
            range.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, (Object)oldAttributes);
            TextAttributes attributes = ConsoleViewImpl.getFollowedHyperlinkAttributes().clone();
            assert (oldAttributes != null);
            attributes.setFontType(oldAttributes.getFontType());
            attributes.setEffectType(oldAttributes.getEffectType());
            attributes.setEffectColor(oldAttributes.getEffectColor());
            attributes.setForegroundColor(oldAttributes.getForegroundColor());
            markupModel.setRangeHighlighterAttributes(range, attributes);
        }
        RangeHighlighter dummy = markupModel.addRangeHighlighter(0, 0, 5877, ConsoleViewImpl.getHyperlinkAttributes(), HighlighterTargetArea.EXACT_RANGE);
        markupModel.removeHighlighter(dummy);
    }

    public HyperlinkInfo getHyperlinkInfoByPoint(Point p) {
        return ConsoleViewImpl.getHyperlinkInfoByPoint(this.myEditor, this.myHyperlinks, p);
    }

    public static HyperlinkInfo getHyperlinkInfoByPoint(Editor editor, Hyperlinks hyperlinks, Point p) {
        LogicalPosition pos = editor.xyToLogicalPosition(new Point(p.x, p.y));
        return ConsoleViewImpl.getHyperlinkInfoByLineAndCol(editor, hyperlinks, pos.line, pos.column);
    }

    private HyperlinkInfo getHyperlinkInfoByLineAndCol(int line, int col) {
        return ConsoleViewImpl.getHyperlinkInfoByLineAndCol(this.myEditor, this.myHyperlinks, line, col);
    }

    public static HyperlinkInfo getHyperlinkInfoByLineAndCol(Editor editor, Hyperlinks hyperlinks, int line, int col) {
        int offset = editor.logicalPositionToOffset(new LogicalPosition(line, col));
        return hyperlinks.getHyperlinkAt(offset);
    }

    private void highlightHyperlinksAndFoldings(int line1, int endLine) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        ConsoleViewImpl.highlightHyperlinks(this.myEditor, this.myHyperlinks, (Filter)this.myCustomFilter, (Filter)this.myPredefinedMessageFilter, line1, endLine);
        this.updateFoldings(line1, endLine);
    }

    private void updateFoldings(int line1, int endLine) {
        Document document = this.myEditor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int startLine = Math.max(0, line1);
        ArrayList<FoldRegion> toAdd = new ArrayList<FoldRegion>();
        for (int line = startLine; line <= endLine; ++line) {
            this.addFolding(document, chars, line, toAdd);
        }
        if (!toAdd.isEmpty()) {
            this.doUpdateFolding(toAdd);
        }
    }

    public static void highlightHyperlinks(Editor editor, Hyperlinks hyperlinks, Filter myCustomFilter, Filter myPredefinedMessageFilter, int line1, int endLine) {
        int startLine;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        TextAttributes hyperlinkAttributes = ConsoleViewImpl.getHyperlinkAttributes();
        for (int line = startLine = Math.max(0, line1); line <= endLine; ++line) {
            String text;
            Filter.Result result;
            int endOffset = document.getLineEndOffset(line);
            if (endOffset < document.getTextLength()) {
                ++endOffset;
            }
            if ((result = myCustomFilter.applyFilter(text = ConsoleViewImpl.getLineText(document, line, true), endOffset)) == null) {
                result = myPredefinedMessageFilter.applyFilter(text, endOffset);
            }
            if (result == null) continue;
            int highlightStartOffset = result.highlightStartOffset;
            int highlightEndOffset = result.highlightEndOffset;
            HyperlinkInfo hyperlinkInfo = result.hyperlinkInfo;
            ConsoleViewImpl.addHyperlink(editor, hyperlinks, highlightStartOffset, highlightEndOffset, result.highlightAttributes, hyperlinkInfo, hyperlinkAttributes);
        }
    }

    private void doUpdateFolding(List<FoldRegion> toAdd) {
        ConsoleViewImpl.assertIsDispatchThread();
        this.myPendingFoldRegions.addAll(toAdd);
        this.myFoldingAlarm.cancelAllRequests();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ConsoleViewImpl.assertIsDispatchThread();
                final FoldingModel model = ConsoleViewImpl.this.myEditor.getFoldingModel();
                model.runBatchFoldingOperationDoNotCollapseCaret(new Runnable(){

                    @Override
                    public void run() {
                        ConsoleViewImpl.assertIsDispatchThread();
                        for (FoldRegion region : ConsoleViewImpl.this.myPendingFoldRegions) {
                            region.setExpanded(false);
                            model.addFoldRegion(region);
                        }
                        ConsoleViewImpl.this.myPendingFoldRegions.clear();
                    }
                });
            }
        };
        if (this.myPendingFoldRegions.size() > 100) {
            runnable.run();
        } else {
            this.myFoldingAlarm.addRequest(runnable, 50);
        }
    }

    private void addFolding(Document document, CharSequence chars, int line, List<FoldRegion> toAdd) {
        ConsoleFolding current = ConsoleViewImpl.foldingForLine(ConsoleViewImpl.getLineText(document, line, false));
        this.myFolding.put(line, (Object)current);
        ConsoleFolding prevFolding = (ConsoleFolding)this.myFolding.get(line - 1);
        if (current == null && prevFolding != null) {
            int lEnd;
            int lStart = lEnd = line - 1;
            while (prevFolding.equals(this.myFolding.get(lStart - 1))) {
                --lStart;
            }
            if (lStart == lEnd) {
                return;
            }
            ArrayList<String> toFold = new ArrayList<String>(lEnd - lStart + 1);
            for (int i = lStart; i <= lEnd; ++i) {
                toFold.add(ConsoleViewImpl.getLineText(document, i, false));
            }
            int oStart = document.getLineStartOffset(lStart);
            if (oStart > 0) {
                --oStart;
            }
            int oEnd = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(document.getLineEndOffset(lEnd) - 1), (String)" \t") + 1;
            FoldRegion region = ((FoldingModelEx)this.myEditor.getFoldingModel()).createFoldRegion(oStart, oEnd, prevFolding.getPlaceholderText(toFold), null);
            toAdd.add(region);
        }
    }

    public static String getLineText(Document document, int lineNumber, boolean includeEol) {
        int endOffset = document.getLineEndOffset(lineNumber);
        if (includeEol && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        return ((Object)document.getCharsSequence().subSequence(document.getLineStartOffset(lineNumber), endOffset)).toString();
    }

    @Nullable
    private static ConsoleFolding foldingForLine(String lineText) {
        for (ConsoleFolding folding : (ConsoleFolding[])ConsoleFolding.EP_NAME.getExtensions()) {
            if (!folding.shouldFoldLine(lineText)) continue;
            return folding;
        }
        return null;
    }

    private void addHyperlink(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes, HyperlinkInfo hyperlinkInfo, TextAttributes hyperlinkAttributes) {
        ConsoleViewImpl.addHyperlink(this.myEditor, this.myHyperlinks, highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo, hyperlinkAttributes);
    }

    private static void addHyperlink(Editor editor, Hyperlinks hyperlinks, int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes, HyperlinkInfo hyperlinkInfo, TextAttributes hyperlinkAttributes) {
        TextAttributes textAttributes = highlightAttributes != null ? highlightAttributes : hyperlinkAttributes;
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, 5877, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        hyperlinks.add(highlighter, hyperlinkInfo);
    }

    private int findTokenInfoIndexByOffset(int offset) {
        int low = 0;
        int high = this.myTokens.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            TokenInfo midVal = this.myTokens.get(mid);
            if (offset < midVal.startOffset) {
                high = mid - 1;
                continue;
            }
            if (offset >= midVal.endOffset) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return this.myTokens.size();
    }

    public JComponent getPreferredFocusableComponent() {
        this.getComponent();
        return this.myEditor.getContentComponent();
    }

    public boolean hasNextOccurence() {
        return this.next(1, false) != null;
    }

    public boolean hasPreviousOccurence() {
        return this.next(-1, false) != null;
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.next(1, true);
    }

    private OccurenceNavigator.OccurenceInfo next(int delta, boolean doMove) {
        RangeHighlighter next;
        RangeHighlighter range;
        int i;
        ArrayList<RangeHighlighter> ranges = new ArrayList<RangeHighlighter>(this.myHyperlinks.getRanges().keySet());
        Iterator iterator = ranges.iterator();
        while (iterator.hasNext()) {
            RangeHighlighter highlighter = (RangeHighlighter)iterator.next();
            if (this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(highlighter.getStartOffset()) == null) continue;
            iterator.remove();
        }
        Collections.sort(ranges, new Comparator<RangeHighlighter>(){

            @Override
            public int compare(RangeHighlighter o1, RangeHighlighter o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        for (i = 0; i < ranges.size() && (range = (RangeHighlighter)ranges.get(i)).getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES) == null; ++i) {
        }
        int newIndex = ranges.isEmpty() ? -1 : (i == ranges.size() ? 0 : (i + delta + ranges.size()) % ranges.size());
        RangeHighlighter rangeHighlighter = next = newIndex < ranges.size() && newIndex >= 0 ? (RangeHighlighter)ranges.get(newIndex) : null;
        if (next == null) {
            return null;
        }
        if (doMove) {
            this.scrollTo(next.getStartOffset());
        }
        final HyperlinkInfo hyperlinkInfo = this.myHyperlinks.getRanges().get(next);
        return new OccurenceNavigator.OccurenceInfo(new Navigatable(){

            public void navigate(boolean requestFocus) {
                hyperlinkInfo.navigate(ConsoleViewImpl.this.myProject);
                ConsoleViewImpl.this.linkFollowed(hyperlinkInfo);
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        }, i, ranges.size());
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.next(-1, true);
    }

    public String getNextOccurenceActionName() {
        return ExecutionBundle.message((String)"down.the.stack.trace", (Object[])new Object[0]);
    }

    public String getPreviousOccurenceActionName() {
        return ExecutionBundle.message((String)"up.the.stack.trace", (Object[])new Object[0]);
    }

    public void addCustomConsoleAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/ConsoleViewImpl.addCustomConsoleAction must not be null");
        }
        this.customActions.add(action);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
        prevAction.getTemplatePresentation().setText(this.getPreviousOccurenceActionName());
        AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
        nextAction.getTemplatePresentation().setText(this.getNextOccurenceActionName());
        AnAction[] consoleActions = new AnAction[2 + this.customActions.size()];
        consoleActions[0] = prevAction;
        consoleActions[1] = nextAction;
        for (int i = 0; i < this.customActions.size(); ++i) {
            consoleActions[i + 2] = this.customActions.get(i);
        }
        if (consoleActions == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/ConsoleViewImpl.createConsoleActions must not return null");
        }
        return consoleActions;
    }

    public void setEditorEnabled(boolean enabled) {
        this.myEditor.getContentComponent().setEnabled(enabled);
    }

    private void fireChange() {
        if (this.myDeferredTypes.isEmpty()) {
            return;
        }
        Collection<ConsoleViewContentType> types = Collections.unmodifiableCollection(this.myDeferredTypes);
        for (ObservableConsoleView.ChangeListener each : this.myListeners) {
            each.contentAdded(types);
        }
        this.myDeferredTypes.clear();
    }

    public void addChangeListener(final ObservableConsoleView.ChangeListener listener, Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                ConsoleViewImpl.this.myListeners.remove(listener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUserText(String s, int offset) {
        int startOffset;
        ConsoleViewImpl consoleView = this;
        Editor editor = consoleView.myEditor;
        Document document = editor.getDocument();
        Object object = consoleView.LOCK;
        synchronized (object) {
            if (consoleView.myTokens.isEmpty()) {
                return;
            }
            TokenInfo info = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
            if (info.contentType != ConsoleViewContentType.USER_INPUT && !s.contains("\n")) {
                consoleView.print(s, ConsoleViewContentType.USER_INPUT);
                consoleView.flushDeferredText();
                editor.getCaretModel().moveToOffset(document.getTextLength());
                editor.getSelectionModel().removeSelection();
                return;
            }
            if (info.contentType != ConsoleViewContentType.USER_INPUT) {
                this.insertUserText("temp", offset);
                TokenInfo newInfo = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
                this.replaceUserText(s, newInfo.startOffset, newInfo.endOffset);
                return;
            }
            int deferredOffset = this.myContentSize - consoleView.myDeferredUserInput.length();
            startOffset = offset > info.endOffset ? info.endOffset : (offset < info.startOffset ? Math.max(info.startOffset, deferredOffset) : Math.max(offset, deferredOffset));
            consoleView.myDeferredUserInput.insert(startOffset - deferredOffset, s);
            int charCountToAdd = s.length();
            info.endOffset += charCountToAdd;
            consoleView.myContentSize += charCountToAdd;
        }
        document.insertString(startOffset, (CharSequence)s);
        editor.getCaretModel().moveToOffset(Math.min(startOffset + s.length(), document.getTextLength()));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceUserText(String s, int start, int end) {
        int endOffset;
        int startOffset;
        if (start == end) {
            this.insertUserText(s, start);
            return;
        }
        ConsoleViewImpl consoleView = this;
        Editor editor = consoleView.myEditor;
        Document document = editor.getDocument();
        Object object = consoleView.LOCK;
        synchronized (object) {
            if (consoleView.myTokens.isEmpty()) {
                return;
            }
            TokenInfo info = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
            if (info.contentType != ConsoleViewContentType.USER_INPUT) {
                consoleView.print(s, ConsoleViewContentType.USER_INPUT);
                consoleView.flushDeferredText();
                editor.getCaretModel().moveToOffset(document.getTextLength());
                editor.getSelectionModel().removeSelection();
                return;
            }
            if (consoleView.myDeferredUserInput.length() == 0) {
                return;
            }
            int deferredOffset = this.myContentSize - consoleView.myDeferredUserInput.length();
            startOffset = ConsoleViewImpl.getStartOffset(start, info, deferredOffset);
            endOffset = ConsoleViewImpl.getEndOffset(end, info);
            if (startOffset == -1 || endOffset == -1 || endOffset <= startOffset) {
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().moveToOffset(start);
                return;
            }
            int charCountToReplace = s.length() - endOffset + startOffset;
            consoleView.myDeferredUserInput.replace(startOffset - deferredOffset, endOffset - deferredOffset, s);
            info.endOffset += charCountToReplace;
            if (info.startOffset == info.endOffset) {
                consoleView.myTokens.remove(consoleView.myTokens.size() - 1);
            }
            consoleView.myContentSize += charCountToReplace;
        }
        document.replaceString(startOffset, endOffset, (CharSequence)s);
        editor.getCaretModel().moveToOffset(startOffset + s.length());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUserText(int offset, int length) {
        int endOffset;
        int startOffset;
        ConsoleViewImpl consoleView = this;
        Editor editor = consoleView.myEditor;
        Document document = editor.getDocument();
        Object object = consoleView.LOCK;
        synchronized (object) {
            if (consoleView.myTokens.isEmpty()) {
                return;
            }
            TokenInfo info = consoleView.myTokens.get(consoleView.myTokens.size() - 1);
            if (info.contentType != ConsoleViewContentType.USER_INPUT) {
                return;
            }
            if (consoleView.myDeferredUserInput.length() == 0) {
                return;
            }
            int deferredOffset = this.myContentSize - consoleView.myDeferredUserInput.length();
            startOffset = ConsoleViewImpl.getStartOffset(offset, info, deferredOffset);
            endOffset = ConsoleViewImpl.getEndOffset(offset + length, info);
            if (startOffset == -1 || endOffset == -1 || endOffset <= startOffset || startOffset < deferredOffset) {
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().moveToOffset(offset);
                return;
            }
            consoleView.myDeferredUserInput.delete(startOffset - deferredOffset, endOffset - deferredOffset);
            int charCountToDelete = endOffset - startOffset;
            info.endOffset -= charCountToDelete;
            if (info.startOffset == info.endOffset) {
                consoleView.myTokens.remove(consoleView.myTokens.size() - 1);
            }
            consoleView.myContentSize -= charCountToDelete;
        }
        document.deleteString(startOffset, endOffset);
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static int getStartOffset(int offset, TokenInfo info, int deferredOffset) {
        int startOffset = offset >= info.startOffset && offset < info.endOffset ? Math.max(offset, deferredOffset) : (offset < info.startOffset ? Math.max(info.startOffset, deferredOffset) : -1);
        return startOffset;
    }

    private static int getEndOffset(int offset, TokenInfo info) {
        int endOffset = offset > info.endOffset ? info.endOffset : (offset <= info.startOffset ? -1 : offset);
        return endOffset;
    }

    static {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        TypedAction typedAction = actionManager.getTypedAction();
        typedAction.setupHandler((TypedActionHandler)new MyTypedHandler(typedAction.getHandler()));
        OLD_HYPERLINK_TEXT_ATTRIBUTES = Key.create((String)"OLD_HYPERLINK_TEXT_ATTRIBUTES");
    }

    public static class Hyperlinks {
        private static final int NO_INDEX = Integer.MIN_VALUE;
        private final Map<RangeHighlighter, HyperlinkInfo> myHighlighterToMessageInfoMap = new HashMap();
        private int myLastIndex = Integer.MIN_VALUE;

        public void clear() {
            this.myHighlighterToMessageInfoMap.clear();
            this.myLastIndex = Integer.MIN_VALUE;
        }

        public HyperlinkInfo getHyperlinkAt(int offset) {
            for (RangeHighlighter highlighter : this.myHighlighterToMessageInfoMap.keySet()) {
                if (!highlighter.isValid() || !Hyperlinks.containsOffset(offset, highlighter)) continue;
                return this.myHighlighterToMessageInfoMap.get(highlighter);
            }
            return null;
        }

        private static boolean containsOffset(int offset, RangeHighlighter highlighter) {
            return highlighter.getStartOffset() <= offset && offset <= highlighter.getEndOffset();
        }

        public void add(RangeHighlighter highlighter, HyperlinkInfo hyperlinkInfo) {
            this.myHighlighterToMessageInfoMap.put(highlighter, hyperlinkInfo);
            if (this.myLastIndex != Integer.MIN_VALUE && Hyperlinks.containsOffset(this.myLastIndex, highlighter)) {
                this.myLastIndex = Integer.MIN_VALUE;
            }
        }

        public Map<RangeHighlighter, HyperlinkInfo> getRanges() {
            return this.myHighlighterToMessageInfoMap;
        }
    }

    private static class DeleteHandler
    extends ConsoleAction {
        private DeleteHandler() {
        }

        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            Editor editor = consoleView.myEditor;
            if (IncrementalSearchHandler.isHintVisible(editor)) {
                DeleteHandler.getDefaultActionHandler().execute(editor, context);
                return;
            }
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else {
                consoleView.deleteUserText(editor.getCaretModel().getOffset(), 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }
    }

    private static class BackSpaceHandler
    extends ConsoleAction {
        private BackSpaceHandler() {
        }

        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            Editor editor = consoleView.myEditor;
            if (IncrementalSearchHandler.isHintVisible(editor)) {
                BackSpaceHandler.getDefaultActionHandler().execute(editor, context);
                return;
            }
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else if (editor.getCaretModel().getOffset() > 0) {
                consoleView.deleteUserText(editor.getCaretModel().getOffset() - 1, 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }
    }

    private static class PasteHandler
    extends ConsoleAction {
        private PasteHandler() {
        }

        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            Transferable content = CopyPasteManager.getInstance().getContents();
            if (content == null) {
                return;
            }
            String s = null;
            try {
                s = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                consoleView.getToolkit().beep();
            }
            if (s == null) {
                return;
            }
            Editor editor = consoleView.myEditor;
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.replaceUserText(s, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            } else {
                consoleView.insertUserText(s, editor.getCaretModel().getOffset());
            }
        }
    }

    private static class EnterHandler
    extends ConsoleAction {
        private EnterHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(ConsoleViewImpl consoleView, DataContext context) {
            Object object = consoleView.LOCK;
            synchronized (object) {
                String str = consoleView.myDeferredUserInput.toString();
                if (StringUtil.isNotEmpty((String)str)) {
                    consoleView.myHistory.remove(str);
                    consoleView.myHistory.add(str);
                    if (consoleView.myHistory.size() > consoleView.myHistorySize) {
                        consoleView.myHistory.remove(0);
                    }
                }
                for (ConsoleInputListener listener : consoleView.myConsoleInputListeners) {
                    listener.textEntered(str);
                }
            }
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            consoleView.flushDeferredText();
            Editor editor = consoleView.myEditor;
            editor.getCaretModel().moveToOffset(editor.getDocument().getTextLength());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static abstract class ConsoleAction
    extends AnAction
    implements DumbAware {
        private ConsoleAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            DataContext context = e.getDataContext();
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(context);
            this.execute(console, context);
        }

        protected abstract void execute(ConsoleViewImpl var1, DataContext var2);

        public void update(AnActionEvent e) {
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(e.getDataContext());
            e.getPresentation().setEnabled(console != null);
        }

        @Nullable
        private static ConsoleViewImpl getRunningConsole(DataContext context) {
            ConsoleViewImpl console;
            Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(context);
            if (editor != null && (console = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW)) != null && console.myState.isRunning()) {
                return console;
            }
            return null;
        }
    }

    private static class MyTypedHandler
    implements TypedActionHandler {
        private final TypedActionHandler myOriginalHandler;

        private MyTypedHandler(TypedActionHandler originalAction) {
            this.myOriginalHandler = originalAction;
        }

        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler.execute must not be null");
            }
            if (dataContext == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler.execute must not be null");
            }
            ConsoleViewImpl consoleView = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW);
            if (consoleView == null || !consoleView.myState.isRunning() || consoleView.isViewer) {
                this.myOriginalHandler.execute(editor, charTyped, dataContext);
            } else {
                String s = String.valueOf(charTyped);
                SelectionModel selectionModel = editor.getSelectionModel();
                if (selectionModel.hasSelection()) {
                    consoleView.replaceUserText(s, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                } else {
                    consoleView.insertUserText(s, editor.getCaretModel().getOffset());
                }
            }
        }
    }

    private class MyHighlighter
    extends DocumentAdapter
    implements EditorHighlighter {
        private HighlighterClient myEditor;

        private MyHighlighter() {
        }

        public HighlighterIterator createIterator(int startOffset) {
            final int startIndex = ConsoleViewImpl.this.findTokenInfoIndexByOffset(startOffset);
            return new HighlighterIterator(){
                private int myIndex;
                {
                    this.myIndex = startIndex;
                }

                public TextAttributes getTextAttributes() {
                    if (ConsoleViewImpl.this.myFileType != null && this.getTokenInfo().contentType == ConsoleViewContentType.USER_INPUT) {
                        return ConsoleViewContentType.NORMAL_OUTPUT.getAttributes();
                    }
                    return this.getTokenInfo() == null ? null : this.getTokenInfo().attributes;
                }

                public int getStart() {
                    return this.getTokenInfo() == null ? 0 : this.getTokenInfo().startOffset;
                }

                public int getEnd() {
                    return this.getTokenInfo() == null ? 0 : this.getTokenInfo().endOffset;
                }

                public IElementType getTokenType() {
                    return null;
                }

                public void advance() {
                    ++this.myIndex;
                }

                public void retreat() {
                    --this.myIndex;
                }

                public boolean atEnd() {
                    return this.myIndex < 0 || this.myIndex >= ConsoleViewImpl.this.myTokens.size();
                }

                public Document getDocument() {
                    return MyHighlighter.this.myEditor.getDocument();
                }

                private TokenInfo getTokenInfo() {
                    return (TokenInfo)ConsoleViewImpl.this.myTokens.get(this.myIndex);
                }
            };
        }

        public void setText(CharSequence text) {
        }

        public void setEditor(HighlighterClient editor) {
            LOG.assertTrue(this.myEditor == null, (Object)"Highlighters cannot be reused with different editors");
            this.myEditor = editor;
        }

        public void setColorScheme(EditorColorsScheme scheme) {
        }
    }

    private class CopyAction
    extends AnAction
    implements DumbAware {
        private CopyAction() {
            super(ConsoleViewImpl.this.myEditor != null && ConsoleViewImpl.this.myEditor.getSelectionModel().hasSelection() ? ExecutionBundle.message((String)"copy.selected.content.action.name", (Object[])new Object[0]) : ExecutionBundle.message((String)"copy.content.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            if (ConsoleViewImpl.this.myEditor == null) {
                return;
            }
            if (ConsoleViewImpl.this.myEditor.getSelectionModel().hasSelection()) {
                ConsoleViewImpl.this.myEditor.getSelectionModel().copySelectionToClipboard();
            } else {
                ConsoleViewImpl.this.myEditor.getSelectionModel().setSelection(0, ConsoleViewImpl.this.myEditor.getDocument().getTextLength());
                ConsoleViewImpl.this.myEditor.getSelectionModel().copySelectionToClipboard();
                ConsoleViewImpl.this.myEditor.getSelectionModel().removeSelection();
            }
        }
    }

    private class ClearAllAction
    extends AnAction
    implements DumbAware {
        private ClearAllAction() {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            ConsoleViewImpl.this.clear();
        }
    }

    private static class TokenInfo {
        private final ConsoleViewContentType contentType;
        private int startOffset;
        private int endOffset;
        private final TextAttributes attributes;

        private TokenInfo(ConsoleViewContentType contentType, int startOffset, int endOffset) {
            this.contentType = contentType;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.attributes = contentType.getAttributes();
        }
    }
}

