/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.impl.watch.EvaluationDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Value;

public class WatchItemDescriptor
extends EvaluationDescriptor {
    public WatchItemDescriptor(Project project, TextWithImports text) {
        super(text, project);
        this.setValueLabel("");
    }

    public WatchItemDescriptor(Project project, TextWithImports text, Value value) {
        super(text, project, value);
        this.setValueLabel("");
    }

    @Override
    public String getName() {
        return this.getEvaluationText().getText();
    }

    public void setNew() {
        this.myIsNew = true;
    }

    public void setEvaluationText(TextWithImports evaluationText) {
        if (!Comparing.equal((Object)this.getEvaluationText(), (Object)evaluationText)) {
            this.setLvalue(false);
        }
        this.myText = evaluationText;
        this.myIsNew = true;
        this.setValueLabel("");
    }

    @Override
    protected EvaluationContextImpl getEvaluationContext(EvaluationContextImpl evaluationContext) {
        return evaluationContext;
    }

    @Override
    protected PsiCodeFragment getEvaluationCode(StackFrameContext context) throws EvaluateException {
        PsiElement psiContext = PositionUtil.getContextElement(context);
        JavaCodeFragment fragment = this.getEffectiveCodeFragmentFactory(psiContext).createCodeFragment(this.getEvaluationText(), psiContext, this.myProject);
        fragment.forceResolveScope(GlobalSearchScope.allScope((Project)this.myProject));
        return fragment;
    }
}

