/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.DebuggerView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.sun.jdi.VMDisconnectedException;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class UpdatableDebuggerView
extends JPanel
implements DebuggerView {
    private final Project myProject;
    private final DebuggerStateManager myStateManager;
    protected final Alarm myRebuildAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private volatile boolean myRefreshNeeded = true;
    protected final List<Disposable> myDisposables = new ArrayList<Disposable>();
    private boolean myUpdateEnabled;

    protected UpdatableDebuggerView(Project project, DebuggerStateManager stateManager) {
        this.setLayout(new BorderLayout());
        this.myProject = project;
        this.myStateManager = stateManager;
        final DebuggerContextListener contextListener = new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                UpdatableDebuggerView.this.changeEvent(newContext, event);
            }
        };
        this.myStateManager.addListener(contextListener);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                UpdatableDebuggerView.this.myStateManager.removeListener(contextListener);
            }
        });
    }

    protected void changeEvent(DebuggerContextImpl newContext, int event) {
        if (newContext.getDebuggerSession() != null) {
            this.rebuildIfVisible(event);
        }
    }

    protected final boolean isUpdateEnabled() {
        return this.myUpdateEnabled;
    }

    @Override
    public final void setUpdateEnabled(boolean enabled) {
        this.myUpdateEnabled = enabled;
    }

    @Override
    public final boolean isRefreshNeeded() {
        return this.myRefreshNeeded;
    }

    @Override
    public final void rebuildIfVisible(final int event) {
        if (this.isUpdateEnabled()) {
            this.myRefreshNeeded = false;
            this.myRebuildAlarm.cancelAllRequests();
            this.myRebuildAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdatableDebuggerView.this.rebuild(event == 7 || event == 11);
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        // empty catch block
                    }
                }
            }, 100);
        } else {
            this.myRefreshNeeded = true;
        }
    }

    protected abstract void rebuild(boolean var1);

    protected final void registerDisposable(Disposable disposable) {
        this.myDisposables.add(disposable);
    }

    public DebuggerContextImpl getContext() {
        return this.myStateManager.getContext();
    }

    protected final Project getProject() {
        return this.myProject;
    }

    public DebuggerStateManager getContextManager() {
        return this.myStateManager;
    }

    public void dispose() {
        this.myRebuildAlarm.dispose();
        for (Disposable disposable : this.myDisposables) {
            disposable.dispose();
        }
        this.myDisposables.clear();
    }

    protected void overrideShortcut(final JComponent forComponent, String actionId, CustomShortcutSet shortcutSet) {
        final AnAction action = ActionManager.getInstance().getAction(actionId);
        action.registerCustomShortcutSet((ShortcutSet)shortcutSet, forComponent);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                action.unregisterCustomShortcutSet(forComponent);
            }
        });
    }
}

