/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Processor;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.ui.DebuggerIcons;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LineBreakpoint
extends BreakpointWithHighlighter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.LineBreakpoint");
    public static Icon ICON = DebuggerIcons.ENABLED_BREAKPOINT_ICON;
    public static final Icon MUTED_ICON = DebuggerIcons.MUTED_BREAKPOINT_ICON;
    public static final Icon DISABLED_ICON = DebuggerIcons.DISABLED_BREAKPOINT_ICON;
    public static final Icon MUTED_DISABLED_ICON = DebuggerIcons.MUTED_DISABLED_BREAKPOINT_ICON;
    private static final Icon ourVerifiedWarningsIcon = IconLoader.getIcon((String)"/debugger/db_verified_warning_breakpoint.png");
    private static final Icon ourMutedVerifiedWarningsIcon = IconLoader.getIcon((String)"/debugger/db_muted_verified_warning_breakpoint.png");
    private String myMethodName;
    @NonNls
    public static final Key<LineBreakpoint> CATEGORY = BreakpointCategory.lookup("line_breakpoints");

    protected LineBreakpoint(Project project) {
        super(project);
    }

    protected LineBreakpoint(Project project, RangeHighlighter highlighter) {
        super(project, highlighter);
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (isMuted) {
            return master == null ? MUTED_DISABLED_ICON : DebuggerIcons.MUTED_DISABLED_DEPENDENT_BREAKPOINT_ICON;
        }
        return master == null ? DISABLED_ICON : DebuggerIcons.DISABLED_DEPENDENT_BREAKPOINT_ICON;
    }

    @Override
    protected Icon getSetIcon(boolean isMuted) {
        return isMuted ? MUTED_ICON : ICON;
    }

    @Override
    protected Icon getInvalidIcon(boolean isMuted) {
        return isMuted ? DebuggerIcons.MUTED_INVALID_BREAKPOINT_ICON : DebuggerIcons.INVALID_BREAKPOINT_ICON;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return isMuted ? DebuggerIcons.MUTED_VERIFIED_BREAKPOINT_ICON : DebuggerIcons.VERIFIED_BREAKPOINT_ICON;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return isMuted ? ourMutedVerifiedWarningsIcon : ourVerifiedWarningsIcon;
    }

    public Key<LineBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    protected void reload(PsiFile file) {
        super.reload(file);
        this.myMethodName = LineBreakpoint.findMethodName(file, this.getHighlighter().getStartOffset());
    }

    @Override
    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        if (this.isInScopeOf(debugProcess, classToBeLoaded)) {
            super.createOrWaitPrepare(debugProcess, classToBeLoaded);
        }
    }

    @Override
    protected void createRequestForPreparedClass(final DebugProcessImpl debugProcess, final ReferenceType classType) {
        if (!this.isInScopeOf(debugProcess, classType.name())) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Location> locs = debugProcess.getPositionManager().locationsOfLine(classType, LineBreakpoint.this.getSourcePosition());
                    if (locs.size() > 0) {
                        for (Location location : locs) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Found location for reference type " + classType.name() + " at line " + LineBreakpoint.this.getLineIndex() + "; isObsolete: " + (debugProcess.getVirtualMachineProxy().versionHigher("1.4") && location.method().isObsolete()));
                            }
                            BreakpointRequest request = debugProcess.getRequestsManager().createBreakpointRequest(LineBreakpoint.this, location);
                            debugProcess.getRequestsManager().enableRequest(request);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Created breakpoint request for reference type " + classType.name() + " at line " + LineBreakpoint.this.getLineIndex());
                        }
                    } else {
                        debugProcess.getRequestsManager().setInvalid(LineBreakpoint.this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{LineBreakpoint.this.getLineIndex() + 1, classType.name()}));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No locations of type " + classType.name() + " found at line " + LineBreakpoint.this.getLineIndex());
                        }
                    }
                }
                catch (ClassNotPreparedException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ClassNotPreparedException: " + ex.getMessage());
                    }
                }
                catch (ObjectCollectedException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ObjectCollectedException: " + ex.getMessage());
                    }
                }
                catch (InvalidLineNumberException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("InvalidLineNumberException: " + ex.getMessage());
                    }
                    debugProcess.getRequestsManager().setInvalid(LineBreakpoint.this, DebuggerBundle.message((String)"error.invalid.breakpoint.bad.line.number", (Object[])new Object[0]));
                }
                catch (InternalException ex) {
                    LOG.info((Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.info((Throwable)ex);
                }
                LineBreakpoint.this.updateUI();
            }
        });
    }

    private boolean isInScopeOf(DebugProcessImpl debugProcess, String className) {
        SourcePosition position = this.getSourcePosition();
        if (position != null) {
            VirtualFile breakpointFile = position.getFile().getVirtualFile();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (breakpointFile != null && fileIndex.isInSourceContent(breakpointFile)) {
                Collection<VirtualFile> candidates = this.findClassCandidatesInSourceContent(className, debugProcess.getSearchScope(), fileIndex);
                if (candidates == null) {
                    return true;
                }
                for (VirtualFile classFile : candidates) {
                    if (!breakpointFile.equals(classFile)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> findClassCandidatesInSourceContent(String className, final GlobalSearchScope scope, final ProjectFileIndex fileIndex) {
        int dollarIndex = className.indexOf("$");
        final String topLevelClassName = dollarIndex >= 0 ? className.substring(0, dollarIndex) : className;
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<VirtualFile>>(){

            @Nullable
            public Collection<VirtualFile> compute() {
                PsiClass[] classes = JavaPsiFacade.getInstance((Project)LineBreakpoint.this.myProject).findClasses(topLevelClassName, scope);
                if (classes.length == 0) {
                    return null;
                }
                ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(classes.length);
                for (PsiClass aClass : classes) {
                    VirtualFile vFile;
                    PsiFile psiFile = aClass.getContainingFile();
                    if (psiFile == null || (vFile = psiFile.getVirtualFile()) == null || !fileIndex.isInSourceContent(vFile)) continue;
                    list.add(vFile);
                }
                return list;
            }
        });
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        if (this.CLASS_FILTERS_ENABLED) {
            ClassFilter[] ifilters;
            Value value = context.getThisObject();
            ObjectReference thisObject = (ObjectReference)value;
            if (thisObject == null) {
                return false;
            }
            String name = DebuggerUtilsEx.getQualifiedClassName(thisObject.referenceType().name(), this.getProject());
            if (name == null) {
                return false;
            }
            ClassFilter[] filters = this.getClassFilters();
            boolean matches = false;
            for (ClassFilter classFilter : filters) {
                if (!classFilter.isEnabled() || !classFilter.matches(name)) continue;
                matches = true;
                break;
            }
            if (!matches) {
                return false;
            }
            for (ClassFilter classFilter : ifilters = this.getClassExclusionFilters()) {
                if (!classFilter.isEnabled() || !classFilter.matches(name)) continue;
                return false;
            }
        }
        return super.evaluateCondition(context, event);
    }

    public String toString() {
        return this.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        int lineNumber = this.getHighlighter().getDocument().getLineNumber(this.getHighlighter().getStartOffset()) + 1;
        if (this.isValid()) {
            boolean hasMethodInfo;
            String className = this.getClassName();
            boolean hasClassInfo = className != null && className.length() > 0;
            boolean bl = hasMethodInfo = this.myMethodName != null && this.myMethodName.length() > 0;
            if (hasClassInfo || hasMethodInfo) {
                StringBuilder info = StringBuilderSpinAllocator.alloc();
                try {
                    String packageName = null;
                    if (hasClassInfo) {
                        int dotIndex = className.lastIndexOf(".");
                        if (dotIndex >= 0) {
                            info.append(className.substring(dotIndex + 1));
                            packageName = className.substring(0, dotIndex);
                        } else {
                            info.append(className);
                        }
                    }
                    if (hasMethodInfo) {
                        if (hasClassInfo) {
                            info.append(".");
                        }
                        info.append(this.myMethodName);
                    }
                    if (packageName != null) {
                        info.append(" (").append(packageName).append(")");
                    }
                    String string = DebuggerBundle.message((String)"line.breakpoint.display.name.with.class.or.method", (Object[])new Object[]{lineNumber, info.toString()});
                    return string;
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)info);
                }
            }
            return DebuggerBundle.message((String)"line.breakpoint.display.name", (Object[])new Object[]{lineNumber});
        }
        return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
    }

    @Nullable
    private static String findMethodName(final PsiFile file, final int offset) {
        if (file instanceof JspFile) {
            return null;
        }
        if (file instanceof PsiJavaFile) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    PsiMethod method = DebuggerUtilsEx.findPsiMethod(file, offset);
                    return method != null ? method.getName() + "()" : null;
                }
            });
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        try {
            return DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{location.declaringType().name() + "." + location.method().name(), location.sourceName(), this.getLineIndex() + 1});
        }
        catch (AbsentInformationException e) {
            String sourceName = this.getSourcePosition().getFile().getName();
            return DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{location.declaringType().name() + "." + location.method().name(), sourceName, this.getLineIndex() + 1});
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        return PositionUtil.getContextElement(this.getSourcePosition());
    }

    protected static LineBreakpoint create(Project project, Document document, int lineIndex) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return null;
        }
        LineBreakpoint breakpoint = new LineBreakpoint(project, LineBreakpoint.createHighlighter(project, document, lineIndex));
        return (LineBreakpoint)breakpoint.init();
    }

    @Override
    public boolean canMoveTo(SourcePosition position) {
        if (!super.canMoveTo(position)) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(position.getFile());
        return LineBreakpoint.canAddLineBreakpoint(this.myProject, document, position.getLine());
    }

    public static boolean canAddLineBreakpoint(Project project, final Document document, final int lineIndex) {
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
        LineBreakpoint breakpointAtLine = breakpointManager.findBreakpoint(document, document.getLineStartOffset(lineIndex), CATEGORY);
        if (breakpointAtLine != null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        final boolean[] canAdd = new boolean[]{false};
        XDebuggerUtil.getInstance().iterateLine(project, document, lineIndex, (Processor)new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                PsiStatement[] statements;
                PsiCodeBlock body;
                int offset;
                if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                PsiElement child = element;
                while (element != null && ((offset = element.getTextOffset()) < 0 || document.getLineNumber(offset) == lineIndex)) {
                    child = element;
                    element = element.getParent();
                }
                canAdd[0] = child instanceof PsiMethod && child.getTextRange().getEndOffset() >= document.getLineEndOffset(lineIndex) ? ((body = ((PsiMethod)child).getBody()) == null ? false : (statements = body.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == lineIndex) : true;
                return false;
            }
        });
        return canAdd[0];
    }

    @Nullable
    public String getMethodName() {
        return this.myMethodName;
    }
}

