/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.events;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.Stack;

public abstract class SuspendContextCommandImpl
extends DebuggerCommandImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendContextCommand");
    private final SuspendContextImpl mySuspendContext;

    protected SuspendContextCommandImpl(SuspendContextImpl suspendContext) {
        this.mySuspendContext = suspendContext;
    }

    public abstract void contextAction() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void action() throws Exception {
        SuspendContextImpl suspendContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying " + this);
        }
        if ((suspendContext = this.getSuspendContext()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip processing - context is null " + this);
            }
            this.notifyCancelled();
            return;
        }
        if (suspendContext.myInProgress) {
            suspendContext.postponeCommand(this);
        } else {
            try {
                if (!suspendContext.isResumed()) {
                    suspendContext.myInProgress = true;
                    this.contextAction();
                } else {
                    this.notifyCancelled();
                }
            }
            finally {
                suspendContext.myInProgress = false;
                SuspendContextCommandImpl postponed = suspendContext.pollPostponedCommand();
                if (postponed != null) {
                    Stack stack = new Stack();
                    while (postponed != null) {
                        stack.push((Object)postponed);
                        postponed = suspendContext.pollPostponedCommand();
                    }
                    DebuggerManagerThreadImpl managerThread = suspendContext.getDebugProcess().getManagerThread();
                    while (!stack.isEmpty()) {
                        managerThread.pushBack((DebuggerCommandImpl)stack.pop());
                    }
                }
            }
        }
    }

    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }
}

