/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl.ui;

import com.intellij.CommonBundle;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class ConvertProjectDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.conversion.impl.ui.ConvertProjectDialog");
    private JPanel myMainPanel;
    private JTextPane myTextPane;
    private boolean myConverted;
    private final ConversionContextImpl myContext;
    private final List<ConversionRunner> myConversionRunners;
    private File myBackupDir;
    private Set<File> myAffectedFiles;
    private boolean myNonExistingFilesMessageShown;

    public ConvertProjectDialog(ConversionContextImpl context, final List<ConversionRunner> conversionRunners) {
        super(true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message((String)"dialog.title.convert.project", (Object[])objectArray));
        this.setModal(true);
        this.myContext = context;
        this.myConversionRunners = conversionRunners;
        this.myAffectedFiles = new HashSet();
        for (ConversionRunner conversionRunner : conversionRunners) {
            this.myAffectedFiles.addAll(conversionRunner.getAffectedFiles());
        }
        this.myBackupDir = ProjectConversionUtil.getBackupDir(context.getProjectBaseDir());
        this.myTextPane.setFont(UIUtil.getLabelFont());
        this.myTextPane.setContentType("text/html");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        editorKit.getStyleSheet().addRule(UIUtil.displayPropertiesToCSS((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground()));
        this.myTextPane.setEditorKit(editorKit);
        this.myTextPane.setEditable(false);
        this.myTextPane.setBackground(UIUtil.getLabelBackground());
        this.myTextPane.setForeground(UIUtil.getLabelForeground());
        this.myTextPane.setText(IdeBundle.message((String)"label.text.project.has.older.format", (Object[])new Object[]{context.getProjectFile().getName(), this.myBackupDir.getAbsolutePath()}));
        this.myTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    StringBuilder descriptions = new StringBuilder("<html>The following conversions will be performed:<br>");
                    for (ConversionRunner runner : conversionRunners) {
                        descriptions.append(runner.getProvider().getConversionDescription()).append("<br>");
                    }
                    descriptions.append("</html>");
                    Messages.showInfoMessage((String)descriptions.toString(), (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]));
                }
            }
        });
        this.init();
        this.setOKButtonText("Convert");
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        List<File> nonexistentFiles = this.myContext.getNonExistingModuleFiles();
        if (!nonexistentFiles.isEmpty() && !this.myNonExistingFilesMessageShown) {
            String filesString = ConvertProjectDialog.getFilesString(nonexistentFiles);
            int res = Messages.showYesNoDialog((Component)this.getContentPane(), (String)IdeBundle.message((String)"message.files.doesn.t.exists.0.so.the.corresponding.modules.won.t.be.converted.do.you.want.to.continue", (Object[])new Object[]{filesString}), (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (res != 0) {
                super.doOKAction();
                return;
            }
            this.myNonExistingFilesMessageShown = false;
        }
        try {
            if (!this.checkReadOnlyFiles()) {
                return;
            }
            ProjectConversionUtil.backupFiles(this.myAffectedFiles, this.myContext.getProjectBaseDir(), this.myBackupDir);
            for (ConversionRunner runner : this.myConversionRunners) {
                if (!runner.isConversionNeeded()) continue;
                runner.preProcess();
                runner.process();
                runner.postProcess();
            }
            this.myContext.saveFiles(this.myAffectedFiles);
            this.myConverted = true;
            super.doOKAction();
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            this.showErrorMessage(IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.showErrorMessage(IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static String getFilesString(List<File> files) {
        StringBuilder buffer = new StringBuilder();
        for (File file : files) {
            buffer.append(file.getAbsolutePath()).append("<br>");
        }
        return buffer.toString();
    }

    private boolean checkReadOnlyFiles() throws IOException {
        List<File> files = this.getReadOnlyFiles();
        if (!files.isEmpty()) {
            String message = IdeBundle.message((String)"message.text.unlock.read.only.files", (Object[])new Object[]{ConvertProjectDialog.getFilesString(files)});
            String[] options = new String[]{CommonBundle.getContinueButtonText(), CommonBundle.getCancelButtonText()};
            if (Messages.showDialog((Component)this.myMainPanel, (String)message, (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]), (String[])options, (int)0, null) != 0) {
                return false;
            }
            ConvertProjectDialog.unlockFiles(files);
            files = this.getReadOnlyFiles();
            if (!files.isEmpty()) {
                this.showErrorMessage(IdeBundle.message((String)"error.message.cannot.make.files.writable", (Object[])new Object[]{ConvertProjectDialog.getFilesString(files)}));
                return false;
            }
        }
        return true;
    }

    private List<File> getReadOnlyFiles() {
        return ConversionRunner.getReadOnlyFiles(this.myAffectedFiles);
    }

    private static void unlockFiles(List<File> files) throws IOException {
        for (File file : files) {
            FileUtil.setReadOnlyAttribute((String)file.getAbsolutePath(), (boolean)false);
        }
    }

    private void showErrorMessage(String message) {
        Messages.showErrorDialog((Component)this.myMainPanel, (String)message, (String)IdeBundle.message((String)"dialog.title.convert.project", (Object[])new Object[0]));
    }

    public boolean isConverted() {
        return this.myConverted;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTextPane = jTextPane = new JTextPane();
        jPanel.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(350, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

