/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.compiler.ant.CompilerExcludes;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Copy;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Javac;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.PatternSetRef;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;

public class CompileModuleChunkTarget
extends CompositeGenerator {
    public CompileModuleChunkTarget(Project project, ModuleChunk moduleChunk, VirtualFile[] sourceRoots, VirtualFile[] testSourceRoots, File baseDir, GenerationOptions genOptions) {
        Tag srcTag;
        String moduleChunkName = moduleChunk.getName();
        Tag compilerArgs = new Tag("compilerarg", new Pair[]{Pair.create((Object)"line", (Object)BuildProperties.propertyRef((String)BuildProperties.getModuleChunkCompilerArgsProperty((String)moduleChunkName)))});
        Pair classpathRef = Pair.create((Object)"refid", (Object)BuildProperties.getClasspathProperty((String)moduleChunkName));
        Tag classpathTag = new Tag("classpath", new Pair[]{classpathRef});
        Tag bootclasspathTag = new Tag("bootclasspath", new Pair[]{Pair.create((Object)"refid", (Object)BuildProperties.getBootClasspathProperty((String)moduleChunkName))});
        PatternSetRef compilerExcludes = new PatternSetRef(BuildProperties.getExcludedFromCompilationProperty((String)moduleChunkName));
        String mainTargetName = BuildProperties.getCompileTargetName((String)moduleChunkName);
        String productionTargetName = mainTargetName + ".production";
        String testsTargetName = mainTargetName + ".tests";
        int modulesCount = moduleChunk.getModules().length;
        Target mainTarget = new Target(mainTargetName, productionTargetName + "," + testsTargetName, CompilerBundle.message((String)"generated.ant.build.compile.modules.main.target.comment", (Object[])new Object[]{modulesCount, moduleChunkName}), null);
        Target productionTarget = new Target(productionTargetName, CompileModuleChunkTarget.getChunkDependenciesString(moduleChunk), CompilerBundle.message((String)"generated.ant.build.compile.modules.production.classes.target.comment", (Object[])new Object[]{modulesCount, moduleChunkName}), null);
        Target testsTarget = new Target(testsTargetName, productionTargetName, CompilerBundle.message((String)"generated.ant.build.compile.modules.tests.target.comment", (Object[])new Object[]{modulesCount, moduleChunkName}), "skip.tests");
        ChunkCustomCompilerExtension[] customCompilers = moduleChunk.getCustomCompilers();
        if (sourceRoots.length > 0) {
            String outputPathRef = BuildProperties.propertyRef((String)BuildProperties.getOutputPathProperty((String)moduleChunkName));
            srcTag = new Tag("src", new Pair[]{Pair.create((Object)"refid", (Object)BuildProperties.getSourcepathProperty((String)moduleChunkName))});
            productionTarget.add((Generator)new Mkdir(outputPathRef));
            CompileModuleChunkTarget.createCustomCompilerTasks(project, moduleChunk, genOptions, false, customCompilers, compilerArgs, bootclasspathTag, classpathTag, compilerExcludes, srcTag, outputPathRef, productionTarget);
            if (customCompilers.length == 0 || genOptions.enableFormCompiler) {
                Javac javac = new Javac(genOptions, moduleChunk, outputPathRef);
                javac.add((Generator)compilerArgs);
                javac.add((Generator)bootclasspathTag);
                javac.add((Generator)classpathTag);
                javac.add((Generator)srcTag);
                javac.add((Generator)compilerExcludes);
                productionTarget.add((Generator)javac);
            }
            productionTarget.add(CompileModuleChunkTarget.createCopyTask(project, moduleChunk, sourceRoots, outputPathRef, baseDir, genOptions));
        }
        if (testSourceRoots.length > 0) {
            String testOutputPathRef = BuildProperties.propertyRef((String)BuildProperties.getOutputPathForTestsProperty((String)moduleChunkName));
            srcTag = new Tag("src", new Pair[]{Pair.create((Object)"refid", (Object)BuildProperties.getTestSourcepathProperty((String)moduleChunkName))});
            Pair testClasspathRef = Pair.create((Object)"refid", (Object)BuildProperties.getTestClasspathProperty((String)moduleChunkName));
            Tag testClassPath = new Tag("classpath", new Pair[]{testClasspathRef});
            testsTarget.add((Generator)new Mkdir(testOutputPathRef));
            CompileModuleChunkTarget.createCustomCompilerTasks(project, moduleChunk, genOptions, true, customCompilers, compilerArgs, bootclasspathTag, testClassPath, compilerExcludes, srcTag, testOutputPathRef, testsTarget);
            if (customCompilers.length == 0 || genOptions.enableFormCompiler) {
                Javac javac = new Javac(genOptions, moduleChunk, testOutputPathRef);
                javac.add((Generator)compilerArgs);
                javac.add((Generator)bootclasspathTag);
                javac.add((Generator)testClassPath);
                javac.add((Generator)srcTag);
                javac.add((Generator)compilerExcludes);
                testsTarget.add((Generator)javac);
            }
            testsTarget.add(CompileModuleChunkTarget.createCopyTask(project, moduleChunk, testSourceRoots, testOutputPathRef, baseDir, genOptions));
        }
        this.add((Generator)mainTarget);
        this.add((Generator)productionTarget, 1);
        this.add((Generator)testsTarget, 1);
    }

    private static void createCustomCompilerTasks(Project project, ModuleChunk moduleChunk, GenerationOptions genOptions, boolean compileTests, ChunkCustomCompilerExtension[] customCompilers, Tag compilerArgs, Tag bootclasspathTag, Tag classpathTag, PatternSetRef compilerExcludes, Tag srcTag, String outputPathRef, Target target) {
        if (customCompilers.length > 1) {
            target.add((Generator)new Tag("fail", new Pair[]{Pair.create((Object)"message", (Object)CompilerBundle.message((String)"generated.ant.build.compile.modules.fail.custom.compilers", (Object[])new Object[0]))}));
        }
        for (ChunkCustomCompilerExtension ext : customCompilers) {
            ext.generateCustomCompile(project, moduleChunk, genOptions, compileTests, (CompositeGenerator)target, compilerArgs, bootclasspathTag, classpathTag, compilerExcludes, srcTag, outputPathRef);
        }
    }

    private static String getChunkDependenciesString(ModuleChunk moduleChunk) {
        StringBuffer moduleDependencies = new StringBuffer();
        ModuleChunk[] dependencies = moduleChunk.getDependentChunks();
        for (int idx = 0; idx < dependencies.length; ++idx) {
            ModuleChunk dependency = dependencies[idx];
            if (idx > 0) {
                moduleDependencies.append(",");
            }
            moduleDependencies.append(BuildProperties.getCompileTargetName((String)dependency.getName()));
        }
        return moduleDependencies.toString();
    }

    private static Generator createCopyTask(Project project, ModuleChunk chunk, VirtualFile[] sourceRoots, String toDir, File baseDir, GenerationOptions genOptions) {
        Tag filesSelector = new Tag("type", new Pair[]{Pair.create((Object)"type", (Object)"file")});
        PatternSetRef excludes = CompilerExcludes.isAvailable(project) ? new PatternSetRef(BuildProperties.getExcludedFromCompilationProperty((String)chunk.getName())) : null;
        PatternSetRef resourcePatternsPatternSet = new PatternSetRef("compiler.resources");
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        CompositeGenerator composite = new CompositeGenerator();
        HashMap<String, Copy> outputDirToTaskMap = new HashMap<String, Copy>();
        for (VirtualFile root : sourceRoots) {
            String packagePrefix = fileIndex.getPackageNameByDirectory(root);
            String targetDir = packagePrefix != null && packagePrefix.length() > 0 ? toDir + "/" + packagePrefix.replace('.', '/') : toDir;
            Copy copy = (Copy)outputDirToTaskMap.get(targetDir);
            if (copy == null) {
                copy = new Copy(targetDir);
                outputDirToTaskMap.put(targetDir, copy);
                composite.add((Generator)copy);
            }
            FileSet fileSet = new FileSet(GenerationUtils.toRelativePath((VirtualFile)root, (File)baseDir, (String)BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)chunk), (GenerationOptions)genOptions));
            fileSet.add((Generator)resourcePatternsPatternSet);
            fileSet.add((Generator)filesSelector);
            if (excludes != null) {
                fileSet.add((Generator)excludes);
            }
            copy.add((Generator)fileSet);
        }
        return composite;
    }
}

