/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsImpl
implements Tools {
    private static final Logger LOG = Logger.getInstance((String)("#" + ToolsImpl.class.getName()));
    public static final String ENABLED_TAG = "enabled_by_default";
    private final String myShortName;
    private final ScopeToolState myDefaultState;
    private List<ScopeToolState> myTools;
    private boolean myEnabled;

    public ToolsImpl(@NotNull InspectionProfileEntry tool, HighlightDisplayLevel level, boolean enabled) {
        if (tool == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/ToolsImpl.<init> must not be null");
        }
        this.myShortName = tool.getShortName();
        this.myEnabled = enabled;
        this.myDefaultState = new ScopeToolState(DefaultScopesProvider.getAllScope(), tool, enabled, level);
    }

    public ScopeToolState addTool(NamedScope scope, @NotNull InspectionProfileEntry tool, boolean enabled, HighlightDisplayLevel level) {
        if (tool == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/ToolsImpl.addTool must not be null");
        }
        return this.insertTool(scope, tool, enabled, level, this.myTools != null ? this.myTools.size() : 0);
    }

    public ScopeToolState prependTool(NamedScope scope, @NotNull InspectionProfileEntry tool, boolean enabled, HighlightDisplayLevel level) {
        if (tool == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ex/ToolsImpl.prependTool must not be null");
        }
        return this.insertTool(scope, tool, enabled, level, 0);
    }

    private ScopeToolState insertTool(NamedScope scope, InspectionProfileEntry tool, boolean enabled, HighlightDisplayLevel level, int idx) {
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            this.setEnabled(true);
        }
        ScopeToolState scopeToolState = new ScopeToolState(scope, tool, enabled, level);
        this.myTools.add(idx, scopeToolState);
        return scopeToolState;
    }

    public InspectionProfileEntry getInspectionTool(PsiElement element) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                if (element == null) {
                    return state.getTool();
                }
                DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)element.getProject());
                NamedScope scope = state.getScope();
                if (scope == null || (packageSet = scope.getValue()) == null || !packageSet.contains(element.getContainingFile(), (NamedScopesHolder)validationManager)) continue;
                return state.getTool();
            }
            for (ScopeToolState state : this.getTools()) {
                if (state.getScope() != null) continue;
                return state.getTool();
            }
        }
        return this.myDefaultState.getTool();
    }

    public String getShortName() {
        return this.myShortName;
    }

    public List<InspectionProfileEntry> getAllTools() {
        ArrayList<InspectionProfileEntry> result = new ArrayList<InspectionProfileEntry>();
        for (ScopeToolState state : this.getTools()) {
            result.add(state.getTool());
        }
        return result;
    }

    public void writeExternal(Element inspectionElement) throws WriteExternalException {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                Element scopeElement = new Element("scope");
                scopeElement.setAttribute("name", state.getScopeName());
                scopeElement.setAttribute("level", state.getLevel().toString());
                scopeElement.setAttribute("enabled", Boolean.toString(state.isEnabled()));
                InspectionProfileEntry InspectionProfileEntry2 = state.getTool();
                InspectionProfileEntry2.writeSettings(scopeElement);
                inspectionElement.addContent(scopeElement);
            }
        }
        inspectionElement.setAttribute("enabled", Boolean.toString(this.isEnabled()));
        inspectionElement.setAttribute("level", this.getLevel().toString());
        inspectionElement.setAttribute(ENABLED_TAG, Boolean.toString(this.myDefaultState.isEnabled()));
        this.myDefaultState.getTool().writeSettings(inspectionElement);
    }

    public void readExternal(Element toolElement, InspectionProfile profile) throws InvalidDataException {
        boolean isEnabled;
        String levelName = toolElement.getAttributeValue("level");
        ProfileManager profileManager = profile.getProfileManager();
        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)((SeverityProvider)profileManager).getOwnSeverityRegistrar().getSeverity(levelName));
        if (level == null || level == HighlightDisplayLevel.DO_NOT_SHOW) {
            level = HighlightDisplayLevel.WARNING;
        }
        this.myDefaultState.setLevel(level);
        String enabled = toolElement.getAttributeValue("enabled");
        this.myEnabled = isEnabled = enabled != null && Boolean.parseBoolean(enabled);
        String enabledTool = toolElement.getAttributeValue(ENABLED_TAG);
        this.myDefaultState.setEnabled(enabledTool != null ? Boolean.parseBoolean(enabledTool) : isEnabled);
        InspectionProfileEntry tool = this.myDefaultState.getTool();
        tool.readSettings(toolElement);
        List children = toolElement.getChildren("scope");
        if (!children.isEmpty()) {
            for (Object sO : children) {
                HighlightDisplayLevel scopeLevel;
                Element scopeElement = (Element)sO;
                String scopeName = scopeElement.getAttributeValue("name");
                if (scopeName == null) continue;
                NamedScopesHolder scopesHolder = profileManager.getScopesManager();
                NamedScope namedScope = null;
                if (scopesHolder != null) {
                    namedScope = scopesHolder.getScope(scopeName);
                }
                String errorLevel = scopeElement.getAttributeValue("level");
                String enabledInScope = scopeElement.getAttributeValue("enabled");
                InspectionTool copyTool = ((InspectionProfileImpl)profile).myRegistrar.createInspectionTool(this.myShortName, tool);
                copyTool.readSettings(scopeElement);
                HighlightDisplayLevel highlightDisplayLevel = scopeLevel = errorLevel != null ? HighlightDisplayLevel.find((HighlightSeverity)((SeverityProvider)profileManager).getOwnSeverityRegistrar().getSeverity(errorLevel)) : null;
                if (scopeLevel == null) {
                    scopeLevel = level;
                }
                if (namedScope != null) {
                    this.addTool(namedScope, (InspectionProfileEntry)copyTool, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
                    continue;
                }
                this.addTool(scopeName, (InspectionProfileEntry)copyTool, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
            }
        }
    }

    public ScopeToolState addTool(String scopeName, InspectionProfileEntry tool, boolean enabled, HighlightDisplayLevel level) {
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            this.setEnabled(true);
        }
        ScopeToolState scopeToolState = new ScopeToolState(scopeName, tool, enabled, level);
        this.myTools.add(scopeToolState);
        return scopeToolState;
    }

    public InspectionProfileEntry getTool() {
        if (this.myTools == null) {
            return this.myDefaultState.getTool();
        }
        return this.myTools.iterator().next().getTool();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<ScopeToolState> getTools() {
        List<ScopeToolState> list;
        if (this.myTools == null) {
            list = Collections.singletonList(this.myDefaultState);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/ToolsImpl.getTools must not return null");
            return list;
        }
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>(this.myTools);
        result.add(this.myDefaultState);
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/ToolsImpl.getTools must not return null");
    }

    @NotNull
    public ScopeToolState getDefaultState() {
        ScopeToolState scopeToolState = this.myDefaultState;
        if (scopeToolState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/ToolsImpl.getDefaultState must not return null");
        }
        return scopeToolState;
    }

    public List<NamedScope> getScopes() {
        ArrayList<NamedScope> result = new ArrayList<NamedScope>();
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                result.add(state.getScope());
            }
        } else {
            result.add(null);
        }
        return result;
    }

    public void removeScope(int scopeIdx) {
        if (this.myTools != null && scopeIdx >= 0 && this.myTools.size() > scopeIdx) {
            this.myTools.remove(scopeIdx);
            if (this.myTools.isEmpty()) {
                this.myTools = null;
                this.setEnabled(this.myDefaultState.isEnabled());
            }
        }
    }

    public void removeAllScopes() {
        this.myTools = null;
    }

    public void setScope(int idx, NamedScope namedScope) {
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            InspectionProfileEntry tool = scopeToolState.getTool();
            this.myTools.remove(idx);
            this.myTools.add(idx, new ScopeToolState(namedScope, tool, scopeToolState.isEnabled(), scopeToolState.getLevel()));
        }
    }

    public void moveScope(int idx, int dir) {
        if (this.myTools != null && idx >= 0 && idx < this.myTools.size() && idx + dir >= 0 && idx + dir < this.myTools.size()) {
            ScopeToolState state = this.myTools.get(idx);
            this.myTools.set(idx, this.myTools.get(idx + dir));
            this.myTools.set(idx + dir, state);
        }
    }

    public boolean isEnabled(NamedScope namedScope) {
        if (!this.myEnabled) {
            return false;
        }
        if (namedScope != null && this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)namedScope, (Object)state.getScope())) continue;
                return state.isEnabled();
            }
        }
        return this.myDefaultState.isEnabled();
    }

    public HighlightDisplayLevel getLevel(PsiElement element) {
        if (this.myTools == null || element == null) {
            return this.myDefaultState.getLevel();
        }
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)element.getProject());
        for (ScopeToolState state : this.myTools) {
            NamedScope scope = state.getScope();
            PackageSet set = scope != null ? scope.getValue() : null;
            if (set == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.getLevel();
        }
        return this.myDefaultState.getLevel();
    }

    public HighlightDisplayLevel getLevel() {
        return this.myDefaultState.getLevel();
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isEnabled(PsiElement element) {
        if (!this.myEnabled) {
            return false;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled();
        }
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)element.getProject());
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope();
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.isEnabled();
        }
        return this.myDefaultState.isEnabled();
    }

    @Nullable
    public InspectionTool getEnabledTool(PsiElement element) {
        if (!this.myEnabled) {
            return null;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled() ? (InspectionTool)this.myDefaultState.getTool() : null;
        }
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)element.getProject());
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope();
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.isEnabled() ? (InspectionTool)state.getTool() : null;
        }
        return this.myDefaultState.isEnabled() ? (InspectionTool)this.myDefaultState.getTool() : null;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void enableTool(NamedScope namedScope) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(), (Object)namedScope)) continue;
                state.setEnabled(true);
            }
        }
        this.setEnabled(true);
    }

    public void disableTool(NamedScope namedScope) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(), (Object)namedScope)) continue;
                state.setEnabled(false);
            }
        }
    }

    public void disableTool(PsiElement element) {
        if (element == null) {
            this.myDefaultState.setEnabled(false);
            this.setEnabled(false);
            return;
        }
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)element.getProject());
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                NamedScope scope = state.getScope();
                if (scope == null || (packageSet = scope.getValue()) == null || !packageSet.contains(element.getContainingFile(), (NamedScopesHolder)validationManager)) continue;
                state.setEnabled(false);
                return;
            }
            this.myDefaultState.setEnabled(false);
        } else {
            this.myDefaultState.setEnabled(false);
            this.setEnabled(false);
        }
    }

    public HighlightDisplayLevel getLevel(NamedScope scope) {
        if (this.myTools != null && scope != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(), (Object)scope)) continue;
                return state.getLevel();
            }
        }
        return this.myDefaultState.getLevel();
    }

    public boolean equalTo(ToolsImpl tools) {
        if (this.myEnabled != tools.myEnabled) {
            return false;
        }
        if (this.getTools().size() != tools.getTools().size()) {
            return false;
        }
        for (int i = 0; i < this.getTools().size(); ++i) {
            ScopeToolState toolState;
            ScopeToolState state = this.getTools().get(i);
            if (state.equalTo(toolState = tools.getTools().get(i))) continue;
            return false;
        }
        return true;
    }

    public void setLevel(HighlightDisplayLevel level, int idx) {
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            this.myTools.remove(idx);
            NamedScope scope = scopeToolState.getScope();
            if (scope != null) {
                this.myTools.add(idx, new ScopeToolState(scope, scopeToolState.getTool(), scopeToolState.isEnabled(), level));
            } else {
                this.myTools.add(idx, new ScopeToolState(scopeToolState.getScopeName(), scopeToolState.getTool(), scopeToolState.isEnabled(), level));
            }
        } else if (idx == -1) {
            this.myDefaultState.setLevel(level);
        }
    }

    public void setDefaultState(InspectionProfileEntry inspectionTool, boolean enabled, HighlightDisplayLevel level) {
        this.myDefaultState.setTool(inspectionTool);
        this.myDefaultState.setLevel(level);
        this.myDefaultState.setEnabled(enabled);
    }

    public void setLevel(HighlightDisplayLevel level) {
        this.myDefaultState.setLevel(level);
    }

    @Nullable
    public List<ScopeToolState> getNonDefaultTools() {
        return this.myTools;
    }
}

