/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DelegatingInstructionVisitor;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowRunner");
    private static final long ourTimeLimit = 10000L;
    private Instruction[] myInstructions;
    private DfaVariableValue[] myFields;
    private final DfaValueFactory myValueFactory = new DfaValueFactory();
    public static final int MAX_STATES_PER_BRANCH = 300;

    public Instruction getInstruction(int index) {
        return this.myInstructions[index];
    }

    protected DataFlowRunner() {
    }

    public DfaValueFactory getFactory() {
        return this.myValueFactory;
    }

    @Nullable
    protected Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, InstructionVisitor visitor) {
        PsiClass containingClass;
        if (psiBlock == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowRunner.createInitialStates must not be null");
        }
        if (psiBlock.getParent() instanceof PsiMethod && (containingClass = ((PsiMethod)psiBlock.getParent()).getContainingClass()) instanceof PsiAnonymousClass) {
            PsiElement newExpression = containingClass.getParent();
            PsiCodeBlock block = DfaUtil.getTopmostBlockInSameClass(newExpression);
            if (newExpression instanceof PsiNewExpression && block != null) {
                Collection<DfaMemoryState> closureStates;
                EnvironmentalInstructionVisitor envVisitor = new EnvironmentalInstructionVisitor(visitor, (PsiNewExpression)newExpression);
                RunnerResult result = this.analyzeMethod((PsiElement)block, envVisitor);
                if (result == RunnerResult.OK && !(closureStates = envVisitor.getClosureStates()).isEmpty()) {
                    return closureStates;
                }
                return null;
            }
        }
        return Arrays.asList(this.createMemoryState());
    }

    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, InstructionVisitor visitor) {
        if (psiBlock == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowRunner.analyzeMethod must not be null");
        }
        try {
            Collection<DfaMemoryState> initialStates = this.createInitialStates(psiBlock, visitor);
            if (initialStates == null) {
                return RunnerResult.NOT_APPLICABLE;
            }
            ControlFlow flow = this.createControlFlowAnalyzer().buildControlFlow(psiBlock);
            if (flow == null) {
                return RunnerResult.NOT_APPLICABLE;
            }
            int endOffset = flow.getInstructionCount();
            this.myInstructions = flow.getInstructions();
            this.myFields = flow.getFields();
            if (LOG.isDebugEnabled()) {
                for (int i = 0; i < this.myInstructions.length; ++i) {
                    Instruction instruction = this.myInstructions[i];
                    LOG.debug(i + ": " + instruction.toString());
                }
            }
            int branchCount = 0;
            for (Instruction instruction : this.myInstructions) {
                if (!(instruction instanceof BranchingInstruction)) continue;
                ++branchCount;
            }
            if (branchCount > 80) {
                return RunnerResult.TOO_COMPLEX;
            }
            ArrayList<DfaInstructionState> queue = new ArrayList<DfaInstructionState>();
            for (DfaMemoryState initialState : initialStates) {
                queue.add(new DfaInstructionState(this.myInstructions[0], initialState));
            }
            long timeLimit = 10000L;
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            long before = System.currentTimeMillis();
            int count = 0;
            while (!queue.isEmpty()) {
                if (count % 50 == 0 && !unitTestMode && System.currentTimeMillis() - before > timeLimit) {
                    return RunnerResult.TOO_COMPLEX;
                }
                ProgressManager.checkCanceled();
                DfaInstructionState instructionState = (DfaInstructionState)queue.remove(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(instructionState.toString());
                }
                Instruction instruction = instructionState.getInstruction();
                long distance = instructionState.getDistanceFromStart();
                if (instruction instanceof BranchingInstruction && !instruction.setMemoryStateProcessed(instructionState.getMemoryState().createCopy())) {
                    return RunnerResult.TOO_COMPLEX;
                }
                DfaInstructionState[] after = instruction.accept(this, instructionState.getMemoryState(), visitor);
                if (after != null) {
                    for (DfaInstructionState state : after) {
                        Instruction nextInstruction = state.getInstruction();
                        if (nextInstruction instanceof BranchingInstruction && nextInstruction.isMemoryStateProcessed(state.getMemoryState()) || instruction.getIndex() >= endOffset) continue;
                        state.setDistanceFromStart(distance + 1L);
                        queue.add(state);
                    }
                }
                ++count;
            }
            return RunnerResult.OK;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error(psiBlock.getText(), (Throwable)e);
            return RunnerResult.ABORTED;
        }
        catch (EmptyStackException e) {
            return RunnerResult.ABORTED;
        }
    }

    protected ControlFlowAnalyzer createControlFlowAnalyzer() {
        return new ControlFlowAnalyzer(this.myValueFactory);
    }

    protected DfaMemoryState createMemoryState() {
        return new DfaMemoryStateImpl(this.myValueFactory);
    }

    public Instruction[] getInstructions() {
        return this.myInstructions;
    }

    public DfaVariableValue[] getFields() {
        return this.myFields;
    }

    public Pair<Set<Instruction>, Set<Instruction>> getConstConditionalExpressions() {
        BranchingInstruction branchingInstruction;
        HashSet<BranchingInstruction> trueSet = new HashSet<BranchingInstruction>();
        HashSet<BranchingInstruction> falseSet = new HashSet<BranchingInstruction>();
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction) || (branchingInstruction = (BranchingInstruction)instruction).getPsiAnchor() == null || !branchingInstruction.isConditionConst()) continue;
            if (!branchingInstruction.isTrueReachable()) {
                falseSet.add(branchingInstruction);
            }
            if (branchingInstruction.isFalseReachable()) continue;
            trueSet.add(branchingInstruction);
        }
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction)) continue;
            branchingInstruction = (BranchingInstruction)instruction;
            if (branchingInstruction.isTrueReachable()) {
                falseSet.remove(branchingInstruction);
            }
            if (!branchingInstruction.isFalseReachable()) continue;
            trueSet.remove(branchingInstruction);
        }
        return Pair.create(trueSet, falseSet);
    }

    private static class EnvironmentalInstructionVisitor
    extends DelegatingInstructionVisitor {
        private final PsiNewExpression myNewExpression;
        private final Set<DfaMemoryState> myClosureStates;

        public EnvironmentalInstructionVisitor(@NotNull InstructionVisitor delegate, @NotNull PsiNewExpression newExpression) {
            if (delegate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowRunner$EnvironmentalInstructionVisitor.<init> must not be null");
            }
            if (newExpression == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowRunner$EnvironmentalInstructionVisitor.<init> must not be null");
            }
            super(delegate);
            this.myClosureStates = new THashSet();
            this.myNewExpression = newExpression;
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myNewExpression == instruction.getCallExpression()) {
                this.myClosureStates.add(memState.createCopy());
            }
            return super.visitMethodCall(instruction, runner, memState);
        }

        @NotNull
        public Collection<DfaMemoryState> getClosureStates() {
            Set<DfaMemoryState> set = this.myClosureStates;
            if (set == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowRunner$EnvironmentalInstructionVisitor.getClosureStates must not return null");
            }
            return set;
        }
    }
}

