/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JCiPUtil {
    @NonNls
    private static final String IMMUTABLE = "net.jcip.annotations.Immutable";
    @NonNls
    private static final String GUARDED_BY = "net.jcip.annotations.GuardedBy";
    @NonNls
    private static final String THREAD_SAFE = "net.jcip.annotations.ThreadSafe";

    public static boolean isJCiPAnnotation(String ref) {
        return "Immutable".equals(ref) || "GuardedBy".equals(ref) || "ThreadSafe".equals("ref");
    }

    private JCiPUtil() {
    }

    public static boolean isImmutable(PsiClass aClass) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{IMMUTABLE});
        if (annotation != null) {
            return true;
        }
        ImmutableTagVisitor visitor = new ImmutableTagVisitor();
        aClass.accept((PsiElementVisitor)visitor);
        return visitor.isFound();
    }

    @Nullable
    public static String findGuardForMember(PsiMember member) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{GUARDED_BY});
        if (annotation != null) {
            return JCiPUtil.getGuardValue(annotation);
        }
        GuardedTagVisitor visitor = new GuardedTagVisitor();
        member.accept((PsiElementVisitor)visitor);
        return visitor.getGuardString();
    }

    public static boolean isGuardedBy(PsiMember member, String guard) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{GUARDED_BY});
        if (annotation != null) {
            PsiAnnotationParameterList parameters = annotation.getParameterList();
            PsiNameValuePair[] pairs = parameters.getAttributes();
            String fieldName = '\"' + guard + '\"';
            for (PsiNameValuePair pair : pairs) {
                PsiAnnotationMemberValue value;
                String name = pair.getName();
                if (!"value".equals(name) && name != null || (value = pair.getValue()) == null || !value.getText().equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isGuardedBy(PsiMember member, PsiField field) {
        return JCiPUtil.isGuardedBy(member, field.getName());
    }

    public static boolean isGuardedByAnnotation(PsiAnnotation annotation) {
        return GUARDED_BY.equals(annotation.getQualifiedName());
    }

    public static boolean isGuardedByTag(PsiDocTag tag) {
        String text = tag.getText();
        return text.startsWith("@GuardedBy") && text.contains("(") && text.contains(")");
    }

    @Nullable
    public static String getGuardValue(PsiAnnotation annotation) {
        PsiNameValuePair[] pairs;
        PsiAnnotationParameterList parameters = annotation.getParameterList();
        for (PsiNameValuePair pair : pairs = parameters.getAttributes()) {
            PsiAnnotationMemberValue psiAnnotationMemberValue;
            String name = pair.getName();
            if (!"value".equals(name) && name != null || (psiAnnotationMemberValue = pair.getValue()) == null) continue;
            String value = psiAnnotationMemberValue.getText();
            return value.substring(1, value.length() - 1).trim();
        }
        return null;
    }

    @NotNull
    public static String getGuardValue(PsiDocTag tag) {
        String text = tag.getText();
        String string = text.substring(text.indexOf(40) + 1, text.indexOf(41)).trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil.getGuardValue must not return null");
        }
        return string;
    }

    private static class ImmutableTagVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean found = false;

        private ImmutableTagVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            super.visitDocTag(tag);
            String text = tag.getText();
            if (text.startsWith("@Immutable")) {
                this.found = true;
            }
        }

        public boolean isFound() {
            return this.found;
        }
    }

    private static class GuardedTagVisitor
    extends JavaRecursiveElementVisitor {
        private String guardString = null;

        private GuardedTagVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            super.visitDocTag(tag);
            String text = tag.getText();
            if (text.startsWith("@GuardedBy") && text.contains("(") && text.contains(")")) {
                this.guardString = text.substring(text.indexOf(40) + 1, text.indexOf(41));
            }
        }

        @Nullable
        public String getGuardString() {
            return this.guardString;
        }
    }
}

