/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import java.util.List;

public class JavaAnonymousUnwrapper
extends JavaUnwrapper {
    public JavaAnonymousUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.anonymous", (Object[])new Object[0]));
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        return e instanceof PsiAnonymousClass && ((PsiAnonymousClass)e).getMethods().length <= 1;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return this.findElementToExtractFrom(e);
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiElement from = this.findElementToExtractFrom(element);
        for (PsiMethod m : ((PsiAnonymousClass)element).getMethods()) {
            context.extractFromCodeBlock(m.getBody(), from);
        }
        PsiElement next = from.getNextSibling();
        if (next instanceof PsiJavaToken && ((PsiJavaToken)next).getTokenType() == JavaTokenType.SEMICOLON) {
            context.deleteExactly(from.getNextSibling());
        }
        context.deleteExactly(from);
    }

    private PsiElement findElementToExtractFrom(PsiElement el) {
        if (el.getParent() instanceof PsiNewExpression) {
            el = el.getParent();
        }
        el = this.findTopmostParentOfType(el, PsiMethodCallExpression.class);
        el = this.findTopmostParentOfType(el, PsiAssignmentExpression.class);
        el = this.findTopmostParentOfType(el, PsiDeclarationStatement.class);
        while (el.getParent() instanceof PsiExpressionStatement) {
            el = el.getParent();
        }
        return el;
    }
}

