/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class HintManagerImpl
extends HintManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.HintManager");
    private final AnActionListener myAnActionListener;
    private final MyEditorManagerListener myEditorManagerListener;
    private final EditorMouseAdapter myEditorMouseListener;
    private final FocusListener myEditorFocusListener;
    private final DocumentListener myEditorDocumentListener;
    private final VisibleAreaListener myVisibleAreaListener;
    private final CaretListener myCaretMoveListener;
    private LightweightHint myQuestionHint = null;
    private QuestionAction myQuestionAction = null;
    private final List<HintInfo> myHintsStack = new ArrayList<HintInfo>();
    private Editor myLastEditor = null;
    private final Alarm myHideAlarm = new Alarm();

    private static int getPriority(QuestionAction action) {
        return action instanceof PriorityQuestionAction ? ((PriorityQuestionAction)action).getPriority() : 0;
    }

    public boolean canShowQuestionAction(QuestionAction action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myQuestionAction == null || HintManagerImpl.getPriority(this.myQuestionAction) <= HintManagerImpl.getPriority(action);
    }

    public static HintManagerImpl getInstanceImpl() {
        return (HintManagerImpl)((Object)ServiceManager.getService(HintManager.class));
    }

    public HintManagerImpl(ActionManagerEx actionManagerEx, ProjectManager projectManager) {
        this.myEditorManagerListener = new MyEditorManagerListener();
        this.myAnActionListener = new MyAnActionListener();
        actionManagerEx.addAnActionListener(this.myAnActionListener);
        this.myCaretMoveListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                HintManagerImpl.this.hideHints(2, false, false);
            }
        };
        projectManager.addProjectManagerListener((ProjectManagerListener)new MyProjectManagerListener());
        this.myEditorMouseListener = new EditorMouseAdapter(){

            public void mousePressed(EditorMouseEvent event) {
                HintManagerImpl.this.hideAllHints();
            }
        };
        this.myVisibleAreaListener = new VisibleAreaListener(){

            public void visibleAreaChanged(VisibleAreaEvent e) {
                HintManagerImpl.this.updateScrollableHints(e);
                HintManagerImpl.this.hideHints(32, false, false);
            }
        };
        this.myEditorFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(final FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!JBPopupFactory.getInstance().isChildPopupFocused(e.getComponent())) {
                            HintManagerImpl.this.hideAllHints();
                        }
                    }
                }, 200);
            }

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        };
        this.myEditorDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                HintInfo[] infos;
                LOG.assertTrue(SwingUtilities.isEventDispatchThread());
                for (HintInfo info : infos = HintManagerImpl.this.myHintsStack.toArray(new HintInfo[HintManagerImpl.this.myHintsStack.size()])) {
                    if ((info.flags & 8) == 0) continue;
                    if (info.hint.isVisible()) {
                        info.hint.hide();
                    }
                    HintManagerImpl.this.myHintsStack.remove(info);
                }
                if (HintManagerImpl.this.myHintsStack.isEmpty()) {
                    HintManagerImpl.this.updateLastEditor(null);
                }
            }
        };
    }

    private void updateScrollableHints(VisibleAreaEvent e) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo info : this.myHintsStack) {
            if (!(info.hint instanceof LightweightHint) || (info.flags & 0x80) == 0) continue;
            HintManagerImpl.updateScrollableHintPosition(e, info.hint, (info.flags & 0x40) != 0);
        }
    }

    public boolean hasShownHintsThatWillHideByOtherHint() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo hintInfo : this.myHintsStack) {
            if (!hintInfo.hint.isVisible() || (hintInfo.flags & 0x10) == 0) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        ActionManagerEx.getInstanceEx().removeAnActionListener(this.myAnActionListener);
    }

    private static void updateScrollableHintPosition(VisibleAreaEvent e, LightweightHint hint, boolean hideIfOutOfEditor) {
        boolean valid;
        Editor editor;
        if (hint.getComponent() instanceof ScrollAwareHint) {
            ((ScrollAwareHint)((Object)hint.getComponent())).editorScrolled();
        }
        if (!(editor = e.getEditor()).getComponent().isShowing() || editor.isOneLineMode()) {
            return;
        }
        Rectangle newRectangle = e.getOldRectangle();
        Rectangle oldRectangle = e.getNewRectangle();
        Rectangle bounds = hint.getBounds();
        Point location = bounds.getLocation();
        location = SwingUtilities.convertPoint(editor.getComponent().getRootPane().getLayeredPane(), location, editor.getContentComponent());
        int xOffset = location.x - oldRectangle.x;
        int yOffset = location.y - oldRectangle.y;
        location = new Point(newRectangle.x + xOffset, newRectangle.y + yOffset);
        Rectangle newBounds = new Rectangle(location.x, location.y, bounds.width, bounds.height);
        boolean bl = valid = hideIfOutOfEditor ? oldRectangle.contains(newBounds) : oldRectangle.intersects(newBounds);
        if (valid) {
            location = SwingUtilities.convertPoint(editor.getContentComponent(), location, editor.getComponent().getRootPane().getLayeredPane());
            hint.setLocation(location.x, location.y);
        } else {
            hint.hide();
        }
    }

    public void showEditorHint(LightweightHint hint, Editor editor, short constraint, int flags, int timeout, boolean reviveOnEditorChange) {
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point p = HintManagerImpl.getHintPosition(hint, editor, pos, constraint);
        this.showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange);
    }

    public void showEditorHint(final @NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, int flags, int timeout, boolean reviveOnEditorChange) {
        if (hint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showEditorHint must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showEditorHint must not be null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showEditorHint must not be null");
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        if (editor != this.myLastEditor) {
            this.hideAllHints();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
            return;
        }
        this.updateLastEditor(editor);
        HintManagerImpl.getPublisher().hintShown(editor.getProject(), hint, flags);
        JComponent component = hint.getComponent();
        HintManagerImpl.doShowInGivenLocation(hint, editor, p);
        ListenerUtil.addMouseListener(component, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        HintInfo info = new HintInfo(hint, flags, reviveOnEditorChange);
        this.myHintsStack.add(info);
        if (timeout > 0) {
            Timer timer = new Timer(timeout, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    hint.hide();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    public void showHint(@NotNull JComponent component, @NotNull RelativePoint p, int flags, int timeout) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showHint must not be null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showHint must not be null");
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        final JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(component, null).setRequestFocus(false).setResizable(false).setMovable(false).createPopup();
        popup.show(p);
        ListenerUtil.addMouseListener(component, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        HintInfo info = new HintInfo(new LightweightHint(component){

            @Override
            public void hide() {
                popup.cancel();
            }
        }, flags, false);
        this.myHintsStack.add(info);
        if (timeout > 0) {
            Timer timer = new Timer(timeout, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    popup.dispose();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    private static void doShowInGivenLocation(LightweightHint hint, Editor editor, Point p) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JLayeredPane layeredPane = editor.getComponent().getRootPane().getLayeredPane();
        Dimension size = hint.getComponent().getPreferredSize();
        if (layeredPane.getWidth() < p.x + size.width) {
            p.x = Math.max(0, layeredPane.getWidth() - size.width);
        }
        if (hint.isVisible()) {
            hint.setLocation(p.x, p.y);
        } else {
            hint.show(layeredPane, p.x, p.y, editor.getContentComponent());
        }
    }

    public static void adjustEditorHintPosition(LightweightHint hint, Editor editor, Point p) {
        HintManagerImpl.doShowInGivenLocation(hint, editor, p);
    }

    public void hideAllHints() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        ArrayList<HintInfo> hints = new ArrayList<HintInfo>(this.myHintsStack);
        for (HintInfo info : hints) {
            info.hint.hide();
        }
        this.myHintsStack.clear();
        this.updateLastEditor(null);
    }

    public Point getHintPosition(LightweightHint hint, Editor editor, short constraint) {
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        DataContext dataContext = ((EditorEx)editor).getDataContext();
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext);
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        if (dominantArea == null) {
            for (HintInfo info : this.myHintsStack) {
                Rectangle rectangle;
                if (!info.hint.isSelectingHint() || (rectangle = info.hint.getBounds()) == null) continue;
                return HintManagerImpl.getHintPositionRelativeTo(hint, editor, constraint, rectangle, pos);
            }
        } else {
            return HintManagerImpl.getHintPositionRelativeTo(hint, editor, constraint, dominantArea, pos);
        }
        return HintManagerImpl.getHintPosition(hint, editor, pos, constraint);
    }

    private static Point getHintPositionRelativeTo(LightweightHint hint, Editor editor, short constraint, Rectangle lookupBounds, LogicalPosition pos) {
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        int layeredPaneHeight = layeredPane.getHeight();
        switch (constraint) {
            case 3: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x - hintSize.width, y);
            }
            case 4: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x + lookupBounds.width, y);
            }
            case 1: {
                Point posAboveCaret = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
                return new Point(lookupBounds.x, Math.min(posAboveCaret.y, lookupBounds.y - hintSize.height));
            }
            case 2: {
                Point posUnderCaret = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
                return new Point(lookupBounds.x, Math.max(posUnderCaret.y, lookupBounds.y + lookupBounds.height));
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    public static Point getHintPosition(LightweightHint hint, Editor editor, LogicalPosition pos, short constraint) {
        return HintManagerImpl.getHintPosition(hint, editor, pos, pos, constraint);
    }

    private static Point getHintPosition(LightweightHint hint, Editor editor, LogicalPosition pos1, LogicalPosition pos2, short constraint) {
        Point p = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, constraint);
        JLayeredPane layeredPane = editor.getComponent().getRootPane().getLayeredPane();
        Dimension hintSize = hint.getComponent().getPreferredSize();
        if (constraint == 1) {
            if (p.y < 0) {
                Point p1 = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, (short)2);
                if (p1.y + hintSize.height <= layeredPane.getSize().height) {
                    return p1;
                }
            }
        } else if (constraint == 2 && p.y + hintSize.height > layeredPane.getSize().height) {
            Point p1 = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, (short)1);
            if (p1.y >= 0) {
                return p1;
            }
        }
        return p;
    }

    private static Point _getHintPosition(LightweightHint hint, Editor editor, LogicalPosition pos1, LogicalPosition pos2, short constraint) {
        Point location;
        Point p;
        Dimension hintSize = hint.getComponent().getPreferredSize();
        int line1 = pos1.line;
        int col1 = pos1.column;
        int line2 = pos2.line;
        int col2 = pos2.column;
        JLayeredPane layeredPane = editor.getComponent().getRootPane().getLayeredPane();
        JComponent internalComponent = editor.getContentComponent();
        if (constraint == 5) {
            p = editor.logicalPositionToXY(new LogicalPosition(line2, col2));
            p.y += editor.getLineHeight();
            location = SwingUtilities.convertPoint(internalComponent, p, layeredPane);
        } else {
            p = editor.logicalPositionToXY(new LogicalPosition(line1, col1));
            if (constraint == 2) {
                p.y += editor.getLineHeight();
            }
            location = SwingUtilities.convertPoint(internalComponent, p, layeredPane);
        }
        if (constraint == 1) {
            location.y -= hintSize.height;
            int diff = location.x + hintSize.width - layeredPane.getWidth();
            if (diff > 0) {
                location.x = Math.max(location.x - diff, 0);
            }
        }
        if (constraint == 3 || constraint == 4) {
            location.y -= hintSize.height / 2;
            if (constraint == 3) {
                location.x -= hintSize.width;
            }
        }
        return location;
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String text) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showErrorHint must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showErrorHint must not be null");
        }
        JLabel label = HintUtil.createErrorLabel(text);
        LightweightHint hint = new LightweightHint(label);
        Point p = this.getHintPosition(hint, editor, (short)1);
        this.showEditorHint(hint, editor, p, 42, 0, false);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull String text) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showInformationHint must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showInformationHint must not be null");
        }
        JLabel label = HintUtil.createInformationLabel(text);
        this.showInformationHint(editor, label);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showInformationHint must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showInformationHint must not be null");
        }
        LightweightHint hint = new LightweightHint(component);
        Point p = this.getHintPosition(hint, editor, (short)1);
        this.showEditorHint(hint, editor, p, 42, 0, false);
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String hintText, int offset1, int offset2, short constraint, int flags, int timeout) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showErrorHint must not be null");
        }
        if (hintText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showErrorHint must not be null");
        }
        JLabel label = HintUtil.createErrorLabel(hintText);
        LightweightHint hint = new LightweightHint(label);
        LogicalPosition pos1 = editor.offsetToLogicalPosition(offset1);
        LogicalPosition pos2 = editor.offsetToLogicalPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint);
        this.showEditorHint(hint, editor, p, flags, timeout, false);
    }

    public void showQuestionHint(@NotNull Editor editor, @NotNull String hintText, int offset1, int offset2, @NotNull QuestionAction action) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        if (hintText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        JLabel label = HintUtil.createQuestionLabel(hintText);
        LightweightHint hint = new LightweightHint(label);
        this.showQuestionHint(editor, offset1, offset2, hint, action, (short)1);
    }

    public void showQuestionHint(@NotNull Editor editor, int offset1, int offset2, @NotNull LightweightHint hint, @NotNull QuestionAction action, short constraint) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        if (hint == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        LogicalPosition pos1 = editor.offsetToLogicalPosition(offset1);
        LogicalPosition pos2 = editor.offsetToLogicalPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint);
        this.showQuestionHint(editor, p, offset1, offset2, hint, action);
    }

    public void showQuestionHint(final @NotNull Editor editor, @NotNull Point p, int offset1, int offset2, final @NotNull LightweightHint hint, @NotNull QuestionAction action) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        if (hint == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/codeInsight/hint/HintManagerImpl.showQuestionHint must not be null");
        }
        TextAttributes attributes = new TextAttributes();
        attributes.setEffectColor(HintUtil.QUESTION_UNDERSCORE_COLOR);
        attributes.setEffectType(EffectType.LINE_UNDERSCORE);
        final RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5001, attributes, HighlighterTargetArea.EXACT_RANGE);
        if (this.myQuestionHint != null) {
            this.myQuestionHint.hide();
            this.myQuestionHint = null;
            this.myQuestionAction = null;
        }
        hint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                if (!editor.isDisposed()) {
                    editor.getMarkupModel().removeHighlighter(highlighter);
                }
                if (HintManagerImpl.this.myQuestionHint == hint) {
                    HintManagerImpl.this.myQuestionAction = null;
                    HintManagerImpl.this.myQuestionHint = null;
                }
                hint.removeHintListener(this);
            }
        });
        this.showEditorHint(hint, editor, p, 202, 0, false);
        this.myQuestionAction = action;
        this.myQuestionHint = hint;
    }

    private void updateLastEditor(Editor editor) {
        if (this.myLastEditor != editor) {
            if (this.myLastEditor != null) {
                this.myLastEditor.removeEditorMouseListener((EditorMouseListener)this.myEditorMouseListener);
                this.myLastEditor.getContentComponent().removeFocusListener(this.myEditorFocusListener);
                this.myLastEditor.getDocument().removeDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().removeCaretListener(this.myCaretMoveListener);
            }
            this.myLastEditor = editor;
            if (this.myLastEditor != null) {
                this.myLastEditor.addEditorMouseListener((EditorMouseListener)this.myEditorMouseListener);
                this.myLastEditor.getContentComponent().addFocusListener(this.myEditorFocusListener);
                this.myLastEditor.getDocument().addDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().addCaretListener(this.myCaretMoveListener);
            }
        }
    }

    public boolean performCurrentQuestionAction() {
        if (this.myQuestionAction != null && this.myQuestionHint != null) {
            if (this.myQuestionHint.isVisible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("performing an action:" + this.myQuestionAction);
                }
                if (this.myQuestionAction.execute()) {
                    if (this.myQuestionHint != null) {
                        this.myQuestionHint.hide();
                    }
                    return true;
                }
                return true;
            }
            this.myQuestionAction = null;
            this.myQuestionHint = null;
        }
        return false;
    }

    boolean isEscapeHandlerEnabled() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (int i = this.myHintsStack.size() - 1; i >= 0; --i) {
            HintInfo info = this.myHintsStack.get(i);
            if (!info.hint.isVisible()) {
                this.myHintsStack.remove(i);
                continue;
            }
            if ((info.flags & 3) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hideHints(int mask, boolean onlyOne, boolean editorChanged) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        try {
            boolean done = false;
            for (int i = this.myHintsStack.size() - 1; i >= 0; --i) {
                HintInfo info = this.myHintsStack.get(i);
                if (!info.hint.isVisible()) {
                    this.myHintsStack.remove(i);
                    continue;
                }
                if ((info.flags & mask) == 0 && (!editorChanged || info.reviveOnEditorChange)) continue;
                info.hint.hide();
                this.myHintsStack.remove(info);
                if (onlyOne) {
                    boolean bl = true;
                    return bl;
                }
                done = true;
            }
            boolean bl = done;
            return bl;
        }
        finally {
            if (this.myHintsStack.isEmpty()) {
                this.updateLastEditor(null);
            }
        }
    }

    private static EditorHintListener getPublisher() {
        return EditorHintListenerHolder.ourEditorHintPublisher;
    }

    private static class EditorHintListenerHolder {
        private static final EditorHintListener ourEditorHintPublisher = (EditorHintListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorHintListener.TOPIC);

        private EditorHintListenerHolder() {
        }
    }

    private final class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectOpened(Project project) {
            FileEditorManager.getInstance((Project)project).addFileEditorManagerListener((FileEditorManagerListener)HintManagerImpl.this.myEditorManagerListener, (Disposable)project);
        }

        public void projectClosed(Project project) {
            TooltipController.getInstance().cancelTooltips();
            HintManagerImpl.this.myQuestionAction = null;
            HintManagerImpl.this.myQuestionHint = null;
        }
    }

    private final class MyEditorManagerListener
    extends FileEditorManagerAdapter {
        private MyEditorManagerListener() {
        }

        public void selectionChanged(FileEditorManagerEvent event) {
            HintManagerImpl.this.hideHints(0, false, true);
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        @Override
        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (action instanceof ActionToIgnore) {
                return;
            }
            AnAction escapeAction = ActionManagerEx.getInstanceEx().getAction("EditorEscape");
            if (action == escapeAction) {
                return;
            }
            HintManagerImpl.this.hideHints(2, false, false);
        }

        @Override
        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        @Override
        public void beforeEditorTyping(char c, DataContext dataContext) {
        }
    }

    private static class HintInfo {
        final LightweightHint hint;
        final int flags;
        private final boolean reviveOnEditorChange;

        private HintInfo(LightweightHint hint, int flags, boolean reviveOnEditorChange) {
            this.hint = hint;
            this.flags = flags;
            this.reviveOnEditorChange = reviveOnEditorChange;
        }
    }

    public static interface ActionToIgnore {
    }
}

