/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;

public class EnterInStringLiteralHandler
implements EnterHandlerDelegate {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, Ref<Integer> caretOffsetRef, Ref<Integer> caretAdvanceRef, DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset = (Integer)caretOffsetRef.get();
        int caretAdvance = (Integer)caretAdvanceRef.get();
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            JavaLikeQuoteHandler quoteHandler;
            Document document = editor.getDocument();
            String text = document.getText();
            ASTNode token = psiAtOffset.getNode();
            QuoteHandler fileTypeQuoteHandler = TypedHandler.getQuoteHandler(psiAtOffset.getContainingFile());
            JavaLikeQuoteHandler javaLikeQuoteHandler = quoteHandler = fileTypeQuoteHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeQuoteHandler : null;
            if (quoteHandler != null && quoteHandler.getConcatenatableStringTokenTypes() != null && quoteHandler.getConcatenatableStringTokenTypes().contains(token.getElementType())) {
                TextRange range = token.getTextRange();
                char literalStart = token.getText().charAt(0);
                StringLiteralLexer lexer = new StringLiteralLexer(literalStart, token.getElementType());
                lexer.start((CharSequence)text, range.getStartOffset(), range.getEndOffset());
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenStart() < caretOffset && caretOffset < lexer.getTokenEnd()) {
                        if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) break;
                        caretOffset = lexer.getTokenEnd();
                        break;
                    }
                    lexer.advance();
                }
                if (quoteHandler.needParenthesesAroundConcatenation(psiAtOffset)) {
                    document.insertString(psiAtOffset.getTextRange().getEndOffset(), (CharSequence)")");
                    document.insertString(psiAtOffset.getTextRange().getStartOffset(), (CharSequence)"(");
                    ++caretOffset;
                    ++caretAdvance;
                }
                String insertedFragment = literalStart + " " + quoteHandler.getStringConcatenationOperatorRepresentation();
                document.insertString(caretOffset, (CharSequence)(insertedFragment + " " + literalStart));
                caretOffset += insertedFragment.length();
                caretAdvance = 1;
                if (CodeStyleSettingsManager.getSettings((Project)file.getProject()).BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                    --caretOffset;
                    caretAdvance = 3;
                }
                caretOffsetRef.set((Object)caretOffset);
                caretAdvanceRef.set((Object)caretAdvance);
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

