/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class RestoreReferencesDialog
extends DialogWrapper {
    private final Object[] myNamedElements;
    private JList myList;
    private Object[] mySelectedElements = PsiClass.EMPTY_ARRAY;
    private boolean myContainsClassesOnly = true;

    public RestoreReferencesDialog(Project project, Object[] elements) {
        super(project, true);
        this.myNamedElements = elements;
        for (Object element : elements) {
            if (element instanceof PsiClass) continue;
            this.myContainsClassesOnly = false;
            break;
        }
        if (this.myContainsClassesOnly) {
            this.setTitle(CodeInsightBundle.message((String)"dialog.import.on.paste.title", (Object[])new Object[0]));
        } else {
            this.setTitle(CodeInsightBundle.message((String)"dialog.import.on.paste.title2", (Object[])new Object[0]));
        }
        this.init();
        this.myList.setSelectionInterval(0, this.myNamedElements.length - 1);
    }

    protected void doOKAction() {
        Object[] values = this.myList.getSelectedValues();
        this.mySelectedElements = new Object[values.length];
        System.arraycopy(values, 0, this.mySelectedElements, 0, values.length);
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myList = new JList<Object>(this.myNamedElements);
        this.myList.setCellRenderer(new FQNameCellRenderer());
        this.myList.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)new JScrollPane(this.myList), "Center");
        JTextArea area = new JTextArea(this.myContainsClassesOnly ? CodeInsightBundle.message((String)"dialog.paste.on.import.text", (Object[])new Object[0]) : CodeInsightBundle.message((String)"dialog.paste.on.import.text2", (Object[])new Object[0]));
        area.setEditable(false);
        area.setBackground(this.getContentPane().getBackground());
        area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)area, "North");
        JPanel buttonPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JButton okButton = new JButton(CommonBundle.getOkButtonText());
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(CommonBundle.getCancelButtonText());
        buttonPanel.add(cancelButton);
        panel.setPreferredSize(new Dimension(500, 400));
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.editorActions.RestoreReferencesDialog";
    }

    public Object[] getSelectedElements() {
        return this.mySelectedElements;
    }
}

