/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtendsListFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix");
    final PsiClass myClass;
    final PsiClass myClassToExtendFrom;
    private final boolean myToAdd;
    private final PsiClassType myTypeToExtendFrom;

    public ExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.<init> must not be null");
        }
        if (typeToExtendFrom == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.<init> must not be null");
        }
        this.myClass = aClass;
        this.myClassToExtendFrom = typeToExtendFrom.resolve();
        this.myTypeToExtendFrom = typeToExtendFrom;
        this.myToAdd = toAdd;
    }

    public ExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClass classToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.<init> must not be null");
        }
        if (classToExtendFrom == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.<init> must not be null");
        }
        this.myClass = aClass;
        this.myClassToExtendFrom = classToExtendFrom;
        this.myTypeToExtendFrom = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(classToExtendFrom);
        this.myToAdd = toAdd;
    }

    @NotNull
    public String getText() {
        String messageKey = this.myClass.isInterface() == this.myClassToExtendFrom.isInterface() ? (this.myToAdd ? "add.class.to.extends.list" : "remove.class.from.extends.list") : (this.myToAdd ? "add.interface.to.implements.list" : "remove.interface.from.implements.list");
        String string = QuickFixBundle.message(messageKey, this.myClass.getName(), this.myClassToExtendFrom.getQualifiedName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.extends.list.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.applyFix must not be null");
        }
        this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.isAvailable must not be null");
        }
        return this.myClass != null && this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)this.myClass) && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid() && !this.myClassToExtendFrom.hasModifierProperty("final") && (this.myClassToExtendFrom.isInterface() || !this.myClass.isInterface() && this.myClass.getExtendsList() != null && this.myClass.getExtendsList().getReferencedTypes().length == 0 == this.myToAdd);
    }

    protected void invokeImpl() {
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        PsiReferenceList extendsList = !(this.myClass instanceof PsiTypeParameter) && this.myClass.isInterface() != this.myClassToExtendFrom.isInterface() ? this.myClass.getImplementsList() : this.myClass.getExtendsList();
        PsiReferenceList otherList = extendsList == this.myClass.getImplementsList() ? this.myClass.getExtendsList() : this.myClass.getImplementsList();
        try {
            if (extendsList != null) {
                this.modifyList(extendsList, this.myToAdd, -1);
            }
            if (otherList != null) {
                this.modifyList(otherList, false, -1);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.invoke must not be null");
        }
        this.invokeImpl();
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    PsiReferenceList modifyList(@NotNull PsiReferenceList extendsList, boolean add, int position) throws IncorrectOperationException {
        if (extendsList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListFix.modifyList must not be null");
        }
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        boolean alreadyExtends = false;
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            if (!referenceElement.getManager().areElementsEquivalent((PsiElement)this.myClassToExtendFrom, referenceElement.resolve())) continue;
            alreadyExtends = true;
            if (add) continue;
            referenceElement.delete();
        }
        PsiReferenceList list = extendsList;
        if (add && !alreadyExtends) {
            PsiJavaCodeReferenceElement anchor = position == -1 ? (referenceElements.length == 0 ? null : referenceElements[referenceElements.length - 1]) : (position == 0 ? null : referenceElements[position - 1]);
            PsiJavaCodeReferenceElement classReferenceElement = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory().createReferenceElementByType(this.myTypeToExtendFrom);
            PsiElement element = anchor == null ? (referenceElements.length == 0 ? extendsList.add((PsiElement)classReferenceElement) : extendsList.addBefore((PsiElement)classReferenceElement, (PsiElement)referenceElements[0])) : extendsList.addAfter((PsiElement)classReferenceElement, (PsiElement)anchor);
            list = (PsiReferenceList)element.getParent();
        }
        return list;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

