/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalVarFromInstanceofAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateCastExpressionFromInstanceofAction
extends CreateLocalVarFromInstanceofAction {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction.isAvailable must not be null");
        }
        boolean available = super.isAvailable(project, editor, file);
        if (!available) {
            return false;
        }
        PsiInstanceOfExpression instanceOfExpression = CreateCastExpressionFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file);
        if (instanceOfExpression == null) {
            return false;
        }
        PsiTypeElement checkType = instanceOfExpression.getCheckType();
        if (checkType == null) {
            return false;
        }
        PsiType type = checkType.getType();
        String castTo = type.getPresentableText();
        this.setText(CodeInsightBundle.message((String)"cast.to.0", (Object[])new Object[]{castTo}));
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiInstanceOfExpression instanceOfExpression = CreateCastExpressionFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file);
        assert (instanceOfExpression.getContainingFile() == file) : instanceOfExpression.getContainingFile() + "; file=" + file;
        PsiElement decl = CreateCastExpressionFromInstanceofAction.createAndInsertCast(instanceOfExpression);
        if (decl == null) {
            return;
        }
        decl = CodeStyleManager.getInstance((Project)project).reformat(decl);
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToOffset(decl.getTextRange().getEndOffset());
    }

    @Nullable
    private static PsiElement createAndInsertCast(PsiInstanceOfExpression instanceOfExpression) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)instanceOfExpression.getProject()).getElementFactory();
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText("((a)b)", (PsiElement)instanceOfExpression);
        PsiParenthesizedExpression paren = (PsiParenthesizedExpression)statement.getExpression();
        PsiTypeCastExpression cast = (PsiTypeCastExpression)paren.getExpression();
        PsiType castType = instanceOfExpression.getCheckType().getType();
        cast.getCastType().replace((PsiElement)factory.createTypeElement(castType));
        cast.getOperand().replace((PsiElement)instanceOfExpression.getOperand());
        PsiElement element = CreateCastExpressionFromInstanceofAction.insertAtAnchor(instanceOfExpression, (PsiElement)statement);
        return CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(element);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"cast.expression", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateCastExpressionFromInstanceofAction.getFamilyName must not return null");
        }
        return string;
    }
}

