/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiMember;
import org.jetbrains.annotations.NotNull;

public class PreferAccessibleWeigher
extends CompletionWeigher {
    public MyEnum weigh(@NotNull LookupElement item, CompletionLocation location) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/PreferAccessibleWeigher.weigh must not be null");
        }
        Object object = item.getObject();
        if (object instanceof PsiDocCommentOwner) {
            PsiDocCommentOwner member = (PsiDocCommentOwner)object;
            if (!member.isValid()) {
                return MyEnum.NORMAL;
            }
            if (!JavaPsiFacade.getInstance((Project)member.getProject()).getResolveHelper().isAccessible((PsiMember)member, location.getCompletionParameters().getPosition(), null)) {
                return MyEnum.INACCESSIBLE;
            }
            if (member.isDeprecated()) {
                return MyEnum.DEPRECATED;
            }
        }
        return MyEnum.NORMAL;
    }

    private static enum MyEnum {
        INACCESSIBLE,
        DEPRECATED,
        NORMAL;

    }
}

