/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CodeStyleSchemesModel {
    private final List<CodeStyleScheme> mySchemes = new ArrayList<CodeStyleScheme>();
    private CodeStyleScheme myGlobalSelected;
    private final CodeStyleSchemeImpl myProjectScheme;
    private final CodeStyleScheme myDefault;
    private final Map<CodeStyleScheme, CodeStyleSettings> mySettingsToClone = new HashMap<CodeStyleScheme, CodeStyleSettings>();
    private final EventDispatcher<CodeStyleSettingsListener> myDispatcher = EventDispatcher.create(CodeStyleSettingsListener.class);
    private final Project myProject;
    private boolean myUsePerProjectSettings;

    public CodeStyleSchemesModel(Project project) {
        this.myProject = project;
        this.myProjectScheme = new CodeStyleSchemeImpl("Project Scheme", false, CodeStyleSchemes.getInstance().getDefaultScheme());
        this.reset();
        this.myDefault = CodeStyleSchemes.getInstance().getDefaultScheme();
    }

    public void selectScheme(CodeStyleScheme selected, Object source) {
        if (this.myGlobalSelected != selected && selected != this.myProjectScheme) {
            this.myGlobalSelected = selected;
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(source);
        }
    }

    public void addScheme(CodeStyleScheme newScheme, boolean changeSelection) {
        this.mySchemes.add(newScheme);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (changeSelection) {
            this.selectScheme(newScheme, this);
        }
    }

    public void removeScheme(CodeStyleScheme scheme) {
        this.mySchemes.remove(scheme);
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (this.myGlobalSelected == scheme) {
            this.selectScheme(this.myDefault, this);
        }
    }

    public CodeStyleSettings getCloneSettings(CodeStyleScheme scheme) {
        if (!this.mySettingsToClone.containsKey(scheme)) {
            this.mySettingsToClone.put(scheme, scheme.getCodeStyleSettings().clone());
        }
        return this.mySettingsToClone.get(scheme);
    }

    public CodeStyleScheme getSelectedScheme() {
        if (this.myUsePerProjectSettings) {
            return this.myProjectScheme;
        }
        return this.myGlobalSelected;
    }

    public void addListener(CodeStyleSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public List<CodeStyleScheme> getSchemes() {
        return Collections.unmodifiableList(this.mySchemes);
    }

    public void reset() {
        this.myUsePerProjectSettings = this.getProjectSettings().USE_PER_PROJECT_SETTINGS;
        CodeStyleScheme[] allSchemes = CodeStyleSchemes.getInstance().getSchemes();
        this.mySettingsToClone.clear();
        this.mySchemes.clear();
        this.mySchemes.addAll(Arrays.asList(allSchemes));
        this.myGlobalSelected = CodeStyleSchemes.getInstance().getCurrentScheme();
        CodeStyleSettings perProjectSettings = this.getProjectSettings().PER_PROJECT_SETTINGS;
        if (perProjectSettings != null) {
            this.myProjectScheme.setCodeStyleSettings(perProjectSettings);
        }
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
    }

    public boolean isUsePerProjectSettings() {
        return this.myUsePerProjectSettings;
    }

    public void setUsePerProjectSettings(boolean usePerProjectSettings) {
        if (this.myUsePerProjectSettings != usePerProjectSettings) {
            this.myUsePerProjectSettings = usePerProjectSettings;
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).usePerProjectSettingsOptionChanged();
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
        }
    }

    private CodeStyleSettingsManager getProjectSettings() {
        return CodeStyleSettingsManager.getInstance((Project)this.myProject);
    }

    public boolean isSchemeListModified() {
        HashSet<CodeStyleScheme> savedSchemesSet;
        if (this.getProjectSettings().USE_PER_PROJECT_SETTINGS != this.myUsePerProjectSettings) {
            return true;
        }
        if (!this.myUsePerProjectSettings && this.getSelectedScheme() != CodeStyleSchemes.getInstance().getCurrentScheme()) {
            return true;
        }
        HashSet<CodeStyleScheme> configuredSchemesSet = new HashSet<CodeStyleScheme>(this.getSchemes());
        return !((Object)configuredSchemesSet).equals(savedSchemesSet = new HashSet<CodeStyleScheme>(Arrays.asList(CodeStyleSchemes.getInstance().getSchemes())));
    }

    public void apply() {
        this.getProjectSettings().USE_PER_PROJECT_SETTINGS = this.myUsePerProjectSettings;
        this.getProjectSettings().PER_PROJECT_SETTINGS = this.myProjectScheme.getCodeStyleSettings();
        CodeStyleScheme[] savedSchemes = CodeStyleSchemes.getInstance().getSchemes();
        HashSet<CodeStyleScheme> savedSchemesSet = new HashSet<CodeStyleScheme>(Arrays.asList(savedSchemes));
        List<CodeStyleScheme> configuredSchemes = this.getSchemes();
        for (CodeStyleScheme savedScheme : savedSchemes) {
            if (configuredSchemes.contains(savedScheme)) continue;
            CodeStyleSchemes.getInstance().deleteScheme(savedScheme);
        }
        for (CodeStyleScheme configuredScheme : configuredSchemes) {
            if (savedSchemesSet.contains(configuredScheme)) continue;
            CodeStyleSchemes.getInstance().addScheme(configuredScheme);
        }
        CodeStyleSchemes.getInstance().setCurrentScheme(this.myGlobalSelected);
    }

    static SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> getSchemesManager() {
        return ((CodeStyleSchemesImpl)CodeStyleSchemes.getInstance()).getSchemesManager();
    }

    public static boolean cannotBeModified(CodeStyleScheme currentScheme) {
        return currentScheme.isDefault() || CodeStyleSchemesModel.getSchemesManager().isShared((Scheme)currentScheme);
    }

    public static boolean cannotBeDeleted(CodeStyleScheme currentScheme) {
        return currentScheme.isDefault();
    }

    public void fireCurrentSettingsChanged() {
        ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).currentSettingsChanged();
    }

    public CodeStyleScheme getSelectedGlobalScheme() {
        return this.myGlobalSelected;
    }

    public void copyToProject(CodeStyleScheme selectedScheme) {
        if (this.mySettingsToClone.containsKey(this.myProjectScheme)) {
            CodeStyleSettings projectSettings = this.mySettingsToClone.get(this.myProjectScheme);
            projectSettings.copyFrom(this.getEditedSchemeSettings(selectedScheme));
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
        } else {
            this.mySettingsToClone.put(this.myProjectScheme, this.getEditedSchemeSettings(selectedScheme).clone());
            ((CodeStyleSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
        }
    }

    private CodeStyleSettings getEditedSchemeSettings(CodeStyleScheme selectedScheme) {
        if (this.mySettingsToClone.containsKey(selectedScheme)) {
            return this.mySettingsToClone.get(selectedScheme);
        }
        return selectedScheme.getCodeStyleSettings();
    }

    public CodeStyleScheme exportProjectScheme(String name) {
        CodeStyleScheme newScheme = this.createNewScheme(name, this.myProjectScheme);
        ((CodeStyleSchemeImpl)newScheme).setCodeStyleSettings(this.getEditedSchemeSettings(this.myProjectScheme));
        this.addScheme(newScheme, false);
        return newScheme;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        String name;
        if (preferredName == null) {
            name = null;
            int i = 1;
            while (name == null) {
                String currName = parentScheme.getName() + " (" + i + ")";
                if (null == this.findSchemeByName(currName)) {
                    name = currName;
                }
                ++i;
            }
        } else {
            name = null;
            int i = 0;
            while (name == null) {
                String currName;
                String string = currName = i == 0 ? preferredName : preferredName + " (" + i + ")";
                if (null == this.findSchemeByName(currName)) {
                    name = currName;
                }
                ++i;
            }
        }
        return new CodeStyleSchemeImpl(name, false, parentScheme);
    }

    private CodeStyleScheme findSchemeByName(String name) {
        for (CodeStyleScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }
}

