/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.find.FindSettings;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseAnalysisActionDialog
extends DialogWrapper {
    private JPanel myPanel;
    private final String myFileName;
    private final String myModuleName;
    private JRadioButton myProjectButton;
    private JRadioButton myModuleButton;
    private JRadioButton myUncommitedFilesButton;
    private JRadioButton myCustomScopeButton;
    private JRadioButton myFileButton;
    private ScopeChooserCombo myScopeCombo;
    private JCheckBox myInspectTestSource;
    private JComboBox myChangeLists;
    private TitledSeparator myTitledSeparator;
    private final Project myProject;
    private final boolean myRememberScope;
    private final String myAnalysisNoon;
    private ButtonGroup myGroup;
    private static final String ALL = AnalysisScopeBundle.message((String)"scope.option.uncommited.files.all.changelists.choice", (Object[])new Object[0]);
    private final AnalysisUIOptions myAnalysisOptions;
    @Nullable
    private final PsiElement myContext;

    public BaseAnalysisActionDialog(@NotNull String title, @NotNull String analysisNoon, @NotNull Project project, @NotNull AnalysisScope scope, String moduleName, boolean rememberScope, @NotNull AnalysisUIOptions analysisUIOptions, @Nullable PsiElement context) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.<init> must not be null");
        }
        if (analysisNoon == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.<init> must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.<init> must not be null");
        }
        if (analysisUIOptions == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.<init> must not be null");
        }
        super(true);
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        this.myAnalysisOptions = analysisUIOptions;
        this.myContext = context;
        if (!analysisUIOptions.ANALYZE_TEST_SOURCES) {
            this.myAnalysisOptions.ANALYZE_TEST_SOURCES = scope.isAnalyzeTestsByDefault();
        }
        this.myProject = project;
        this.myFileName = scope.getShortenName();
        this.myModuleName = moduleName;
        this.myRememberScope = rememberScope;
        this.myAnalysisNoon = analysisNoon;
        this.init();
        this.setTitle(title);
        this.onScopeRadioButtonPressed();
    }

    public void setOKActionEnabled(boolean isEnabled) {
        super.setOKActionEnabled(isEnabled);
    }

    protected JComponent createCenterPanel() {
        String preselect;
        boolean hasVCS;
        this.myTitledSeparator.setText(this.myAnalysisNoon);
        this.myInspectTestSource.setSelected(this.myAnalysisOptions.ANALYZE_TEST_SOURCES);
        this.myModuleButton.setText(AnalysisScopeBundle.message((String)"scope.option.module.with.mnemonic", (Object[])new Object[]{this.myModuleName}));
        boolean useModuleScope = false;
        if (this.myModuleName != null) {
            useModuleScope = this.myAnalysisOptions.SCOPE_TYPE == 4;
            this.myModuleButton.setSelected(this.myRememberScope && useModuleScope);
        }
        this.myModuleButton.setVisible(this.myModuleName != null && ModuleManager.getInstance((Project)this.myProject).getModules().length > 1);
        boolean useUncommitedFiles = false;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        boolean bl = hasVCS = !changeListManager.getAffectedFiles().isEmpty();
        if (hasVCS) {
            useUncommitedFiles = this.myAnalysisOptions.SCOPE_TYPE == AnalysisScope.UNCOMMITED_FILES;
            this.myUncommitedFilesButton.setSelected(this.myRememberScope && useUncommitedFiles);
        }
        this.myUncommitedFilesButton.setVisible(hasVCS);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(ALL);
        List changeLists = changeListManager.getChangeListsCopy();
        for (ChangeList changeList : changeLists) {
            model.addElement(changeList.getName());
        }
        this.myChangeLists.setModel(model);
        this.myChangeLists.setEnabled(this.myUncommitedFilesButton.isSelected());
        this.myChangeLists.setVisible(hasVCS);
        this.myFileButton.setText(this.myFileName);
        this.myFileButton.setMnemonic(this.myFileName.charAt(0));
        VirtualFile file = PsiUtilBase.getVirtualFile((PsiElement)this.myContext);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        boolean searchInLib = file != null && (fileIndex.isInLibraryClasses(file) || fileIndex.isInLibrarySource(file));
        String string = preselect = StringUtil.isEmptyOrSpaces((String)this.myAnalysisOptions.CUSTOM_SCOPE_NAME) ? FindSettings.getInstance().getDefaultScopeName() : this.myAnalysisOptions.CUSTOM_SCOPE_NAME;
        if (searchInLib && GlobalSearchScope.projectScope((Project)this.myProject).getDisplayName().equals(preselect)) {
            preselect = GlobalSearchScope.allScope((Project)this.myProject).getDisplayName();
        }
        if (GlobalSearchScope.allScope((Project)this.myProject).getDisplayName().equals(preselect)) {
            this.myAnalysisOptions.SCOPE_TYPE = 8;
            this.myAnalysisOptions.CUSTOM_SCOPE_NAME = preselect;
            searchInLib = true;
        }
        this.myCustomScopeButton.setSelected(this.myRememberScope && this.myAnalysisOptions.SCOPE_TYPE == 8);
        this.myScopeCombo.init(this.myProject, searchInLib, true, preselect);
        this.myProjectButton.setSelected(this.myRememberScope && this.myAnalysisOptions.SCOPE_TYPE == 1);
        this.myFileButton.setSelected(!this.myRememberScope || this.myAnalysisOptions.SCOPE_TYPE != 1 && !useModuleScope && this.myAnalysisOptions.SCOPE_TYPE != 8 && !useUncommitedFiles);
        this.myScopeCombo.setEnabled(this.myCustomScopeButton.isSelected());
        ActionListener radioButtonPressed = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseAnalysisActionDialog.this.onScopeRadioButtonPressed();
            }
        };
        Enumeration<AbstractButton> enumeration = this.myGroup.getElements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().addActionListener(radioButtonPressed);
        }
        JPanel wholePanel = new JPanel(new BorderLayout());
        wholePanel.add((Component)this.myPanel, "North");
        JComponent additionalPanel = this.getAdditionalActionSettings(this.myProject);
        if (additionalPanel != null) {
            wholePanel.add((Component)additionalPanel, "Center");
        }
        new RadioUpDownListener(this.myProjectButton, this.myModuleButton, this.myUncommitedFilesButton, this.myFileButton, this.myCustomScopeButton);
        return wholePanel;
    }

    private void onScopeRadioButtonPressed() {
        this.myScopeCombo.setEnabled(this.myCustomScopeButton.isSelected());
        this.myChangeLists.setEnabled(this.myUncommitedFilesButton.isSelected());
    }

    public JComponent getPreferredFocusedComponent() {
        Enumeration<AbstractButton> enumeration = this.myGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (!button.isSelected()) continue;
            return button;
        }
        return this.myPanel;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project) {
        return null;
    }

    public boolean isProjectScopeSelected() {
        return this.myProjectButton.isSelected();
    }

    public boolean isModuleScopeSelected() {
        return this.myModuleButton != null && this.myModuleButton.isSelected();
    }

    public boolean isUncommitedFilesSelected() {
        return this.myUncommitedFilesButton != null && this.myUncommitedFilesButton.isSelected();
    }

    @Nullable
    public SearchScope getCustomScope() {
        if (this.myCustomScopeButton.isSelected()) {
            return this.myScopeCombo.getSelectedScope();
        }
        return null;
    }

    public boolean isInspectTestSources() {
        return this.myInspectTestSource.isSelected();
    }

    @NotNull
    public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project, Module module) {
        AnalysisScope scope;
        if (uiOptions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.getScope must not be null");
        }
        if (defaultScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.getScope must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/analysis/BaseAnalysisActionDialog.getScope must not be null");
        }
        if (this.isProjectScopeSelected()) {
            scope = new AnalysisScope(project);
            uiOptions.SCOPE_TYPE = 1;
        } else {
            SearchScope customScope = this.getCustomScope();
            if (customScope != null) {
                scope = new AnalysisScope(customScope, project);
                uiOptions.SCOPE_TYPE = 8;
                uiOptions.CUSTOM_SCOPE_NAME = customScope.getDisplayName();
            } else if (this.isModuleScopeSelected()) {
                scope = new AnalysisScope(module);
                uiOptions.SCOPE_TYPE = 4;
            } else if (this.isUncommitedFilesSelected()) {
                ArrayList<VirtualFile> files;
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                if (this.myChangeLists.getSelectedItem() == ALL) {
                    files = changeListManager.getAffectedFiles();
                } else {
                    files = new ArrayList<VirtualFile>();
                    for (LocalChangeList list : changeListManager.getChangeListsCopy()) {
                        if (!Comparing.strEqual((String)list.getName(), (String)((String)this.myChangeLists.getSelectedItem()))) continue;
                        Collection changes = list.getChanges();
                        for (Change change : changes) {
                            VirtualFile vFile;
                            ContentRevision afterRevision = change.getAfterRevision();
                            if (afterRevision == null || (vFile = afterRevision.getFile().getVirtualFile()) == null) continue;
                            files.add(vFile);
                        }
                    }
                }
                scope = new AnalysisScope(project, new HashSet(files));
                uiOptions.SCOPE_TYPE = AnalysisScope.UNCOMMITED_FILES;
            } else {
                scope = defaultScope;
                uiOptions.SCOPE_TYPE = defaultScope.getScopeType();
            }
        }
        uiOptions.ANALYZE_TEST_SOURCES = this.isInspectTestSources();
        scope.setIncludeTestSource(this.isInspectTestSources());
        FindSettings.getInstance().setDefaultScopeName(scope.getDisplayName());
        AnalysisScope analysisScope = scope;
        if (analysisScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/analysis/BaseAnalysisActionDialog.getScope must not return null");
        }
        return analysisScope;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ButtonGroup buttonGroup;
        TitledSeparator titledSeparator;
        JComboBox jComboBox;
        ScopeChooserCombo scopeChooserCombo;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 4, 0), -1, -1, false, false));
        this.myProjectButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/AnalysisScopeBundle").getString("scope.option.whole.project"));
        jPanel.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null, 1));
        this.myModuleButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("");
        jPanel.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null, 1));
        this.myUncommitedFilesButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/AnalysisScopeBundle").getString("scope.option.uncommited.files"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myFileButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("");
        jPanel.add((Component)jRadioButton2, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null, 1));
        this.myCustomScopeButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AnalysisScopeBundle").getString("scope.option.custom"));
        jPanel.add((Component)jRadioButton, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myInspectTestSource = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/AnalysisScopeBundle").getString("scope.option.include.test.sources"));
        jCheckBox.setMargin(new Insets(20, 3, 2, 3));
        jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null, 1));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myScopeCombo = scopeChooserCombo = new ScopeChooserCombo();
        jPanel.add((Component)((Object)scopeChooserCombo), new GridConstraints(5, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myChangeLists = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTitledSeparator = titledSeparator = new TitledSeparator();
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myGroup = buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

