/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class CompletionProcessor
extends ResolverProcessor {
    private CompletionProcessor(PsiElement place, EnumSet<ClassHint.ResolveKind> resolveTargets, String name) {
        super(name, resolveTargets, place, PsiType.EMPTY_ARRAY);
    }

    @Override
    public boolean execute(PsiElement element, ResolveState substitutor) {
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            return true;
        }
        super.execute(element, substitutor);
        return true;
    }

    public static ResolverProcessor createPropertyCompletionProcessor(PsiElement place) {
        return new CompletionProcessor(place, EnumSet.of(ClassHint.ResolveKind.METHOD, ClassHint.ResolveKind.PROPERTY), null);
    }

    public static ResolverProcessor createRefSameNameProcessor(PsiElement place, String name) {
        return new CompletionProcessor(place, EnumSet.of(ClassHint.ResolveKind.METHOD, ClassHint.ResolveKind.PROPERTY), name);
    }

    public static ResolverProcessor createClassCompletionProcessor(PsiElement place) {
        return new CompletionProcessor(place, EnumSet.of(ClassHint.ResolveKind.PACKAGE, ClassHint.ResolveKind.CLASS), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        GroovyResolveResult[] groovyResolveResultArray;
        if (this.myCandidates.size() == 0) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (GroovyResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/CompletionProcessor.getCandidates must not return null");
            return groovyResolveResultArray;
        }
        groovyResolveResultArray = ResolveUtil.filterSameSignatureCandidates(this.myCandidates, -1);
        if (groovyResolveResultArray != null) return groovyResolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/CompletionProcessor.getCandidates must not return null");
    }
}

