/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesContributor;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyExpectedTypesProvider {
    private GroovyExpectedTypesProvider() {
    }

    public static TypeConstraint[] calculateTypeConstraints(GrExpression expression) {
        MyCalculator calculator = new MyCalculator(expression);
        ((GroovyPsiElement)expression.getParent()).accept(calculator);
        TypeConstraint[] result = calculator.getResult();
        ArrayList<TypeConstraint> custom = new ArrayList<TypeConstraint>();
        for (GroovyExpectedTypesContributor contributor : (GroovyExpectedTypesContributor[])GroovyExpectedTypesContributor.EP_NAME.getExtensions()) {
            custom.addAll(contributor.calculateTypeConstraints(expression));
        }
        if (!custom.isEmpty()) {
            custom.addAll(0, Arrays.asList(result));
            return custom.toArray(new TypeConstraint[custom.size()]);
        }
        return result;
    }

    public static Set<PsiType> getDefaultExpectedTypes(GrExpression element) {
        LinkedHashSet<PsiType> result = new LinkedHashSet<PsiType>();
        for (TypeConstraint constraint : GroovyExpectedTypesProvider.calculateTypeConstraints(element)) {
            result.add(constraint.getDefaultType());
        }
        return result;
    }

    private static class MyCalculator
    extends GroovyElementVisitor {
        private TypeConstraint[] myResult;
        private final GrExpression myExpression;

        public MyCalculator(GrExpression expression) {
            this.myExpression = expression;
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create("java.lang.Object", this.myExpression)};
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            GrTypeElement typeElement;
            GrParametersOwner parent = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class});
            if (parent instanceof GrMethod && (typeElement = ((GrMethod)parent).getReturnTypeElementGroovy()) != null) {
                PsiType type = typeElement.getType();
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create(type)};
            }
        }

        @Override
        public void visitVariable(GrVariable variable) {
            PsiType type;
            if (this.myExpression.equals(variable.getInitializerGroovy()) && (type = variable.getDeclaredType()) != null) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint(type, type)};
            }
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression methodCall) {
            GrExpression invokedExpression = methodCall.getInvokedExpression();
            if (this.myExpression.equals(invokedExpression)) {
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create("groovy.lang.Closure", methodCall)};
                return;
            }
            List<GrClosableBlock> closureArgs = Arrays.asList(methodCall.getClosureArguments());
            int closureIndex = closureArgs.indexOf(this.myExpression);
            if (closureIndex >= 0) {
                ArrayList<SubtypeConstraint> constraints = new ArrayList<SubtypeConstraint>();
                for (GroovyResolveResult variant : methodCall.getMethodVariants()) {
                    int paramIndex;
                    PsiParameter[] parameters = MyCalculator.getCallParameters(variant);
                    if (parameters == null || parameters.length == 0 || (paramIndex = parameters.length - closureArgs.size() + closureIndex) < 0) continue;
                    constraints.add(SubtypeConstraint.create(variant.getSubstitutor().substitute(parameters[paramIndex].getType())));
                }
                if (!constraints.isEmpty()) {
                    this.myResult = constraints.toArray(new TypeConstraint[constraints.size()]);
                }
            }
        }

        @Override
        public void visitOpenBlock(GrOpenBlock block) {
            PsiType type;
            GrStatement[] statements;
            if (block.getParent() instanceof PsiMethod && (statements = block.getStatements()).length > 0 && this.myExpression.equals(statements[statements.length - 1]) && (type = ((PsiMethod)block.getParent()).getReturnType()) != null) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint(type, type)};
            }
        }

        @Override
        public void visitIfStatement(GrIfStatement ifStatement) {
            if (this.myExpression.equals(ifStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(ifStatement), PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitWhileStatement(GrWhileStatement whileStatement) {
            if (this.myExpression.equals(whileStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(whileStatement), PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitTraditionalForClause(GrTraditionalForClause forClause) {
            if (this.myExpression.equals(forClause.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(forClause), PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitArgumentList(GrArgumentList list) {
            int idx = list.getExpressionArgumentIndex(this.myExpression);
            ArrayList<SubtypeConstraint> constraints = new ArrayList<SubtypeConstraint>();
            for (GroovyResolveResult variant : ResolveUtil.getMethodVariants(list)) {
                PsiParameter[] parameters = MyCalculator.getCallParameters(variant);
                if (parameters == null || parameters.length <= idx) continue;
                PsiType parameterType = variant.getSubstitutor().substitute(parameters[idx].getType());
                constraints.add(SubtypeConstraint.create(parameterType));
            }
            if (!constraints.isEmpty()) {
                this.myResult = constraints.toArray(new TypeConstraint[constraints.size()]);
            }
        }

        @Nullable
        private static PsiParameter[] getCallParameters(GroovyResolveResult variant) {
            PsiElement element = variant.getElement();
            if (element instanceof GrParametersOwner) {
                return ((GrParametersOwner)element).getParameters();
            }
            if (element instanceof PsiMethod) {
                return ((PsiMethod)element).getParameterList().getParameters();
            }
            return null;
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression expression) {
            PsiType rType;
            GrExpression rValue = expression.getRValue();
            if (this.myExpression.equals(rValue)) {
                PsiType lType = expression.getLValue().getType();
                if (lType != null) {
                    this.myResult = new TypeConstraint[]{SubtypeConstraint.create(lType)};
                }
            } else if (this.myExpression.equals(expression.getLValue()) && rValue != null && (rType = rValue.getType()) != null) {
                this.myResult = new TypeConstraint[]{SupertypeConstraint.create(rType)};
            }
        }

        @Override
        public void visitThrowStatement(GrThrowStatement throwStatement) {
            PsiClassType trowable = PsiType.getJavaLangTrowable((PsiManager)this.myExpression.getManager(), (GlobalSearchScope)throwStatement.getResolveScope());
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create((PsiType)trowable)};
        }

        @Override
        public void visitUnaryExpression(final GrUnaryExpression expression) {
            TypeConstraint constraint = new TypeConstraint(PsiType.INT){

                @Override
                public boolean satisfied(PsiType type, PsiManager manager, GlobalSearchScope scope) {
                    return TypesUtil.getOverloadedOperatorCandidates(TypesUtil.boxPrimitiveType(type, manager, scope), expression.getOperationTokenType(), (GroovyPsiElement)expression, PsiType.EMPTY_ARRAY).length > 0;
                }

                @Override
                public PsiType getDefaultType() {
                    return PsiType.INT;
                }
            };
            this.myResult = new TypeConstraint[]{constraint};
        }

        public TypeConstraint[] getResult() {
            return this.myResult;
        }
    }
}

