/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.control.additional;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class CatchFinallyFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        GrTryCatchStatement tryStatement;
        if (context != null && GroovyCompletionUtil.nearestLeftSibling(context) instanceof GrTryCatchStatement) {
            tryStatement = (GrTryCatchStatement)GroovyCompletionUtil.nearestLeftSibling(context);
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getFinallyClause() == null) {
                return true;
            }
        }
        if (context != null && GroovyCompletionUtil.nearestLeftSibling(context) instanceof PsiErrorElement && GroovyCompletionUtil.nearestLeftSibling(context).getPrevSibling() instanceof GrTryCatchStatement) {
            tryStatement = (GrTryCatchStatement)GroovyCompletionUtil.nearestLeftSibling(context).getPrevSibling();
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getFinallyClause() == null) {
                return true;
            }
        }
        if (context != null && (context.getParent() instanceof GrReferenceExpression || context.getParent() instanceof PsiErrorElement) && GroovyCompletionUtil.nearestLeftSibling(context.getParent()) instanceof GrTryCatchStatement) {
            tryStatement = (GrTryCatchStatement)GroovyCompletionUtil.nearestLeftSibling(context.getParent());
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getFinallyClause() == null) {
                return true;
            }
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "filter fo 'catch' and 'finally' keywords";
    }
}

