/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandlerAdapter;
import org.jetbrains.plugins.groovy.lang.completion.filters.classdef.ExtendsFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.classdef.ImplementsFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.control.BranchFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.control.ControlStructureFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.control.additional.CaseDefaultFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.control.additional.CatchFinallyFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.control.additional.ElseFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.exprs.InstanceOfFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.exprs.SimpleExpressionFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.modifiers.FinalFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.modifiers.ModifiersFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.modifiers.PreviousModifierFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.modifiers.StaticFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.modifiers.SynchronizedFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.modifiers.ThrowsFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.toplevel.AnnotationFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.toplevel.ClassInterfaceEnumFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.toplevel.ImportFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.toplevel.PackageFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.types.BuiltInTypeAsArgumentFilter;
import org.jetbrains.plugins.groovy.lang.completion.filters.types.BuiltInTypeFilter;
import org.jetbrains.plugins.groovy.lang.completion.getters.SuggestedVariableNamesGetter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;

public class GroovyCompletionData
extends CompletionData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionData");
    public static final String[] BUILT_IN_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "float", "long", "double", "void"};
    public static final String[] MODIFIERS = new String[]{"private", "public", "protected", "transient", "abstract", "native", "volatile", "strictfp"};

    public GroovyCompletionData() {
        this.registerAllCompletions();
    }

    private void registerAllCompletions() {
        this.registerPackageCompletion();
        this.registerImportCompletion();
        this.registerClassInterfaceEnumAnnotationCompletion();
        this.registerControlCompletion();
        this.registerSimpleExprsCompletion();
        this.registerBuiltInTypeCompletion();
        this.registerBuiltInTypesAsArgumentCompletion();
        this.registerInstanceofCompletion();
        this.registerThrowsCompletion();
        this.registerBranchCompletion();
        this.registerModifierCompletion();
        this.registerSynchronizedCompletion();
        this.registerFinalCompletion();
        this.registerSuggestVariableNameCompletion();
    }

    private void registerSuggestVariableNameCompletion() {
        CompletionVariant variant = new CompletionVariant((ElementFilter)new ParentElementFilter((ElementFilter)new ClassFilter(GrVariable.class)));
        variant.includeScopeClass(LeafPsiElement.class);
        variant.addCompletion((ContextGetter)new SuggestedVariableNamesGetter(), TailType.NONE);
        this.registerVariant(variant);
    }

    private void registerPackageCompletion() {
        this.registerStandardCompletion(new PackageFilter(), "package");
    }

    private void registerClassInterfaceEnumAnnotationCompletion() {
        this.registerStandardCompletion(new ClassInterfaceEnumFilter(), "class", "interface", "enum");
        this.registerStandardCompletion(new AnnotationFilter(), "interface");
        this.registerStandardCompletion(new ExtendsFilter(), "extends");
        this.registerStandardCompletion(new ImplementsFilter(), "implements");
    }

    private void registerControlCompletion() {
        String[] controlKeywords = new String[]{"try", "while", "with", "switch", "for", "return", "throw", "assert", "synchronized"};
        this.registerStandardCompletion(new ControlStructureFilter(), controlKeywords);
        this.registerStandardCompletion(new CaseDefaultFilter(), "case", "default");
        this.registerStandardCompletion(new CatchFinallyFilter(), "catch", "finally");
        this.registerStandardCompletion(new ElseFilter(), "else");
    }

    private void registerBuiltInTypeCompletion() {
        this.registerStandardCompletion((ElementFilter)new AndFilter((ElementFilter)new BuiltInTypeFilter(), (ElementFilter)new NotFilter((ElementFilter)new ThrowsFilter())), BUILT_IN_TYPES);
    }

    private void registerBuiltInTypesAsArgumentCompletion() {
        AndFilter filter = new AndFilter((ElementFilter)new BuiltInTypeAsArgumentFilter(), (ElementFilter)new NotFilter((ElementFilter)new ThrowsFilter()));
        this.registerStandardCompletion((ElementFilter)filter, BUILT_IN_TYPES);
    }

    private void registerSimpleExprsCompletion() {
        String[] exprs = new String[]{"true", "false", "null", "super", "new", "this"};
        this.registerStandardCompletion(new SimpleExpressionFilter(), exprs);
    }

    private void registerThrowsCompletion() {
        this.registerStandardCompletion(new ThrowsFilter(), "throws");
    }

    private void registerFinalCompletion() {
        this.registerStandardCompletion((ElementFilter)new AndFilter((ElementFilter)new FinalFilter(), (ElementFilter)new NotFilter((ElementFilter)new ThrowsFilter())), "final");
    }

    private void registerSynchronizedCompletion() {
        this.registerStandardCompletion(new SynchronizedFilter(), "synchronized");
    }

    private void registerImportCompletion() {
        this.registerStandardCompletion(new ImportFilter(), "import");
    }

    private void registerInstanceofCompletion() {
        this.registerStandardCompletion(new InstanceOfFilter(), "instanceof");
    }

    private void registerBranchCompletion() {
        this.registerStandardCompletion(new BranchFilter(), "break", "continue");
    }

    private void registerModifierCompletion() {
        this.registerStandardCompletion(new ModifiersFilter(), MODIFIERS);
        this.registerStandardCompletion((ElementFilter)new LeftNeighbour((ElementFilter)new PreviousModifierFilter()), "private", "public", "protected", "transient", "abstract", "native", "volatile", "strictfp", "synchronized", "static");
        this.registerStandardCompletion(new StaticFilter(), "static");
    }

    public void completeReference(PsiReference reference, Set<LookupElement> set, @NotNull PsiElement position, PsiFile file, int offset) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionData.completeReference must not be null");
        }
        super.completeReference(reference, set, position, file, offset);
        THashSet result = new THashSet();
        for (LookupElement element : set) {
            result.add(LookupElementDecorator.withInsertHandler((LookupElement)element, (InsertHandler)new GroovyInsertHandlerAdapter()));
        }
        set.clear();
        set.addAll((Collection<LookupElement>)result);
    }

    private void registerStandardCompletion(ElementFilter filter, String ... keywords) {
        LeftNeighbour afterDotFilter = new LeftNeighbour((ElementFilter)new TextFilter(".", ".&"));
        CompletionVariant variant = new CompletionVariant((ElementFilter)new AndFilter((ElementFilter)new NotFilter((ElementFilter)afterDotFilter), filter));
        variant.setItemProperty(LookupItem.HIGHLIGHTED_ATTR, (Object)"");
        variant.includeScopeClass(LeafPsiElement.class);
        variant.setInsertHandler((InsertHandler)new GroovyInsertHandlerAdapter());
        this.addCompletions(variant, keywords);
        this.registerVariant(variant);
    }

    public String findPrefix(PsiElement insertedElement, int offset) {
        char c;
        int start;
        if (insertedElement == null) {
            return "";
        }
        String text = insertedElement.getText();
        int offsetInElement = offset - insertedElement.getTextRange().getStartOffset();
        for (start = offsetInElement - 1; start >= 0 && (Character.isJavaIdentifierPart(c = text.charAt(start)) || c == '\''); --start) {
        }
        return text.substring(start + 1, offsetInElement).trim();
    }

    private void addCompletions(CompletionVariant variant, String ... comps) {
        for (String completion : comps) {
            variant.addCompletion(completion, TailType.SPACE);
        }
    }
}

