/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyImportsTracker;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.editor.GroovyImportOptimizer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GroovyUnusedImportPass
extends TextEditorHighlightingPass {
    private final PsiFile myFile;
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.codeInspection.local.GroovyUnusedImportsPass");
    private volatile Set<GrImportStatement> myUnusedImports = Collections.emptySet();

    public GroovyUnusedImportPass(PsiFile file, Editor editor) {
        super(file.getProject(), editor.getDocument(), true);
        this.myFile = file;
    }

    public void doCollectInformation(ProgressIndicator progress) {
        if (!(this.myFile instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)this.myFile;
        GroovyImportsTracker importsTracker = GroovyImportsTracker.getInstance(groovyFile.getProject());
        this.myUnusedImports = importsTracker.getUnusedImportStatements(groovyFile);
    }

    private IntentionAction createUnusedImportIntention() {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = GroovyInspectionBundle.message("optimize.all.imports", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/local/GroovyUnusedImportPass$1.getText must not return null");
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = GroovyInspectionBundle.message("optimize.imports", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/local/GroovyUnusedImportPass$1.getFamilyName must not return null");
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/local/GroovyUnusedImportPass$1.isAvailable must not be null");
                }
                return true;
            }

            public void invoke(final @NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/local/GroovyUnusedImportPass$1.invoke must not be null");
                }
                GroovyImportOptimizer optimizer = new GroovyImportOptimizer();
                final Runnable runnable = optimizer.processFile(file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(project, runnable, "optimize imports", (Object)this);
                    }
                });
            }

            public boolean startInWriteAction() {
                return true;
            }
        };
    }

    public void doApplyInformationToEditor() {
        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl();
        Object[] annotations = new Annotation[this.myUnusedImports.size()];
        int i = 0;
        for (GrImportStatement unusedImport : this.myUnusedImports) {
            IntentionAction action = this.createUnusedImportIntention();
            Annotation annotation = annotationHolder.createWarningAnnotation((PsiElement)unusedImport, GroovyInspectionBundle.message("unused.import", new Object[0]));
            annotation.setHighlightType(ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            annotation.registerFix(action);
            annotations[i++] = annotation;
        }
        List infos = ContainerUtil.map((Object[])annotations, (Function)new Function<Annotation, HighlightInfo>(){

            public HighlightInfo fun(Annotation annotation) {
                return HighlightInfo.fromAnnotation((Annotation)annotation);
            }
        });
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), (Collection)infos, (int)this.getId());
    }
}

