/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.intentions.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyTrivialConditionalInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Redundant conditional expression" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection.getDisplayName must not return null");
        }
        return "Redundant conditional expression";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        GrConditionalExpression exp = (GrConditionalExpression)args[0];
        return "'" + exp.getText() + "' can be simplified to '" + GroovyTrivialConditionalInspection.calculateReplacementExpression(exp) + "'  #loc";
    }

    private static String calculateReplacementExpression(GrConditionalExpression exp) {
        GrExpression thenExpression = exp.getThenBranch();
        GrExpression elseExpression = exp.getElseBranch();
        GrExpression condition = exp.getCondition();
        if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return condition.getText();
    }

    @Override
    public GroovyFix buildFix(PsiElement location) {
        return new TrivialConditionalFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(GrConditionalExpression exp) {
            super.visitConditionalExpression(exp);
            GrExpression condition = exp.getCondition();
            PsiType type = condition.getType();
            if (type == null || !PsiType.BOOLEAN.isAssignableFrom(type)) {
                return;
            }
            GrExpression thenExpression = exp.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            GrExpression elseExpression = exp.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression) || GroovyTrivialConditionalInspection.isTrue(thenExpression) && GroovyTrivialConditionalInspection.isFalse(elseExpression)) {
                this.registerError(exp);
            }
        }
    }

    private static class TrivialConditionalFix
    extends GroovyFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getName() {
            if ("Simplify" == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$TrivialConditionalFix.getName must not return null");
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            GrConditionalExpression expression = (GrConditionalExpression)descriptor.getPsiElement();
            String newExpression = GroovyTrivialConditionalInspection.calculateReplacementExpression(expression);
            TrivialConditionalFix.replaceExpression(expression, newExpression);
        }
    }
}

