/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class NewGroovyClassAction
extends CreateTemplateInPackageAction<GrTypeDefinition>
implements DumbAware {
    public NewGroovyClassAction() {
        super(GroovyBundle.message("newclass.menu.action.text", new Object[0]), GroovyBundle.message("newclass.menu.action.description", new Object[0]), GroovyIcons.CLASS, true);
    }

    @NotNull
    protected CreateFileFromTemplateDialog.Builder buildDialog(Project project, PsiDirectory directory) {
        CreateFileFromTemplateDialog.Builder builder = CreateFileFromTemplateDialog.createDialog((Project)project, (String)GroovyBundle.message("newclass.dlg.title", new Object[0]));
        builder.addKind("Class", GroovyIcons.CLASS, "GroovyClass.groovy");
        builder.addKind("Interface", GroovyIcons.INTERFACE, "GroovyInterface.groovy");
        builder.addKind("Enum", GroovyIcons.ENUM, "GroovyEnum.groovy");
        builder.addKind("Annotation", GroovyIcons.ANNOTATION_TYPE, "GroovyAnnotation.groovy");
        CreateFileFromTemplateDialog.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/actions/NewGroovyClassAction.buildDialog must not return null");
        }
        return builder2;
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibrariesUtil.hasGroovySdk((Module)DataKeys.MODULE.getData(dataContext));
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return GroovyBundle.message("newclass.menu.action.text", new Object[0]);
    }

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    protected PsiElement getNavigationElement(@NotNull GrTypeDefinition createdElement) {
        if (createdElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/actions/NewGroovyClassAction.getNavigationElement must not be null");
        }
        return createdElement.getLBraceGroovy();
    }

    protected final GrTypeDefinition doCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        String fileName = className + ".groovy";
        GroovyFile file = (GroovyFile)GroovyTemplatesFactory.createFromTemplate(dir, className, fileName, templateName, new String[0]);
        return file.getTypeDefinitions()[0];
    }
}

