/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import git4idea.config.GitConfigUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUtil {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.GitUtil");
    public static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    };
    public static final String UTF8_ENCODING = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    private GitUtil() {
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Collection<VirtualFile> virtualFiles) throws VcsException {
        if (virtualFiles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitUtil.sortFilesByGitRoot must not be null");
        }
        Map<VirtualFile, List<VirtualFile>> map = GitUtil.sortFilesByGitRoot(virtualFiles, false);
        if (map == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitUtil.sortFilesByGitRoot must not return null");
        }
        return map;
    }

    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(Collection<VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        HashMap<VirtualFile, List<VirtualFile>> result = new HashMap<VirtualFile, List<VirtualFile>>();
        for (VirtualFile file : virtualFiles) {
            VirtualFile vcsRoot = GitUtil.gitRootOrNull(file);
            if (vcsRoot == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + file.getPath() + " is not under Git");
            }
            ArrayList<VirtualFile> files = (ArrayList<VirtualFile>)result.get(vcsRoot);
            if (files == null) {
                files = new ArrayList<VirtualFile>();
                result.put(vcsRoot, files);
            }
            files.add(file);
        }
        return result;
    }

    public static String getRelativeFilePath(VirtualFile file, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitUtil.getRelativeFilePath must not be null");
        }
        return GitUtil.getRelativeFilePath(file.getPath(), baseDir);
    }

    public static String getRelativeFilePath(FilePath file, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitUtil.getRelativeFilePath must not be null");
        }
        return GitUtil.getRelativeFilePath(file.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file, @NotNull VirtualFile baseDir) {
        String basePath;
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitUtil.getRelativeFilePath must not be null");
        }
        if (SystemInfo.isWindows) {
            file = file.replace('\\', '/');
        }
        if (!file.startsWith(basePath = baseDir.getPath())) {
            return file;
        }
        if (file.equals(basePath)) {
            return ".";
        }
        return file.substring(baseDir.getPath().length() + 1);
    }

    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(Collection<FilePath> files) throws VcsException {
        return GitUtil.sortFilePathsByGitRoot(files, false);
    }

    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(Collection<FilePath> files, boolean ignoreNonGit) throws VcsException {
        HashMap<VirtualFile, List<FilePath>> rc = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath p : files) {
            VirtualFile root = GitUtil.getGitRootOrNull(p);
            if (root == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + p.getPath() + " is not under Git");
            }
            ArrayList<FilePath> l = (ArrayList<FilePath>)rc.get(root);
            if (l == null) {
                l = new ArrayList<FilePath>();
                rc.put(root, l);
            }
            l.add(p);
        }
        return rc;
    }

    public static String unescapePath(String path) throws VcsException {
        int l = path.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (++i >= l) {
                    throw new VcsException("Unterminated escape sequence in the path: " + path);
                }
                char e = path.charAt(i);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    default: {
                        if (GitUtil.isOctal(e)) {
                            int n = 0;
                            for (int j = i; j < l; ++j) {
                                if (GitUtil.isOctal(path.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && GitUtil.isOctal(path.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path.charAt(j) != '\\' || !GitUtil.isOctal(path.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i < l) {
                                if (GitUtil.isOctal(path.charAt(i))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i < l && GitUtil.isOctal(path.charAt(i)); ++i, ++k) {
                                        code = code * 8 + (path.charAt(i) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i + 1 >= l || path.charAt(i) != '\\' || !GitUtil.isOctal(path.charAt(i + 1))) break;
                                ++i;
                            }
                            assert (n == b.length);
                            String encoding = GitConfigUtil.getFileNameEncoding();
                            try {
                                rc.append(new String(b, encoding));
                                break;
                            }
                            catch (UnsupportedEncodingException e1) {
                                throw new IllegalStateException("The file name encoding is unsuported: " + encoding);
                            }
                        }
                        throw new VcsException("Unknown escape sequence '\\" + path.charAt(i) + "' in the path: " + path);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        return rc.toString();
    }

    private static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static Date parseTimestamp(String value) {
        return new Date(Long.parseLong(value.trim()) * 1000L);
    }

    public static Set<VirtualFile> gitRootsForPaths(Collection<VirtualFile> roots) {
        HashSet<VirtualFile> rc = new HashSet<VirtualFile>();
        Iterator<VirtualFile> i$ = roots.iterator();
        block0: while (i$.hasNext()) {
            VirtualFile root;
            VirtualFile f = root = i$.next();
            do {
                if (f.findFileByRelativePath(".git") == null) continue;
                rc.add(f);
                continue block0;
            } while ((f = f.getParent()) != null);
        }
        return rc;
    }

    public static VirtualFile getGitRoot(FilePath filePath) throws VcsException {
        VirtualFile root = GitUtil.getGitRootOrNull(filePath);
        if (root != null) {
            return root;
        }
        throw new VcsException("The file " + filePath + " is not under git.");
    }

    @Nullable
    public static VirtualFile getGitRootOrNull(FilePath filePath) {
        File file;
        for (file = filePath.getIOFile(); !(file == null || file.exists() && file.isDirectory() && new File(file, ".git").exists()); file = file.getParentFile()) {
        }
        if (file == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static VirtualFile getGitRoot(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitUtil.getGitRoot must not be null");
        }
        VirtualFile root = GitUtil.gitRootOrNull(file);
        if (root != null) {
            return root;
        }
        throw new VcsException("The file " + file.getPath() + " is not under git.");
    }

    @Nullable
    public static VirtualFile gitRootOrNull(VirtualFile file) {
        VirtualFile root;
        if (file instanceof AbstractVcsVirtualFile) {
            return GitUtil.getGitRootOrNull(VcsUtil.getFilePath((String)file.getPath()));
        }
        for (root = file; root != null; root = root.getParent()) {
            if (root.findFileByRelativePath(".git") == null) continue;
            return root;
        }
        return root;
    }

    public static boolean isUnderGit(VirtualFile vFile) {
        return GitUtil.gitRootOrNull(vFile) != null;
    }

    public static String relativePath(VirtualFile root, FilePath path) {
        return GitUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), path.getIOFile());
    }

    public static String relativePath(File root, FilePath path) {
        return GitUtil.relativePath(root, path.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file) {
        return GitUtil.relativePath(root, VfsUtil.virtualToIoFile((VirtualFile)file));
    }

    public static String relativePath(VirtualFile root, VirtualFile file) {
        return GitUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), VfsUtil.virtualToIoFile((VirtualFile)file));
    }

    public static String relativePath(File root, File path) {
        String rc = FileUtil.getRelativePath((File)root, (File)path);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path + " cannot be made relative to " + root);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<FilePath> filePaths) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitUtil.toRelativePaths must not be null");
        }
        if (filePaths == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitUtil.toRelativePaths must not be null");
        }
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath path : filePaths) {
            rc.add(GitUtil.relativePath(root, path));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitUtil.toRelativeFiles must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitUtil.toRelativeFiles must not be null");
        }
        ArrayList<String> rc = new ArrayList<String>(files.size());
        for (VirtualFile file : files) {
            rc.add(GitUtil.relativePath(root, file));
        }
        return rc;
    }

    public static void refreshFiles(@NotNull Project project, @NotNull Collection<VirtualFile> affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitUtil.refreshFiles must not be null");
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitUtil.refreshFiles must not be null");
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile file : affectedFiles) {
            if (!file.isValid()) continue;
            file.refresh(false, true);
            if (file.isDirectory()) {
                dirty.dirDirtyRecursively(file);
                continue;
            }
            dirty.fileDirty(file);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<VirtualFile> affectedFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitUtil.markFilesDirty must not be null");
        }
        if (affectedFiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/GitUtil.markFilesDirty must not be null");
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile file : affectedFiles) {
            if (!file.isValid()) continue;
            if (file.isDirectory()) {
                dirty.dirDirtyRecursively(file);
                continue;
            }
            dirty.fileDirty(file);
        }
    }

    public static void markFilesDirty(Project project, List<FilePath> affectedFiles) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath file : affectedFiles) {
            if (file.isDirectory()) {
                dirty.dirDirtyRecursively(file);
                continue;
            }
            dirty.fileDirty(file);
        }
    }

    public static void refreshFiles(Project project, List<FilePath> affectedFiles) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath file : affectedFiles) {
            VirtualFile vFile = VcsUtil.getVirtualFile((File)file.getIOFile());
            if (vFile != null) {
                vFile.refresh(false, true);
            }
            if (file.isDirectory()) {
                dirty.dirDirtyRecursively(file);
                continue;
            }
            dirty.fileDirty(file);
        }
    }

    public static String adjustAuthorName(String authorName, String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = authorName + ", via " + committerName;
        }
        return committerName;
    }

    public static boolean isUnderGit(FilePath path) {
        return GitUtil.getGitRootOrNull(path) != null;
    }

    public static Set<VirtualFile> gitRoots(Collection<FilePath> filePaths) {
        HashSet<VirtualFile> rc = new HashSet<VirtualFile>();
        for (FilePath path : filePaths) {
            VirtualFile root = GitUtil.getGitRootOrNull(path);
            if (root == null) continue;
            rc.add(root);
        }
        return rc;
    }

    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    @Nullable
    public static VirtualFile getPossibleBase(VirtualFile file, String ... path) {
        return GitUtil.getPossibleBase(file, path.length, path);
    }

    @Nullable
    private static VirtualFile getPossibleBase(VirtualFile file, int n, String ... path) {
        VirtualFile c;
        if (file == null || n <= 0 || n > path.length) {
            return null;
        }
        int i = 1;
        for (c = file; c != null && i < n && path[n - i].equals(c.getName()); ++i, c = c.getParent()) {
        }
        if (i == n && c != null) {
            return c.getParent();
        }
        return GitUtil.getPossibleBase(file, n - 1, path);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<GitSimpleHandler> parametersSpecifier, Consumer<CommittedChangeList> consumer) throws VcsException {
        ArrayList rc = new ArrayList();
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.setNoSSH(true);
        h.addParameters("--pretty=format:%x0C%n%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output = h.run();
        LOG.debug("getLocalCommittedChanges output: '" + output + "'");
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData() && s.startsWith('\f')) {
            s.nextLine();
            consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, s));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is avaialble: " + s.line());
        }
    }

    public static List<CommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<GitSimpleHandler> parametersSpecifier) throws VcsException {
        final ArrayList<CommittedChangeList> rc = new ArrayList<CommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, new Consumer<CommittedChangeList>(){

            public void consume(CommittedChangeList committedChangeList) {
                rc.add(committedChangeList);
            }
        });
        return rc;
    }

    public static VcsException rethrowVcsException(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof VcsException) {
            return (VcsException)t;
        }
        return new VcsException(t.getMessage(), t);
    }
}

