/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.misc.AntPsiUtil;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;

public class AntCreateMacroDefFix
extends BaseIntentionAction {
    private final AntStructuredElement myUndefinedElement;
    private final AntFile myFile;

    public AntCreateMacroDefFix(AntStructuredElement undefinedElement) {
        this(undefinedElement, null);
    }

    public AntCreateMacroDefFix(AntStructuredElement undefinedElement, AntFile file) {
        this.myUndefinedElement = undefinedElement;
        this.myFile = file;
    }

    @NotNull
    public String getFamilyName() {
        String i18nName = AntBundle.message("intention.create.macrodef.family.name", new Object[0]);
        String string = i18nName == null ? "Create macrodef" : i18nName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreateMacroDefFix.getFamilyName must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getText() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append(this.getFamilyName());
        builder.append(" '");
        builder.append(this.myUndefinedElement.getSourceElement().getName());
        builder.append('\'');
        if (this.myFile != null) {
            builder.append(' ');
            builder.append(AntBundle.message("text.in.the.file", this.myFile.getName()));
        }
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntCreateMacroDefFix.getText must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreateMacroDefFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntCreateMacroDefFix.invoke must not be null");
        }
        AntStructuredElement element = this.myUndefinedElement;
        AntProject antProject = this.myFile == null ? element.getAntProject() : this.myFile.getAntProject();
        AntElement anchor = this.myFile == null ? AntPsiUtil.getSubProjectElement(element) : (AntElement)PsiTreeUtil.getChildOfType((PsiElement)antProject, AntStructuredElement.class);
        XmlTag se = element.getSourceElement();
        XmlTag projectTag = antProject.getSourceElement();
        XmlTag macrodefTag = projectTag.createChildTag("macrodef", projectTag.getNamespace(), null, false);
        macrodefTag.setAttribute("name", se.getName());
        for (XmlAttribute xmlAttribute : se.getAttributes()) {
            XmlTag attrTag = macrodefTag.createChildTag("attribute", macrodefTag.getNamespace(), null, false);
            attrTag.setAttribute("name", xmlAttribute.getName());
            macrodefTag.add((PsiElement)attrTag);
        }
        for (XmlAttribute xmlAttribute : se.getSubTags()) {
            XmlTag elementTag = macrodefTag.createChildTag("element", macrodefTag.getNamespace(), null, false);
            elementTag.setAttribute("name", xmlAttribute.getName());
            macrodefTag.add((PsiElement)elementTag);
        }
        macrodefTag = (XmlTag)(anchor == null ? projectTag.add((PsiElement)macrodefTag) : projectTag.addBefore((PsiElement)macrodefTag, (PsiElement)anchor.getSourceElement()));
        ((Navigatable)macrodefTag).navigate(true);
        if (this.myFile != null) {
            element.getAntFile().clearCaches();
        }
    }
}

