/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.config.impl.AntResourcesClassLoader;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntFilesProvider;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.AntTypeDef;
import com.intellij.lang.ant.psi.impl.AntElementFactory;
import com.intellij.lang.ant.psi.impl.AntFileImpl;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.impl.reference.AntRefIdReference;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.lang.ant.psi.introspection.impl.AntTypeDefinitionImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ObjectCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.Property;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntTypeDefImpl
extends AntTaskImpl
implements AntTypeDef {
    @NonNls
    private static final String CLASSPATH_ATTR = "classpath";
    @NonNls
    private static final String URI_ATTR = "uri";
    @NonNls
    private static final String RESOURCE_ATTR = "resource";
    @NonNls
    private static final String FILE_ATTR = "file";
    @NonNls
    private static final String CLASSNAME_ATTR = "classname";
    @NonNls
    private static final String ADAPTER_ATTR = "adapter";
    @NonNls
    private static final String ADAPTTO_ATTR = "adaptto";
    @NonNls
    private static final String BASEDIR_ANT_REFERENCE = "${basedir}";
    private static final ClassLoaderCache LOADERS_CACHE = new ClassLoaderCache();
    private AntTypeDefinition[] myNewDefinitions;
    private boolean myClassesLoaded;
    private String myLocalizedError;

    public AntTypeDefImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
        this.getDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntTypeDef[");
            builder.append(this.getSourceElement().getName());
            builder.append("]");
            AntTypeDefinition[] defs = this.getDefinitions();
            if (defs.length != 0) {
                builder.append(" classes={");
                builder.append(defs[0].getClassName());
                for (int i = 1; i < defs.length; ++i) {
                    builder.append(',');
                    builder.append(defs[i].getClassName());
                }
                builder.append("}");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<String> getFileReferenceAttributes() {
        List<String> list;
        List<String> attribs = super.getFileReferenceAttributes();
        String cp = this.getClassPath();
        if (cp != null && cp.length() > 0 && !cp.contains(";") && !cp.contains(":")) {
            ArrayList<String> _attribs = new ArrayList<String>(attribs.size() + 1);
            _attribs.addAll(attribs);
            _attribs.add(CLASSPATH_ATTR);
            list = _attribs;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntTypeDefImpl.getFileReferenceAttributes must not return null");
            return list;
        }
        list = attribs;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntTypeDefImpl.getFileReferenceAttributes must not return null");
    }

    @Override
    @Nullable
    public String getDefinedName() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(this.getNameElementAttribute()));
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(CLASSNAME_ATTR));
    }

    @Override
    @Nullable
    public String getAdapterName() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(ADAPTER_ATTR));
    }

    @Override
    @Nullable
    public String getAdaptToName() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(ADAPTTO_ATTR));
    }

    @Override
    @Nullable
    public String getClassPath() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(CLASSPATH_ATTR));
    }

    @Override
    @Nullable
    public String getUri() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(URI_ATTR));
    }

    @Override
    @Nullable
    public String getFile() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(FILE_ATTR));
    }

    @Override
    @Nullable
    public String getResource() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue(RESOURCE_ATTR));
    }

    @Override
    @NonNls
    @Nullable
    public String getFormat() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue("format"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.clearClassesCache();
            AntFile file = this.getAntFile();
            if (file != null) {
                file.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AntTypeDefinition[] getDefinitions() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myNewDefinitions == null || !this.typesLoaded() && this.myLocalizedError == null) {
            this.myNewDefinitions = AntTypeDefinition.EMPTY_ARRAY;
            String classname = this.getClassName();
            if (classname != null) {
                AntStructuredElement parent = this.getAntParent();
                AntFile antFile = parent != null ? parent.getAntFile() : null;
                this.loadClass(antFile, classname, this.getDefinedName(), this.getUri(), this.getAntParent());
            } else {
                String resource = this.getResource();
                if (resource != null) {
                    this.loadResource(resource);
                } else {
                    String file = this.getFile();
                    if (file != null) {
                        this.loadFile(file);
                    }
                }
            }
        }
        // MONITOREXIT : object
        if (this.myNewDefinitions != null) return this.myNewDefinitions;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntTypeDefImpl.getDefinitions must not return null");
    }

    @Override
    public boolean typesLoaded() {
        return this.myClassesLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClassesCache() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myNewDefinitions != null) {
                AntStructuredElement parent = this.getAntParent();
                if (parent != null) {
                    AntProject antProject = !(parent instanceof AntProject) ? parent.getAntProject() : null;
                    for (AntTypeDefinition def : this.myNewDefinitions) {
                        parent.unregisterCustomType(def);
                        if (antProject == null) continue;
                        antProject.unregisterCustomType(def);
                    }
                }
                this.myNewDefinitions = null;
            }
        }
    }

    @Override
    @Nullable
    public String getLocalizedError() {
        return this.myLocalizedError;
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntTypedef(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadAntlibStream(@NotNull InputStream antlibStream, AntStructuredElement element, String ns) {
        if (antlibStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl.loadAntlibStream must not be null");
        }
        String nsPrefix = element.getSourceElement().getPrefixByNamespace(ns);
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            int nextByte;
            while ((nextByte = antlibStream.read()) >= 0) {
                builder.append((char)nextByte);
            }
            antlibStream.close();
            XmlFile xmlFile = (XmlFile)AntTypeDefImpl.createDummyFile("dummy.xml", StdFileTypes.XML, builder, element.getManager());
            XmlDocument document = xmlFile.getDocument();
            if (document == null) {
                return;
            }
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return;
            }
            for (XmlTag tag : rootTag.getSubTags()) {
                AntElement newElement;
                if (nsPrefix != null && nsPrefix.length() > 0) {
                    try {
                        tag.setName(nsPrefix + ':' + tag.getLocalName());
                    }
                    catch (IncorrectOperationException e) {
                        continue;
                    }
                }
                if (!((newElement = AntElementFactory.createAntElement(element, (XmlElement)tag)) instanceof AntTypeDef)) continue;
                for (AntTypeDefinition def : ((AntTypeDef)newElement).getDefinitions()) {
                    if (!(element instanceof AntTypeDefImpl)) continue;
                    AntTypeDefImpl td = (AntTypeDefImpl)element;
                    Object[] defs = td.myNewDefinitions != null ? td.myNewDefinitions : AntTypeDefinition.EMPTY_ARRAY;
                    td.myNewDefinitions = (AntTypeDefinition[])ArrayUtil.append((Object[])defs, (Object)def);
                    ((AntTypeDefinitionImpl)def).setDefiningElement(td);
                }
            }
        }
        catch (IOException e) {
            if (element instanceof AntTypeDefImpl) {
                AntTypeDefImpl td = (AntTypeDefImpl)element;
                td.myClassesLoaded = false;
                td.myLocalizedError = e.getLocalizedMessage();
            }
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesStream(InputStream propStream, AntStructuredElement element) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            int nextByte;
            while ((nextByte = propStream.read()) >= 0) {
                builder.append((char)nextByte);
            }
            propStream.close();
            PropertiesFile propFile = (PropertiesFile)AntTypeDefImpl.createDummyFile("dummy.properties", StdFileTypes.PROPERTIES, builder, element.getManager());
            AntStructuredElement parent = this.getAntParent();
            AntFile antFile = parent != null ? parent.getAntFile() : null;
            for (com.intellij.lang.properties.psi.Property property : propFile.getProperties()) {
                this.loadClass(antFile, property.getValue(), property.getUnescapedKey(), this.getUri(), this.getAntParent());
            }
        }
        catch (IOException e) {
            if (element instanceof AntTypeDefImpl) {
                AntTypeDefImpl td = (AntTypeDefImpl)element;
                td.myClassesLoaded = false;
                td.myLocalizedError = e.getLocalizedMessage();
            }
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    private boolean isXmlFormat(@NonNls @NotNull String resourceOfFileName) {
        if (resourceOfFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl.isXmlFormat must not be null");
        }
        String format = this.getFormat();
        if (format != null) {
            return format.equals("xml");
        }
        return resourceOfFileName.endsWith(".xml");
    }

    private void loadResource(@NotNull String resource) {
        InputStream stream;
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl.loadResource must not be null");
        }
        ClassLoader loader = this.getClassLoader(this.getClassPathUrls());
        if (loader != null && (stream = loader.getResourceAsStream(resource)) != null) {
            this.myClassesLoaded = true;
            if (!this.isXmlFormat(resource)) {
                this.loadPropertiesStream(stream, this);
            } else {
                AntTypeDefImpl.loadAntlibStream(stream, this, this.getUri());
            }
        }
    }

    private void loadFile(String file) {
        VirtualFile vf;
        PsiFile psiFile = this.findFileByName(file, null);
        if (psiFile != null && (vf = psiFile.getVirtualFile()) != null) {
            try {
                InputStream stream = vf.getInputStream();
                if (stream != null) {
                    this.myClassesLoaded = true;
                    if (!this.isXmlFormat(file)) {
                        this.loadPropertiesStream(stream, this);
                    } else {
                        AntTypeDefImpl.loadAntlibStream(stream, this, this.getUri());
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private AntTypeDefinitionImpl loadClass(@Nullable AntFile antFile, @Nullable String classname, @Nullable String name, @Nullable String uri, AntStructuredElement parent) {
        AntTypeDefinitionImpl def;
        AntTypeId id;
        if (classname == null || name == null || name.length() == 0) {
            return null;
        }
        ProgressManager.checkCanceled();
        List<URL> urls = this.getClassPathUrls();
        Class<?> clazz = null;
        ClassLoader loader = this.getClassLoader(urls);
        if (loader != null) {
            try {
                clazz = loader.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                this.myLocalizedError = e.getLocalizedMessage();
                clazz = null;
            }
            catch (NoClassDefFoundError e) {
                this.myLocalizedError = e.getLocalizedMessage();
                clazz = null;
            }
            catch (UnsupportedClassVersionError e) {
                this.myLocalizedError = e.getLocalizedMessage();
                clazz = null;
            }
        }
        String nsPrefix = uri == null ? null : this.getSourceElement().getPrefixByNamespace(uri);
        AntTypeId antTypeId = id = nsPrefix == null ? new AntTypeId(name) : new AntTypeId(name, nsPrefix);
        if (clazz == null) {
            def = new AntTypeDefinitionImpl(id, classname, this.isTask(), false);
        } else {
            this.myClassesLoaded = true;
            boolean isTask = this.isTask(clazz);
            def = (AntTypeDefinitionImpl)AntFileImpl.createTypeDefinition(id, clazz, isTask);
            if (def == null) {
                def = new AntTypeDefinitionImpl(id, classname, isTask, AntTypeDefImpl.isAssignableFrom(TaskContainer.class.getName(), clazz));
            } else {
                this.fixNestedDefinitions(def);
            }
            def.setIsProperty(AntTypeDefImpl.isAssignableFrom(Property.class.getName(), clazz));
        }
        this.myNewDefinitions = (AntTypeDefinition[])ArrayUtil.append((Object[])this.myNewDefinitions, (Object)def);
        def.setDefiningElement(this);
        if (parent != null) {
            AntProject antProject;
            if (!(parent instanceof AntProject) && (antProject = parent.getAntProject()) != null) {
                antProject.registerCustomType(def);
            }
            parent.registerCustomType(def);
        } else if (antFile != null) {
            antFile.registerCustomType(def);
        }
        if (antFile != null) {
            for (AntTypeId typeId : def.getNestedElements()) {
                String nestedClassName = def.getNestedClassName(typeId);
                AntTypeDefinitionImpl nestedDef = (AntTypeDefinitionImpl)antFile.getBaseTypeDefinition(nestedClassName);
                if (nestedDef != null || (nestedDef = this.loadClass(antFile, nestedClassName, typeId.getName(), uri, null)) == null) continue;
                def.registerNestedType(nestedDef.getTypeId(), nestedDef.getClassName());
            }
        }
        return def;
    }

    private void fixNestedDefinitions(AntTypeDefinitionImpl def) {
        block0: for (AntTypeId nestedTypeId : def.getNestedElements()) {
            String className = def.getNestedClassName(nestedTypeId);
            if (!"java.lang.Object".equals(className)) continue;
            for (AntTypeDefinition typeDefinition : this.getAntFile().getBaseTypeDefinitions()) {
                if (!nestedTypeId.equals(typeDefinition.getTypeId()) || "java.lang.Object".equals(typeDefinition.getClassName())) continue;
                def.registerNestedType(nestedTypeId, typeDefinition.getClassName());
                continue block0;
            }
        }
    }

    private boolean isTask(Class clazz) {
        if (this.isTask()) {
            return true;
        }
        String adaptto = this.getAdaptToName();
        if (adaptto != null && AntTypeDefImpl.isAssignableFrom(adaptto, clazz)) {
            return AntTypeDefImpl.isAssignableFrom(Task.class.getName(), clazz);
        }
        String adapter = this.getAdapterName();
        if (adapter != null) {
            try {
                Class<?> adapterClass = clazz.getClassLoader().loadClass(adapter);
                return AntTypeDefImpl.isAssignableFrom(Task.class.getName(), adapterClass);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoClassDefFoundError ignored) {
            }
            catch (UnsupportedClassVersionError ignored) {
                // empty catch block
            }
        }
        return AntTypeDefImpl.isAssignableFrom(Task.class.getName(), clazz);
    }

    private static boolean isAssignableFrom(String baseClassName, Class clazz) {
        try {
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                Class<?> baseClass = loader.loadClass(baseClassName);
                return baseClass.isAssignableFrom(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private List<URL> getClassPathUrls() {
        List<URL> urls = this.getClassPathLocalUrls();
        for (AntElement parent = this.getAntParent(); parent != null && !(parent instanceof AntProject); parent = parent.getAntParent()) {
            if (!(parent instanceof AntTypeDefImpl)) continue;
            urls.addAll(((AntTypeDefImpl)parent).getClassPathLocalUrls());
        }
        return urls;
    }

    private List<URL> getClassPathLocalUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String baseDir = this.computeAttributeValue(BASEDIR_ANT_REFERENCE);
        String classpath = this.getClassPath();
        if (classpath != null) {
            PathTokenizer tokenizer = new PathTokenizer(classpath);
            while (tokenizer.hasMoreTokens()) {
                AntTypeDefImpl.addUrl(baseDir, urls, tokenizer.nextToken());
            }
        }
        ArrayList<File> files = new ArrayList<File>();
        HashSet<AntFilesProvider> processed = new HashSet<AntFilesProvider>();
        for (PsiReference psiReference : this.getReferences()) {
            PsiElement resolved;
            ProgressManager.checkCanceled();
            if (!(psiReference instanceof AntRefIdReference) || !((resolved = psiReference.resolve()) instanceof AntFilesProvider)) continue;
            files.addAll(((AntFilesProvider)resolved).getFiles(processed));
        }
        for (AntElement antElement : this.getChildren()) {
            ProgressManager.checkCanceled();
            if (!(antElement instanceof AntFilesProvider)) continue;
            files.addAll(((AntFilesProvider)((Object)antElement)).getFiles(processed));
        }
        for (File file : files) {
            try {
                urls.add(AntTypeDefImpl.toLocalURL(file));
            }
            catch (MalformedURLException e) {}
        }
        return urls;
    }

    private static URL toLocalURL(File file) throws MalformedURLException {
        return new URL(FILE_ATTR, "", FileUtil.toSystemIndependentName((String)file.getPath()));
    }

    private static void addUrl(String baseDir, List<URL> urls, String path) {
        if (path != null) {
            try {
                File file = new File(path);
                if (file.isAbsolute()) {
                    urls.add(AntTypeDefImpl.toLocalURL(file));
                } else if (baseDir != null) {
                    urls.add(AntTypeDefImpl.toLocalURL(new File(baseDir, path)));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    @Nullable
    private ClassLoader getClassLoader(List<URL> urls) {
        ClassLoader parentLoader;
        AntFile file = this.getAntFile();
        ClassLoader classLoader = parentLoader = file != null ? file.getClassLoader() : null;
        if (urls.size() == 0) {
            return parentLoader;
        }
        ClassLoader cached = LOADERS_CACHE.getClassLoader(urls);
        if (cached != null && parentLoader == cached.getParent()) {
            return cached;
        }
        AntResourcesClassLoader loader = new AntResourcesClassLoader(urls, parentLoader, false, false);
        LOADERS_CACHE.setClassLoader(urls, (ClassLoader)((Object)loader));
        return loader;
    }

    private boolean isTask() {
        return "taskdef".equals(this.getSourceElement().getName());
    }

    private static PsiFile createDummyFile(@NonNls String name, LanguageFileType type, CharSequence str, PsiManager manager) {
        return PsiFileFactory.getInstance((Project)manager.getProject()).createFileFromText(name, (FileType)type, str, LocalTimeCounter.currentTime(), false, false);
    }

    private static class ClassLoaderCache
    extends ObjectCache<CacheKey, SoftReference<ClassLoader>> {
        public ClassLoaderCache() {
            super(256);
        }

        @Nullable
        public final synchronized ClassLoader getClassLoader(@NotNull List<URL> urls) {
            ClassLoader result;
            if (urls == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl$ClassLoaderCache.getClassLoader must not be null");
            }
            CacheKey key = new CacheKey(urls);
            SoftReference ref = (SoftReference)this.tryKey(key);
            ClassLoader classLoader = result = ref == null ? null : (ClassLoader)ref.get();
            if (result == null && ref != null) {
                this.remove(key);
            }
            return result;
        }

        public final synchronized void setClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader loader) {
            if (urls == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl$ClassLoaderCache.setClassLoader must not be null");
            }
            if (loader == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl$ClassLoaderCache.setClassLoader must not be null");
            }
            this.cacheObject(new CacheKey(urls), new SoftReference<ClassLoader>(loader));
        }
    }

    private static class CacheKey {
        public static final URL[] EMPTY_URL_ARRAY = new URL[0];
        private final List<URL> myUrls;
        private final int myHashCode;

        public CacheKey(@NotNull List<URL> urls) {
            if (urls == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTypeDefImpl$CacheKey.<init> must not be null");
            }
            this.myUrls = urls;
            int hashCode = 1;
            for (URL url : urls) {
                hashCode = 31 * hashCode + url.getPath().hashCode();
            }
            this.myHashCode = hashCode;
        }

        public final int hashCode() {
            return this.myHashCode;
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey entry = (CacheKey)obj;
            List<URL> urls = this.myUrls;
            List<URL> thatUrls = entry.myUrls;
            if (urls.size() != thatUrls.size()) {
                return false;
            }
            Iterator<URL> urlsIt = urls.iterator();
            Iterator<URL> thatUrlsIt = thatUrls.iterator();
            while (urlsIt.hasNext()) {
                if (FileUtil.pathsEqual((String)urlsIt.next().getPath(), (String)thatUrlsIt.next().getPath())) continue;
                return false;
            }
            return true;
        }
    }
}

