/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.DetailExceptionsPredicate;
import com.siyeh.ipp.exceptions.ExceptionUtils;
import com.siyeh.ipp.exceptions.HeirarchicalTypeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DetailExceptionsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        DetailExceptionsPredicate detailExceptionsPredicate = new DetailExceptionsPredicate();
        if (detailExceptionsPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/exceptions/DetailExceptionsIntention.getElementPredicate must not return null");
        }
        return detailExceptionsPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiCatchSection[] catchSections;
        PsiJavaToken token = (PsiJavaToken)element;
        PsiTryStatement tryStatement = (PsiTryStatement)token.getParent();
        if (tryStatement == null) {
            return;
        }
        String text = tryStatement.getText();
        int length = text.length();
        StringBuilder newTryStatement = new StringBuilder(length);
        newTryStatement.append("try");
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        String tryBlockText = tryBlock.getText();
        newTryStatement.append(tryBlockText);
        HashSet<PsiType> exceptionsThrown = new HashSet<PsiType>();
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(tryBlock, exceptionsThrown);
        HeirarchicalTypeComparator comparator = new HeirarchicalTypeComparator();
        ArrayList<PsiType> exceptionsAlreadyEmitted = new ArrayList<PsiType>();
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            PsiParameter param = catchSection.getParameter();
            PsiCodeBlock block = catchSection.getCatchBlock();
            if (param == null || block == null) continue;
            PsiType caughtType = param.getType();
            ArrayList<PsiType> exceptionsToExpand = new ArrayList<PsiType>(10);
            for (PsiType aExceptionsThrown : exceptionsThrown) {
                PsiType thrownType = aExceptionsThrown;
                if (!caughtType.isAssignableFrom(thrownType)) continue;
                exceptionsToExpand.add(thrownType);
            }
            exceptionsToExpand.removeAll(exceptionsAlreadyEmitted);
            Collections.sort(exceptionsToExpand, comparator);
            for (PsiType thrownType : exceptionsToExpand) {
                newTryStatement.append("catch(");
                String exceptionType = thrownType.getCanonicalText();
                newTryStatement.append(exceptionType);
                newTryStatement.append(' ');
                String parameterName = param.getName();
                newTryStatement.append(parameterName);
                newTryStatement.append(')');
                String blockText = block.getText();
                newTryStatement.append(blockText);
                exceptionsAlreadyEmitted.add(thrownType);
            }
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatement.append("finally");
            String finallyBlockText = finallyBlock.getText();
            newTryStatement.append(finallyBlockText);
        }
        String newStatement = newTryStatement.toString();
        DetailExceptionsIntention.replaceStatementAndShorten(newStatement, (PsiStatement)tryStatement);
    }
}

