/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.braces.AddBracesPredicate;
import org.jetbrains.annotations.NotNull;

public class AddBracesIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AddBracesPredicate addBracesPredicate = new AddBracesPredicate();
        if (addBracesPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/braces/AddBracesIntention.getElementPredicate must not return null");
        }
        return addBracesPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        PsiElement parent = element.getParent();
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            keyword = element.equals(elseBranch) ? "else" : "if";
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = firstChild.getText();
        }
        return IntentionPowerPackBundle.message("add.braces.intention.name", keyword);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/braces/AddBracesIntention.processIntention must not be null");
        }
        PsiStatement statement = (PsiStatement)element;
        String newStatement = "{\n" + element.getText() + "\n}";
        AddBracesIntention.replaceStatement(newStatement, statement);
    }
}

