/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.junit2.ui.ConsolePanel;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.TreeCollapser;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import javax.swing.JComponent;

public class JUnitTreeConsoleView
extends BaseTestsOutputConsoleView {
    private ConsolePanel myConsolePanel;
    private final JUnitConsoleProperties myProperties;
    private final RunnerSettings myRunnerSettings;
    private final ConfigurationPerRunnerSettings myConfigurationSettings;

    public JUnitTreeConsoleView(JUnitConsoleProperties properties, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        super((TestConsoleProperties)properties);
        this.myProperties = properties;
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
        this.getPrinter().setCollectOutput(true);
    }

    protected TestResultsPanel createTestResultsPanel() {
        this.myConsolePanel = new ConsolePanel(this.getConsole().getComponent(), this.getPrinter(), this.myProperties, this.myRunnerSettings, this.myConfigurationSettings, this.getConsole().createConsoleActions());
        return this.myConsolePanel;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myConsolePanel.onProcessStarted(processHandler);
    }

    public void dispose() {
        super.dispose();
        this.myConsolePanel = null;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myConsolePanel.getTreeView();
    }

    public void attachToModel(JUnitRunningModel model) {
        this.getPrinter().setCollectOutput(false);
        this.myConsolePanel.getTreeView().attachToModel((TestFrameworkRunningModel)model);
        model.attachToTree(this.myConsolePanel.getTreeView());
        this.myConsolePanel.setModel(model);
        model.onUIBuilt();
        new TreeCollapser().setModel(model);
    }
}

