/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ant;

import com.intellij.ant.AntClassWriter;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class Javac2
extends Javac {
    private ArrayList myFormFiles;

    protected boolean areJavaClassesCompiled() {
        return true;
    }

    private void unsupportedOptionMessage(String optionName) {
        if (!this.areJavaClassesCompiled()) {
            this.log("The option " + optionName + " is not supported by instrumentIdeaExtenstions task", 0);
        }
    }

    public void setDebugLevel(String v) {
        this.unsupportedOptionMessage("debugLevel");
        super.setDebugLevel(v);
    }

    public void setListfiles(boolean list) {
        this.unsupportedOptionMessage("listFiles");
        super.setListfiles(list);
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.unsupportedOptionMessage("memoryInitialSize");
        super.setMemoryInitialSize(memoryInitialSize);
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.unsupportedOptionMessage("memoryMaximumSize");
        super.setMemoryMaximumSize(memoryMaximumSize);
    }

    public void setEncoding(String encoding) {
        this.unsupportedOptionMessage("encoding");
        super.setEncoding(encoding);
    }

    public void setOptimize(boolean optimize) {
        this.unsupportedOptionMessage("optimize");
        super.setOptimize(optimize);
    }

    public void setDepend(boolean depend) {
        this.unsupportedOptionMessage("depend");
        super.setDepend(depend);
    }

    public void setFork(boolean f) {
        this.unsupportedOptionMessage("fork");
        super.setFork(f);
    }

    public void setExecutable(String forkExec) {
        this.unsupportedOptionMessage("executable");
        super.setExecutable(forkExec);
    }

    public void setCompiler(String compiler) {
        this.unsupportedOptionMessage("compiler");
        super.setCompiler(compiler);
    }

    protected void compile() {
        ClassLoader loader;
        if (this.areJavaClassesCompiled()) {
            super.compile();
        }
        if ((loader = this.buildClasspathClassLoader()) == null) {
            return;
        }
        this.instrumentForms(loader);
        int instrumented = this.instrumentNotNull(this.getDestdir(), loader);
        this.log("Added @NotNull assertions to " + instrumented + " files", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentForms(ClassLoader loader) {
        ArrayList formsToInstrument = this.myFormFiles;
        if (formsToInstrument.size() == 0) {
            this.log("No forms to instrument found", 3);
            return;
        }
        HashMap<String, File> class2form = new HashMap<String, File>();
        for (int i = 0; i < formsToInstrument.size(); ++i) {
            LwRootContainer rootContainer;
            File formFile = (File)formsToInstrument.get(i);
            this.log("compiling form " + formFile.getAbsolutePath(), 3);
            try {
                rootContainer = Utils.getRootContainer(formFile.toURL(), (PropertiesProvider)new CompiledClassPropertiesProvider(loader));
            }
            catch (AlienFormFileException e) {
                continue;
            }
            catch (Exception e) {
                this.fireError("Cannot process form file " + formFile.getAbsolutePath() + ". Reason: " + e);
                continue;
            }
            String classToBind = rootContainer.getClassToBind();
            if (classToBind == null) continue;
            String name = classToBind.replace('.', '/');
            File classFile = this.getClassFile(name);
            if (classFile == null) {
                this.log(formFile.getAbsolutePath() + ": Class to bind does not exist: " + classToBind, 1);
                continue;
            }
            File alreadyProcessedForm = (File)class2form.get(classToBind);
            if (alreadyProcessedForm != null) {
                this.fireError(formFile.getAbsolutePath() + ": " + "The form is bound to the class " + classToBind + ".\n" + "Another form " + alreadyProcessedForm.getAbsolutePath() + " is also bound to this class.");
                continue;
            }
            class2form.put(classToBind, formFile);
            try {
                int version;
                FileInputStream stream = new FileInputStream(classFile);
                try {
                    version = Javac2.getClassFileVersion(new ClassReader((InputStream)stream));
                }
                finally {
                    ((InputStream)stream).close();
                }
                AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, loader, new AntNestedFormLoader(loader), false, new AntClassWriter(Javac2.getAsmClassWriterFlags(version), loader));
                codeGenerator.patchFile(classFile);
                FormErrorInfo[] warnings = codeGenerator.getWarnings();
                for (int j = 0; j < warnings.length; ++j) {
                    this.log(formFile.getAbsolutePath() + ": " + warnings[j].getErrorMessage(), 1);
                }
                FormErrorInfo[] errors = codeGenerator.getErrors();
                if (errors.length <= 0) continue;
                StringBuffer message = new StringBuffer();
                for (int j = 0; j < errors.length; ++j) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append(formFile.getAbsolutePath()).append(": ").append(errors[j].getErrorMessage());
                }
                this.fireError(message.toString());
                continue;
            }
            catch (Exception e) {
                this.fireError("Forms instrumentation failed for " + formFile.getAbsolutePath() + ": " + e.toString());
            }
        }
    }

    private static int getAsmClassWriterFlags(int version) {
        return version >= 50 && version != 196653 ? 2 : 1;
    }

    private ClassLoader buildClasspathClassLoader() {
        StringBuffer classPathBuffer = new StringBuffer();
        Path cp = new Path(this.getProject());
        this.appendPath(cp, this.getBootclasspath());
        cp.setLocation(this.getDestdir().getAbsoluteFile());
        this.appendPath(cp, this.getClasspath());
        this.appendPath(cp, this.getSourcepath());
        this.appendPath(cp, this.getSrcdir());
        if (this.getIncludeantruntime()) {
            cp.addExisting(cp.concatSystemClasspath("last"));
        }
        if (this.getIncludejavaruntime()) {
            cp.addJavaRuntime();
        }
        cp.addExtdirs(this.getExtdirs());
        String[] pathElements = cp.list();
        for (int i = 0; i < pathElements.length; ++i) {
            String pathElement = pathElements[i];
            classPathBuffer.append(File.pathSeparator);
            classPathBuffer.append(pathElement);
        }
        String classPath = classPathBuffer.toString();
        this.log("classpath=" + classPath, 3);
        try {
            return Javac2.createClassLoader(classPath);
        }
        catch (MalformedURLException e) {
            this.fireError(e.getMessage());
            return null;
        }
    }

    private void appendPath(Path cp, Path p) {
        if (p != null && p.size() > 0) {
            cp.append(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int instrumentNotNull(File dir, ClassLoader loader) {
        int instrumented = 0;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            if (name.endsWith(".class")) {
                String path = file.getPath();
                this.log("Adding @NotNull assertions to " + path, 3);
                try {
                    FileInputStream inputStream = new FileInputStream(file);
                    try {
                        ClassReader reader = new ClassReader((InputStream)inputStream);
                        int version = Javac2.getClassFileVersion(reader);
                        if (version < 49) continue;
                        AntClassWriter writer = new AntClassWriter(Javac2.getAsmClassWriterFlags(version), loader);
                        NotNullVerifyingInstrumenter instrumenter = new NotNullVerifyingInstrumenter((ClassVisitor)writer);
                        reader.accept((ClassVisitor)instrumenter, 0);
                        if (!instrumenter.isModification()) continue;
                        FileOutputStream fileOutputStream = new FileOutputStream(path);
                        try {
                            fileOutputStream.write(writer.toByteArray());
                            ++instrumented;
                        }
                        finally {
                            fileOutputStream.close();
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log("Failed to instrument @NotNull assertion for " + path + ": " + e.getMessage(), 1);
                }
                catch (Exception e) {
                    this.fireError("@NotNull instrumentation failed for " + path + ": " + e.toString());
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            instrumented += this.instrumentNotNull(file, loader);
        }
        return instrumented;
    }

    private static int getClassFileVersion(ClassReader reader) {
        final int[] classfileVersion = new int[1];
        reader.accept((ClassVisitor)new EmptyVisitor(){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                classfileVersion[0] = version;
            }
        }, 0);
        return classfileVersion[0];
    }

    private void fireError(String message) {
        if (this.failOnError) {
            throw new BuildException(message, this.getLocation());
        }
        this.log(message, 0);
    }

    private File getClassFile(String className) {
        String classOrInnerName = this.getClassOrInnerName(className);
        if (classOrInnerName == null) {
            return null;
        }
        return new File(this.getDestdir().getAbsolutePath(), classOrInnerName + ".class");
    }

    private String getClassOrInnerName(String className) {
        File classFile = new File(this.getDestdir().getAbsolutePath(), className + ".class");
        if (classFile.exists()) {
            return className;
        }
        int position = className.lastIndexOf(47);
        if (position == -1) {
            return null;
        }
        return this.getClassOrInnerName(className.substring(0, position) + '$' + className.substring(position + 1));
    }

    private static URLClassLoader createClassLoader(String classPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            urls.add(new File(s).toURL());
        }
        URL[] urlsArr = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(urlsArr, null);
    }

    protected void resetFileLists() {
        super.resetFileLists();
        this.myFormFiles = new ArrayList();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        super.scanDir(srcDir, destDir, files);
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.endsWith(".form")) continue;
            this.log("Found form file " + file, 3);
            this.myFormFiles.add(new File(srcDir, file));
        }
    }

    private class AntNestedFormLoader
    implements NestedFormLoader {
        private final ClassLoader myLoader;
        private final HashMap myFormCache = new HashMap();

        public AntNestedFormLoader(ClassLoader loader) {
            this.myLoader = loader;
        }

        public LwRootContainer loadForm(String formFileName) throws Exception {
            if (this.myFormCache.containsKey(formFileName)) {
                return (LwRootContainer)this.myFormCache.get(formFileName);
            }
            String formFileFullName = formFileName.toLowerCase();
            Javac2.this.log("Searching for form " + formFileFullName, 3);
            Iterator iterator = Javac2.this.myFormFiles.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                String name = file.getAbsolutePath().replace(File.separatorChar, '/').toLowerCase();
                Javac2.this.log("Comparing with " + name, 3);
                if (!name.endsWith(formFileFullName)) continue;
                FileInputStream formInputStream = new FileInputStream(file);
                LwRootContainer container = Utils.getRootContainer(formInputStream, null);
                this.myFormCache.put(formFileName, container);
                return container;
            }
            InputStream resourceStream = this.myLoader.getResourceAsStream("/" + formFileName + ".form");
            if (resourceStream != null) {
                LwRootContainer container = Utils.getRootContainer(resourceStream, null);
                this.myFormCache.put(formFileName, container);
                return container;
            }
            throw new Exception("Cannot find nested form file " + formFileName);
        }

        public String getClassToBindName(LwRootContainer container) {
            String className = container.getClassToBind();
            String result = Javac2.this.getClassOrInnerName(className.replace('.', '/'));
            if (result != null) {
                return result.replace('/', '.');
            }
            return className;
        }
    }
}

