/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.Compressor;
import com.intellij.spellchecker.compress.Encoder;
import com.intellij.spellchecker.compress.EncodingException;
import com.intellij.spellchecker.compress.UnitBitSet;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.Consumer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class CompressedDictionary
implements Dictionary {
    private final Alphabet alphabet;
    private int wordsCount;
    private byte[][] words;
    private int[] lengths;
    private Encoder encoder;
    private String name;
    private Compressor compressor;
    private final Map<Integer, SortedSet<byte[]>> rawData;
    private static final Comparator<byte[]> COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return CompressedDictionary.compareArrays(o1, o2);
        }
    };

    CompressedDictionary(@NotNull Alphabet alphabet, @NotNull Compressor compressor, @NotNull Encoder encoder, @NotNull String name) {
        if (alphabet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/CompressedDictionary.<init> must not be null");
        }
        if (compressor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/compress/CompressedDictionary.<init> must not be null");
        }
        if (encoder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/spellchecker/compress/CompressedDictionary.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/spellchecker/compress/CompressedDictionary.<init> must not be null");
        }
        this.rawData = new THashMap();
        this.alphabet = alphabet;
        this.compressor = compressor;
        this.encoder = encoder;
        this.name = name;
    }

    void addToDictionary(byte[] word) {
        SortedSet<byte[]> set = this.rawData.get(word.length);
        if (set == null) {
            set = CompressedDictionary.createSet();
            this.rawData.put(word.length, set);
        }
        set.add(word);
        ++this.wordsCount;
    }

    void pack() {
        if (this.rawData == null) {
            return;
        }
        this.lengths = new int[this.rawData.size()];
        this.words = new byte[this.rawData.size()][];
        int row = 0;
        for (Map.Entry<Integer, SortedSet<byte[]>> entry : this.rawData.entrySet()) {
            Integer l = entry.getKey();
            this.lengths[row] = l;
            this.words[row] = new byte[entry.getValue().size() * l];
            int k = 0;
            Iterator i$ = entry.getValue().iterator();
            while (i$.hasNext()) {
                byte[] bytes;
                for (byte aByte : bytes = (byte[])i$.next()) {
                    this.words[row][k++] = aByte;
                }
            }
            ++row;
        }
        this.rawData.clear();
    }

    private static SortedSet<byte[]> createSet() {
        return new TreeSet<byte[]>(COMPARATOR);
    }

    public List<String> getWords(Character first, int minLength, int maxLength) {
        int index = this.alphabet.getIndex(first, false);
        ArrayList<String> result = new ArrayList<String>();
        if (index == -1) {
            return result;
        }
        int i = 0;
        for (byte[] data : this.words) {
            int length = this.lengths[i];
            for (int x = 0; x < data.length; x += length) {
                byte[] toTest = new byte[length];
                System.arraycopy(data, x, toTest, 0, length);
                if (toTest[1] != index || toTest[0] > maxLength || toTest[0] < minLength) continue;
                UnitBitSet set = this.compressor.decompress(toTest);
                result.add(this.encoder.decode(set));
            }
            ++i;
        }
        return result;
    }

    public List<String> getWords(Character first) {
        return this.getWords(first, 0, Integer.MAX_VALUE);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean contains(String word) {
        if (word == null) {
            return false;
        }
        try {
            UnitBitSet bs = this.encoder.encode(word, false);
            byte[] compressed = this.compressor.compress(bs);
            int index = -1;
            for (int i = 0; i < this.lengths.length; ++i) {
                if (this.lengths[i] != compressed.length) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return false;
            }
            return CompressedDictionary.contains(compressed, this.words[index]);
        }
        catch (EncodingException ignored) {
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.wordsCount <= 0;
    }

    @Override
    public void traverse(Consumer<String> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getWords() {
        throw new UnsupportedOperationException();
    }

    public int getAlphabetLength() {
        return this.alphabet.getLastIndexUsed();
    }

    @Override
    public int size() {
        return this.wordsCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CompressedDictionary");
        sb.append("{wordsCount=").append(this.wordsCount);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static CompressedDictionary create(@NotNull Loader loader, final @NotNull Transformation transform) {
        if (loader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/CompressedDictionary.create must not be null");
        }
        if (transform == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/compress/CompressedDictionary.create must not be null");
        }
        Alphabet alphabet = new Alphabet();
        final Encoder encoder = new Encoder(alphabet);
        final Compressor compressor = new Compressor(2);
        final CompressedDictionary dictionary = new CompressedDictionary(alphabet, compressor, encoder, loader.getName());
        loader.load(new Consumer<String>(){

            public void consume(String s) {
                String transformed = transform.transform(s);
                if (transformed != null) {
                    UnitBitSet bs = encoder.encode(transformed, true);
                    byte[] compressed = compressor.compress(bs);
                    dictionary.addToDictionary(compressed);
                }
            }
        });
        dictionary.pack();
        return dictionary;
    }

    public static int compareArrays(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return array1.length < array2.length ? -1 : 1;
        }
        if (Arrays.equals(array1, array2)) {
            return 0;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] < array2[i]) {
                return -1;
            }
            if (array1[i] <= array2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static boolean contains(byte[] goal, byte[] data) {
        return CompressedDictionary.binarySearchNew(goal, 0, data.length / goal.length, data) >= 0;
    }

    public static int binarySearchNew(byte[] goal, int fromIndex, int toIndex, byte[] data) {
        int unitLength = goal.length;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte[] toTest = new byte[unitLength];
            System.arraycopy(data, mid * unitLength, toTest, 0, unitLength);
            int check = CompressedDictionary.compareArrays(toTest, goal);
            if (check == -1) {
                low = mid + 1;
                continue;
            }
            if (check == 1) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

