/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import org.jetbrains.annotations.NotNull;

public final class Alphabet {
    private final Character[] letters;
    private int lastIndexUsed = 0;
    private int maxIndex = 1023;

    public Character getLetter(int position) {
        assert (position < this.maxIndex);
        return this.letters[position];
    }

    public int getIndex(@NotNull Character letter, boolean forceAdd) {
        if (letter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/Alphabet.getIndex must not be null");
        }
        return this.getNextIndex(0, letter, forceAdd);
    }

    public int getNextIndex(int startFrom, @NotNull Character letter, boolean forceAdd) {
        if (letter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/compress/Alphabet.getNextIndex must not be null");
        }
        for (int i = startFrom; i <= this.lastIndexUsed; ++i) {
            if (this.letters[i] == null || !this.letters[i].equals(letter)) continue;
            return i;
        }
        if (!forceAdd) {
            return -1;
        }
        return this.add(letter);
    }

    public int getLastIndexUsed() {
        return this.lastIndexUsed;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int add(@NotNull Character c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/Alphabet.add must not be null");
        }
        ++this.lastIndexUsed;
        this.letters[this.lastIndexUsed] = c;
        return this.lastIndexUsed;
    }

    Alphabet() {
        this.letters = new Character[this.maxIndex];
    }

    Alphabet(int maxIndex) {
        this.maxIndex = maxIndex;
        this.letters = new Character[maxIndex];
    }

    public static Alphabet create(@NotNull CharSequence alphabet) {
        if (alphabet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/compress/Alphabet.create must not be null");
        }
        Alphabet result = new Alphabet(alphabet.length() + 1);
        for (int i = 0; i < alphabet.length(); ++i) {
            result.add(Character.valueOf(alphabet.charAt(i)));
        }
        return result;
    }
}

